/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.server;

import com.openexchange.exception.OXException;
import com.openexchange.server.Initialization;
import java.security.Security;
import java.util.concurrent.atomic.AtomicBoolean;

final class ServerInitialization
implements Initialization {
    private final AtomicBoolean started = new AtomicBoolean();
    private String previousTTL;
    private String previousNegativeTTL;

    ServerInitialization() {
    }

    @Override
    public void start() throws OXException {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        this.previousTTL = Security.getProperty("networkaddress.cache.ttl");
        this.previousNegativeTTL = Security.getProperty("networkaddress.cache.negative.ttl");
        Security.setProperty("networkaddress.cache.ttl", Integer.toString(3600));
        System.setProperty("sun.net.inetaddr.ttl", Integer.toString(3600));
        Security.setProperty("networkaddress.cache.negative.ttl", Integer.toString(10));
    }

    @Override
    public void stop() throws OXException {
        if (!this.started.compareAndSet(true, false)) {
            return;
        }
        if (null == this.previousTTL) {
            Security.setProperty("networkaddress.cache.ttl", "-1");
        } else {
            Security.setProperty("networkaddress.cache.ttl", this.previousTTL);
        }
        if (null == this.previousNegativeTTL) {
            Security.setProperty("networkaddress.cache.negative.ttl", "10");
        } else {
            Security.setProperty("networkaddress.cache.negative.ttl", this.previousNegativeTTL);
        }
    }
}

