/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.i18n;

import com.openexchange.i18n.I18nService;
import com.openexchange.i18n.Translator;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;

public class I18nTranslator
implements Translator {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf(LogFactory.getLog(I18nTranslator.class));
    private final I18nService service;

    public I18nTranslator(I18nService service) {
        this.service = service;
    }

    @Override
    public String translate(String toTranslate) {
        if (!this.service.hasKey(toTranslate)) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)new StringBuilder(64).append("I18n service for locale ").append(this.service.getLocale()).append(" has no translation for \"").append(toTranslate).append("\".").toString());
            }
            return toTranslate;
        }
        return this.service.getLocalized(toTranslate);
    }
}

