/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class LockableQueue<E>
implements Queue<E> {
    private final Queue<E> queue;
    protected final Lock readLock;
    protected final Lock writeLock;

    public LockableQueue(Queue<E> queue) {
        this.queue = queue;
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
    }

    public LockableQueue(Queue<E> queue, Lock lock) {
        this.queue = queue;
        this.readLock = lock;
        this.writeLock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) {
        Lock l = this.writeLock;
        l.lock();
        try {
            boolean bl = this.queue.add(e);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Lock l = this.readLock;
        l.lock();
        try {
            int n = this.queue.size();
            return n;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Lock l = this.readLock;
        l.lock();
        try {
            boolean bl = this.queue.isEmpty();
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        Lock l = this.writeLock;
        l.lock();
        try {
            boolean bl = this.queue.offer(e);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        Lock l = this.readLock;
        l.lock();
        try {
            boolean bl = this.queue.contains(o);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new RWIterator(this.queue.iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove() {
        Lock l = this.writeLock;
        l.lock();
        try {
            E e = this.queue.remove();
            return e;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Lock l = this.readLock;
        l.lock();
        try {
            Object[] objectArray = this.queue.toArray();
            return objectArray;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        Lock l = this.writeLock;
        l.lock();
        try {
            E e = this.queue.poll();
            return e;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E element() {
        Lock l = this.readLock;
        l.lock();
        try {
            E e = this.queue.element();
            return e;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        Lock l = this.readLock;
        l.lock();
        try {
            E e = this.queue.peek();
            return e;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        Lock l = this.readLock;
        l.lock();
        try {
            T[] TArray = this.queue.toArray(a);
            return TArray;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        Lock l = this.writeLock;
        l.lock();
        try {
            boolean bl = this.queue.remove(o);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> c) {
        Lock l = this.readLock;
        l.lock();
        try {
            boolean bl = this.queue.containsAll(c);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> c) {
        Lock l = this.writeLock;
        l.lock();
        try {
            boolean bl = this.queue.addAll(c);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        Lock l = this.writeLock;
        l.lock();
        try {
            boolean bl = this.queue.removeAll(c);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        Lock l = this.writeLock;
        l.lock();
        try {
            boolean bl = this.queue.retainAll(c);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Lock l = this.writeLock;
        l.lock();
        try {
            this.queue.clear();
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object o) {
        Lock l = this.readLock;
        l.lock();
        try {
            boolean bl = this.queue.equals(o);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        Lock l = this.readLock;
        l.lock();
        try {
            int n = this.queue.hashCode();
            return n;
        }
        finally {
            l.unlock();
        }
    }

    private final class RWIterator
    implements Iterator<E> {
        private final Iterator<E> it;

        protected RWIterator(Iterator<E> it) {
            this.it = it;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            Lock l = LockableQueue.this.readLock;
            l.lock();
            try {
                boolean bl = this.it.hasNext();
                return bl;
            }
            finally {
                l.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E next() {
            Lock l = LockableQueue.this.readLock;
            l.lock();
            try {
                Object e = this.it.next();
                return e;
            }
            finally {
                l.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            Lock l = LockableQueue.this.writeLock;
            l.lock();
            try {
                this.it.remove();
            }
            finally {
                l.unlock();
            }
        }
    }
}

