/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.appointment.actions;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.webdav.xml.AppointmentWriter;
import com.openexchange.webdav.xml.appointment.actions.AbstractAppointmentRequest;
import com.openexchange.webdav.xml.appointment.actions.InsertParser;
import com.openexchange.webdav.xml.appointment.actions.InsertResponse;
import com.openexchange.webdav.xml.framework.Constants;
import com.openexchange.webdav.xml.framework.RequestTools;
import com.openexchange.webdav.xml.framework.WebDAVRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.XMLOutputter;

public class InsertRequest
extends AbstractAppointmentRequest<InsertResponse> {
    private final Appointment appointment;

    public InsertRequest(Appointment appointment) {
        this.appointment = appointment;
    }

    @Override
    public WebDAVRequest.Method getMethod() {
        return WebDAVRequest.Method.PUT;
    }

    protected Element createProp() throws OXException, IOException {
        this.appointment.removeObjectID();
        Element eProp = new Element("prop", Constants.NS_DAV);
        AppointmentWriter appointmentWriter = new AppointmentWriter();
        try {
            appointmentWriter.addContent2PropElement(eProp, this.appointment, false, true);
        }
        catch (OXException e) {
            throw new OXException(e);
        }
        return eProp;
    }

    @Override
    public RequestEntity getEntity() throws OXException, IOException {
        Document doc = RequestTools.createPropertyUpdate(this.createProp());
        XMLOutputter xo = new XMLOutputter();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        xo.output(doc, (OutputStream)baos);
        return new ByteArrayRequestEntity(baos.toByteArray());
    }

    public InsertParser getParser() {
        return new InsertParser();
    }
}

