/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test.fixtures.ajax;

import com.openexchange.ajax.contact.action.AllRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.contact.helpers.ContactSetter;
import com.openexchange.groupware.contact.helpers.ContactSwitcher;
import com.openexchange.groupware.container.Contact;
import com.openexchange.test.fixtures.ContactFinder;
import com.openexchange.test.fixtures.SimpleCredentials;
import java.io.IOException;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;

public class AJAXContactFinder
implements ContactFinder {
    private final AJAXClient client;
    private HashMap<Integer, Contact> globalAddressBook;

    public AJAXContactFinder(AJAXClient client) {
        this.client = client;
    }

    private void loadGlobalAddressBook() {
        AllRequest all = new AllRequest(6, Contact.ALL_COLUMNS);
        try {
            CommonAllResponse response = this.client.execute(all);
            this.globalAddressBook = new HashMap();
            JSONArray rows = (JSONArray)response.getData();
            int size = rows.length();
            for (int i = 0; i < size; ++i) {
                JSONArray row = rows.getJSONArray(i);
                Contact contact = new Contact();
                ContactSetter setter = new ContactSetter();
                for (int index = 0; index < Contact.ALL_COLUMNS.length; ++index) {
                    int column = Contact.ALL_COLUMNS[index];
                    ContactField field = ContactField.getByValue((int)column);
                    field.doSwitch((ContactSwitcher)setter, new Object[]{contact, row.get(index)});
                }
                this.globalAddressBook.put(contact.getInternalUserId(), contact);
            }
        }
        catch (OXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Contact getContact(SimpleCredentials credentials) {
        return this.getContact(credentials.getUserId());
    }

    public Contact getContact(int userId) {
        if (this.globalAddressBook == null) {
            this.loadGlobalAddressBook();
        }
        return this.globalAddressBook.get(userId);
    }
}

