/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.structure;

import com.openexchange.configuration.MailConfig;
import com.openexchange.mail.AbstractMailTest;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.structure.StructureHandler;
import com.openexchange.mail.structure.StructureMailMessageParser;
import com.openexchange.mail.structure.handler.MIMEStructureHandler;
import com.openexchange.tools.io.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.json.JSONObject;

public class SMIMEStructureTest2
extends AbstractMailTest {
    private byte[] smime;

    public SMIMEStructureTest2(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        String testMailDir = MailConfig.getProperty(MailConfig.Property.TEST_MAIL_DIR);
        FileInputStream is = new FileInputStream(new File(testMailDir, "smimeStructureTest2.eml"));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.transfer((InputStream)is, (OutputStream)baos);
        ((InputStream)is).close();
        this.smime = baos.toByteArray();
        baos.close();
    }

    public void testMIMEStructure() {
        try {
            this.getSession();
            MailMessage mail = MimeMessageConverter.convertMessage((byte[])this.smime);
            MIMEStructureHandler handler = new MIMEStructureHandler(-1L);
            new StructureMailMessageParser().parseMailMessage(mail, (StructureHandler)handler);
            JSONObject jsonMailObject = handler.getJSONMailObject();
            SMIMEStructureTest2.assertNotNull((String)"Structured JSON mail object is null.", (Object)jsonMailObject);
            System.out.println(jsonMailObject.toString(2));
            SMIMEStructureTest2.assertTrue((String)"Detected a body object, but shouldn't be there.", (!jsonMailObject.hasAndNotNull("body") ? 1 : 0) != 0);
            SMIMEStructureTest2.assertTrue((String)"Missing S/MIME body text.", (boolean)jsonMailObject.hasAndNotNull("smime_body_text"));
            SMIMEStructureTest2.assertTrue((String)"Missing S/MIME body data.", (boolean)jsonMailObject.hasAndNotNull("smime_body_data"));
        }
        catch (Exception e) {
            e.printStackTrace();
            SMIMEStructureTest2.fail((String)e.getMessage());
        }
    }
}

