/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.i18n.impl;

import com.openexchange.i18n.impl.FileDiscoverer;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Locale;
import junit.framework.TestCase;

public class FileDiscovererTest
extends TestCase {
    private FileDiscoverer fileDiscoverer;

    public void setUp() throws FileNotFoundException {
        this.fileDiscoverer = new FileDiscoverer(new File("/tmp"));
    }

    public void testComputeLocale() throws FileNotFoundException {
        this.assertLocale("de", "DE", "de_DE.po");
        this.assertLocale("de", "DE", "server.de_DE.po");
        try {
            this.fileDiscoverer.getLocale("invalidButSurvivable.po");
        }
        catch (Exception x) {
            FileDiscovererTest.fail((String)"Did not ignore invalid filename");
        }
    }

    private void assertLocale(String language, String country, String filename) {
        Locale computedLocale = this.fileDiscoverer.getLocale(filename);
        FileDiscovererTest.assertEquals((String)language, (String)computedLocale.getLanguage());
        FileDiscovererTest.assertEquals((String)country, (String)computedLocale.getCountry());
    }
}

