/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.attach.actions;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentEvent;
import com.openexchange.groupware.attach.AttachmentListener;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.attach.actions.AbstractAttachmentActionTest;
import com.openexchange.groupware.contexts.Context;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractAttachmentEventActionTest
extends AbstractAttachmentActionTest {

    public static final class MockDBProvider
    implements DBProvider {
        private final Set<Connection> read = new HashSet<Connection>();
        private final Set<Connection> write = new HashSet<Connection>();
        private boolean ok = true;
        private boolean called = false;
        private final StringBuffer log = new StringBuffer();
        private final DBProvider delegate;

        public MockDBProvider(DBProvider delegate) {
            this.delegate = delegate;
        }

        public Connection getReadConnection(Context ctx) throws OXException {
            Connection con = this.delegate.getReadConnection(ctx);
            this.read.add(con);
            this.log.append("Get ReadConnection: " + con.hashCode() + "\n");
            this.called = true;
            return con;
        }

        public Connection getWriteConnection(Context ctx) throws OXException {
            Connection con = this.delegate.getWriteConnection(ctx);
            this.write.add(con);
            this.log.append("Get WriteConnection: " + con.hashCode() + "\n");
            this.called = true;
            return con;
        }

        public void releaseReadConnection(Context ctx, Connection con) {
            this.ok(this.read.remove(con));
            this.log.append("Release ReadConnection: " + con.hashCode() + "\n");
            this.delegate.releaseReadConnection(ctx, con);
        }

        public void releaseWriteConnection(Context ctx, Connection con) {
            this.ok(this.write.remove(con));
            this.log.append("Release WriteConnection: " + con + "\n");
            this.delegate.releaseWriteConnection(ctx, con);
        }

        private void ok(boolean b) {
            this.ok = this.ok && b;
        }

        public boolean allOK() {
            return this.ok && this.read.isEmpty() && this.write.isEmpty();
        }

        public boolean called() {
            return this.called;
        }

        public String getStatus() {
            return String.format("OK : %s ReadIds: %s WriteIds: %s Called: %s \n LOG: %s", String.valueOf(this.ok), this.read.toString(), this.write.toString(), String.valueOf(this.called), this.log.toString());
        }
    }

    protected static final class MockAttachmentListener
    implements AttachmentListener {
        List<AttachmentMetadata> attached = new ArrayList<AttachmentMetadata>();
        Set<Integer> detached = new HashSet<Integer>();

        protected MockAttachmentListener() {
        }

        public long attached(AttachmentEvent e) throws Exception {
            this.attached.add(e.getAttachment());
            e.getWriteConnection();
            return System.currentTimeMillis();
        }

        public long detached(AttachmentEvent e) throws Exception {
            for (int id : e.getDetached()) {
                this.detached.add(id);
            }
            e.getWriteConnection();
            return System.currentTimeMillis();
        }

        public List<AttachmentMetadata> getAttached() {
            return this.attached;
        }

        public Set<Integer> getDetached() {
            return this.detached;
        }

        public void clear() {
            this.attached.clear();
            this.detached.clear();
        }
    }
}

