/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav.tests;

import com.openexchange.ajax.contact.AbstractContactTest;
import com.openexchange.dav.SyncToken;
import com.openexchange.dav.carddav.CardDAVTest;
import com.openexchange.dav.carddav.VCardResource;
import com.openexchange.groupware.container.Contact;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.sourceforge.cardme.vcard.EncodingType;
import net.sourceforge.cardme.vcard.features.PhotoFeature;
import net.sourceforge.cardme.vcard.types.PhotoType;
import net.sourceforge.cardme.vcard.types.media.ImageMediaType;
import org.junit.Assert;

public class ImageTest
extends CardDAVTest {
    public ImageTest(String name) {
        super(name);
    }

    public void testCroppedImage() throws Exception {
        String syncToken = super.fetchSyncToken();
        String uid = ImageTest.randomUID();
        String firstName = "bild";
        String lastName = "otto";
        String vCard = "BEGIN:VCARD\r\nVERSION:3.0\r\nPRODID:-//Apple Inc.//Address Book 6.1//EN\r\nN:" + lastName + ";" + firstName + ";;;" + "\r\n" + "FN:" + firstName + " " + lastName + "\r\n" + "PHOTO;ENCODING=b;TYPE=JPEG;X-ABCROP-RECTANGLE=ABClipRect_1&11&11&25&25&ZNtYcAgH/lm2pubKd1ul0g==:" + "\r\n" + " /9j/4AAQSkZJRgABAQAAAQABAAD/4QBARXhpZgAATU0AKgAAAAgAAYdpAAQAAAABAAAAGgAAAA" + "\r\n" + " AAAqACAAQAAAABAAAAMKADAAQAAAABAAAAMAAAAAD/2wBDAAIBAQIBAQICAQICAgICAwUDAwMD" + "\r\n" + " AwYEBAMFBwYHBwcGBgYHCAsJBwgKCAYGCQ0JCgsLDAwMBwkNDg0MDgsMDAv/2wBDAQICAgMCAw" + "\r\n" + " UDAwULCAYICwsLCwsLCwsLCwsLCwsLCwsLCwsLCwsLCwsLCwsLCwsLCwsLCwsLCwsLCwsLCwsL" + "\r\n" + " Cwv/wAARCAAwADADASIAAhEBAxEB/8QAHwAAAQUBAQEBAQEAAAAAAAAAAAECAwQFBgcICQoL/8" + "\r\n" + " QAtRAAAgEDAwIEAwUFBAQAAAF9AQIDAAQRBRIhMUEGE1FhByJxFDKBkaEII0KxwRVS0fAkM2Jy" + "\r\n" + " ggkKFhcYGRolJicoKSo0NTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqDhI" + "\r\n" + " WGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uHi4+Tl" + "\r\n" + " 5ufo6erx8vP09fb3+Pn6/8QAHwEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoL/8QAtREAAg" + "\r\n" + " ECBAQDBAcFBAQAAQJ3AAECAxEEBSExBhJBUQdhcRMiMoEIFEKRobHBCSMzUvAVYnLRChYkNOEl" + "\r\n" + " 8RcYGRomJygpKjU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6goOEhYaHiI" + "\r\n" + " mKkpOUlZaXmJmaoqOkpaanqKmqsrO0tba3uLm6wsPExcbHyMnK0tPU1dbX2Nna4uPk5ebn6Onq" + "\r\n" + " 8vP09fb3+Pn6/9oADAMBAAIRAxEAPwD997+/g0qxnutUnitra2jaWaaVwkcSKMszMeAAASSeAB" + "\r\n" + " Xzb8Q/2p/Evxu8KX3/AAyVEttoRXyP+ErvISY7t2YKP7Njz++GMnzm+UZ4BIr5r/4Ltf8ABRjw" + "\r\n" + " /wDDPUdF+BDX+owL4miXUfGL2NvvuF0vdmOzhYsoD3DoVZs/LGrDOWxXT/sJf8FCvD/xN+Fc0m" + "\r\n" + " n6BF4Y8I+FiILNdRu1DxQxpjzGVQEijHzKACw+Q4I6V8ZnmbVJYlYOjUdOP2pJat9ovp5ta9E0" + "\r\n" + " 0z9jyHwzzFcPw4onhvaU3LSLso8t7JvVOTlK6jFXSiuaV00e2eF/2Zn+IehwH9ojW/G2v3MSEl" + "\r\n" + " pNclt7QqQN37qHy9ucc8n+lfEf7b3j28/ZRa90L9hHxD8VtK8T2yiWc3WvTnS4YwxUGO2vA5nH" + "\r\n" + " BCkFU64Lcivtrxv+2XY674EN14Rk0+0hlUNELpXJmXsxRSpRT1APPTPcD4a/a5/bG8UeF/DOp6" + "\r\n" + " jdeFPA3jG3eEQ3dv5V0ktvEpZhPEvmMXZCxJClWxyM4wfBxWDoShfByfOvt68z8k27v8fI+q8N" + "\r\n" + " 1z5qpZrhlOi2l7FtRpXvvJW5bK70vFX3dj1/9jH/AIK7+Lvh18L/AAvJ/wAFHNMWPw9rcKJY+P" + "\r\n" + " 8ATLc/Zom8wxldYgBzasGG0zoDGSOQpNfo1YahBqtjBdaXPDc21zGssM0Th45UYZVlYcEEEEEc" + "\r\n" + " EGv5o/C//BTSWfwHd/DXxxpA1/whrVzc3Fq8d2fPtTNGN0Y+UieLO47XxzIWLHAr9FP+Ddj/AI" + "\r\n" + " KRQfEzS9S/Z78e3l3car4NtXv/AAncXEJ8y60kPh7eRwSC9u0iKpJ5jdRn5a9/hrO62Kf1bE3b" + "\r\n" + " tdO33p/p1Ovxi8H45Fha3EGWU4woxquMoRleKjLWEoq7asmlNbapx0ufGP8AwUs+Inhb4x/8FR" + "\r\n" + " Pjj/wtrUFiXSpU0DT5dyq1ubKBSu3dgZDtKMZAYE5POa8Q0j9ttdf8R6H4b8MRfZPCejW3lmAs" + "\r\n" + " Gk1KSPayPOFxuVXLOEORuO45PTa/4ODvhZ/wp/8A4Kz/ABBhilKW3jq0stf3AFB+9hEbjGefng" + "\r\n" + " bJzzz0zXxD4s1SX4fXVneabe/aLqQtG+6MISMd8d68qrlNWOPqV6jbvJtdr/0tO35fs2TcQUcT" + "\r\n" + " wNhKNCklRhTgnrs9Fe2ju73dk93trzfpsn7XztYfvrwhY48uzPhT+J7V4p8ef+CiOm6BFcReHz" + "\r\n" + " c67qK5VY7YkRIenzykYHTGF3H1r44tvFmq+JVt5PFF5NMoYGK33Yij567ehPuea+xf25f2RofE" + "\r\n" + " uiXnjj4cJFa6nbRedqdoMLHfKBzKnYSDuON2M/e+97H1OnhqlKGJb9++2yatv6337nkYHh55pg" + "\r\n" + " 51aEbSjbRLVp/8Ntu156HyN4c+O91b+KtX1PU9JsbdNUnMjLDGY1sweSqZ6KTyR68194f8EbfH" + "\r\n" + " 1r8IP+Cqvwd1HRJY7k+KHn0G5kV/MjKXdu5AUKecSLFz0yuegr84ZNNh8W2zpdXk9ogdhsVB++" + "\r\n" + " K4yDnByMjj8fp+gv8Awbl+CB8Z/wDgp34Bsrgt5Hw8sLvW1fYWUiKLyYlPPXM+Bk9gecVdXI6l" + "\r\n" + " HFU8RRdkpa+ell+O/wB5WO4rjS4PzLKMztPD+xl7JvlupXu0rarTVN+i0sfqJ/wcNf8ABLxf2z" + "\r\n" + " PgfH45+G9msnj7wWjTWOwMJLxNvz27NnG2QIgUHAEip/fav535/Cv/AAmGox2Oqo2narYu6Sw3" + "\r\n" + " KNFKkijGx1PKsCMYIGDnNf2g3NtHeW8kN5GksUqlHR1DK6kYIIPBBHavzw/4Kb/8EDvBn7Y2/w" + "\r\n" + " ASfCUJ4a8cQjdFfRbVeUhhtSUHCzIBx85DgDh+cV7GYYSVWLlT38t15n89+GXiHhuHv+E3Noc+" + "\r\n" + " GlJN+Wq+a8n09D+fTWPgWV02zg8FTyz6tEjSMpO5bpgy/Ino2C2PXFfVnwN8XaX8b/hL4nT4v6" + "\r\n" + " nqs8WnJF/Z8Ekj26w+WSPMm24ZyW2jaSQAQSC33dT4sf8ABFD9pD4DyLcwWtlrsIkLRNEkto7h" + "\r\n" + " cdFZSD1Gfm71sfCD/gi9+0F8Z7NHuraz0WKJFR8Rz3Ui5B4YRhQBwSPnxxXlwwOZSoRVROSW0r" + "\r\n" + " ary1t5dnv0P7Hw/G/BNKhUx+ExCo0pKF4RlHVw0Vpczs2nLm/m0b63+StX8LaZZXN7b6VpkGt6" + "\r\n" + " xq19utEt4nlldyAgRI+S7MQexYnFfvR/wQH/AOCZEP7G3wVfxj47sYofHXi9RPqGVO61G35LdG" + "\r\n" + " HGyNXdTjIMjyH+Fa0f+CYv/BDzwh+yBotrrvxHX+3vGM8QaTULlALiPJyY0XBFuhHVUO87vmbK" + "\r\n" + " 4r7+t7eOzt44bSNIoolCIiKFVFAwAAOgA7V6mBwlWm3OvK7vp/W33H8o+MXivhOMOXLMloKnho" + "\r\n" + " O7fWb6u+7V+rbb9D//2Q==" + "\r\n" + "REV:2012-05-24T09:51:40Z" + "\r\n" + "UID:" + uid + "\r\n" + "END:VCARD";
        ImageTest.assertEquals((String)"response code wrong", (int)201, (int)super.putVCard(uid, vCard));
        Contact contact = super.getContact(uid);
        super.rememberForCleanUp(contact);
        ImageTest.assertEquals((String)"uid wrong", (String)uid, (String)contact.getUid());
        ImageTest.assertEquals((String)"firstname wrong", (String)firstName, (String)contact.getGivenName());
        ImageTest.assertEquals((String)"lastname wrong", (String)lastName, (String)contact.getSurName());
        ImageTest.assertEquals((String)"wrong numer of images", (int)1, (int)contact.getNumberOfImages());
        ImageTest.assertNotNull((String)"no image found in contact", (Object)contact.getImage1());
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(contact.getImage1()));
        ImageTest.assertEquals((String)"image width wrong", (int)25, (int)image.getWidth());
        ImageTest.assertEquals((String)"image height wrong", (int)25, (int)image.getHeight());
        Map<String, String> eTags = super.syncCollection(syncToken);
        ImageTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = ImageTest.assertContains(uid, addressData);
        ImageTest.assertEquals((String)"N wrong", (String)firstName, (String)card.getVCard().getName().getGivenName());
        ImageTest.assertEquals((String)"N wrong", (String)lastName, (String)card.getVCard().getName().getFamilyName());
        ImageTest.assertEquals((String)"FN wrong", (String)(firstName + " " + lastName), (String)card.getVCard().getFormattedName().getFormattedName());
        ImageTest.assertTrue((String)"PHOTO wrong", (boolean)card.getVCard().getPhotos().hasNext());
        byte[] vCardPhoto = ((PhotoFeature)card.getVCard().getPhotos().next()).getPhoto();
        ImageTest.assertNotNull((String)"POHTO wrong", (Object)vCardPhoto);
        Assert.assertArrayEquals((String)"image data wrong", (byte[])contact.getImage1(), (byte[])vCardPhoto);
    }

    public void testNegativeCropOffset() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String uid = ImageTest.randomUID();
        String firstName = "bild";
        String lastName = "wurst";
        String vCard = "BEGIN:VCARD\r\nVERSION:3.0\r\nPRODID:-//Apple Inc.//Address Book 6.1//EN\r\nN:" + lastName + ";" + firstName + ";;;" + "\r\n" + "FN:" + firstName + " " + lastName + "\r\n" + "PHOTO;ENCODING=b;TYPE=JPEG;X-ABCROP-RECTANGLE=ABClipRect_1&-76&-76&200&200&XKZcdOASW3junIR92qq6RA==:" + "\r\n" + " /9j/4AAQSkZJRgABAQAAAQABAAD/4QBARXhpZgAATU0AKgAAAAgAAYdpAAQAAAABAAAAGgAAAA" + "\r\n" + " AAAqACAAQAAAABAAAAMKADAAQAAAABAAAAMAAAAAD/2wBDAAIBAQIBAQICAQICAgICAwUDAwMD" + "\r\n" + " AwYEBAMFBwYHBwcGBgYHCAsJBwgKCAYGCQ0JCgsLDAwMBwkNDg0MDgsMDAv/2wBDAQICAgMCAw" + "\r\n" + " UDAwULCAYICwsLCwsLCwsLCwsLCwsLCwsLCwsLCwsLCwsLCwsLCwsLCwsLCwsLCwsLCwsLCwsL" + "\r\n" + " Cwv/wAARCAAwADADASIAAhEBAxEB/8QAHwAAAQUBAQEBAQEAAAAAAAAAAAECAwQFBgcICQoL/8" + "\r\n" + " QAtRAAAgEDAwIEAwUFBAQAAAF9AQIDAAQRBRIhMUEGE1FhByJxFDKBkaEII0KxwRVS0fAkM2Jy" + "\r\n" + " ggkKFhcYGRolJicoKSo0NTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqDhI" + "\r\n" + " WGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uHi4+Tl" + "\r\n" + " 5ufo6erx8vP09fb3+Pn6/8QAHwEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoL/8QAtREAAg" + "\r\n" + " ECBAQDBAcFBAQAAQJ3AAECAxEEBSExBhJBUQdhcRMiMoEIFEKRobHBCSMzUvAVYnLRChYkNOEl" + "\r\n" + " 8RcYGRomJygpKjU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6goOEhYaHiI" + "\r\n" + " mKkpOUlZaXmJmaoqOkpaanqKmqsrO0tba3uLm6wsPExcbHyMnK0tPU1dbX2Nna4uPk5ebn6Onq" + "\r\n" + " 8vP09fb3+Pn6/9oADAMBAAIRAxEAPwD96/Fvi3TPAfhm+1nxnf2umaVpkLXF1d3MgjigjUZLMx" + "\r\n" + " 6Cvzp1X/gpT8aP+Cj3jTWPDH/BMHTdM8HeBdKmks9S+JHiGEyB2UHelhBg73CEPjaxUYJZMivD" + "\r\n" + " v+DkP9ufV/GnjGy+AXwgvjFpdl5V34nntyN01w/+rti4JwqI+9lIHzMAQdor70/4JofBHwN4D+" + "\r\n" + " COj2nwWvr+fRPDtgNG+wXVssRgmKo8sjMnEryFi5cdTIScE4H6vhOGqPC/D9LiHMaKqVa7fsoS" + "\r\n" + " TcIxVvfmtpOV1yRl7ltZc11E+VebRzXMKmXUKvKqfxWdpN9k+iXVrW+mi1fgWh/8EgtD8X3X9o" + "\r\n" + " ftM/tD/Gzx3rlwwkuGttTi0uzaTJJKQ7ZCASf7+a+uG/ZM8O6Xtm8A6nquhXqLhZ7WXymzjGS0" + "\r\n" + " Wxjkcda8K/aO8WaL+z943/sPSvEGqajrMbpJNDJbrHBao4DIC+cu20g8cep7V9NReIyYkIbqoP" + "\r\n" + " 6V83xZWxeKp4aviJ80JKTguRQSXu/DGMYpJ6bK3Y9LLIYanUqwoL3lbm1bd9d229dzk4fip4t+" + "\r\n" + " BOow2vxaD+JNAkBWPUbeMG7iwBgHG0SDg5BAfkkF+leyaBr9l4q0W21Hw5dQ3tjeRiWGaJtySK" + "\r\n" + " e4P+cV514mlg8S+H7ux1ILJFPGRg87TjIYe4NcH+zZ8RLnwH8Q18Ka5OzaRrRdrFXORa3QBcqp" + "\r\n" + " J+VZFDnHTzFyBmQk/GHsH4j/ABO1T/hc/wC078QfFHjWcSXur67eTMWxyPOYBfQAKAPwFfWnww" + "\r\n" + " /4KJ678PPgTovgn4fal/wj8lhM13fajG4a51GXcNvzdEQIsalcEsVOTg7a+Rv2nPhvN8IPj740" + "\r\n" + " 0XU45Yryw1q6hmGepErc8ccgg8cVwH9oH1l/76P+NfteN+kRwFiMNQy7H4evJUOVJezg0nFcu3" + "\r\n" + " tNUul12drpHNgfoFeMOZ1Z55lGY4SNPEx5k/bVLuE7TWqo6N6ap91ezZ9n/tdftot8btf0jxBq" + "\r\n" + " 8Vpb66lpFZX81tkR3zJIdkoTnY21grDJBxkYHyj9VYHb7NFkn/Vr39hX87E1ytwymcSMUIYZJO" + "\r\n" + " D19a+oE/4LH/HSNAq69o+FGBnRLY8D/gNflHiB4v8ACmdUsHRyalVjGlzpqUIqyly2S996Kz9F" + "\r\n" + " ZI/ZvD/6E/ijk31medYrCznUcWmqtR3tzXv+5Xderuz9g79pHt2SHcSwwT6CvKvitNJ4O1HStY" + "\r\n" + " sVQz6VeQ3iBgcMY5FfBwc4IUqeRwTX5pf8Pkfjr/0HtH/8Edr/APEV1/7Pv7cvxf8A2s/jl4Q8" + "\r\n" + " HeJdZ02SDXtUgtJQulwxARs43ksi5A2g8ivzuhxvl+JqRpQjPmk0lot27fzH2ub/AEWeL8jwNf" + "\r\n" + " McXXwyp0oSnK1Sp8MU5P8A5dLoj3P/AILg/sSy2PjiD4seDrNG0rVxHZ62sYUGC6AISYqAPldV" + "\r\n" + " ALc/MuSRuGfgzT/gy+qIGsoy+f7ozX9Fvinwtp3jbw7e6R4usrfUdM1GJoLm2nQPHMh6gg1+e/" + "\r\n" + " x3/wCCTXiT4Ta5ca5+y68XiPRizStol1II7y2GWO2J2IWVQAAASG5wAeteHxZwpWr1pY3BRvf4" + "\r\n" + " ore/dd79Vvf8Ps/Bfx8hlOVU+Hc4q8jpaUqkn7rj0hN/Zcdoyfu8tk2rLm/OP/hQd3/z7Sf980" + "\r\n" + " f8KDu/+faT/vmvubQfFth4WkNh8XPAuvaVfwko6yabJww4IyFwcHril1zxFB4ymFh8GPh/4k1m" + "\r\n" + " /lBEYh0uU5IGSc7ccAHv2NfnX1DFc/J7KV+1nf7rH7b/AMRexXN/DXJ/P7SHJbvzc1rfM+DtQ+" + "\r\n" + " Db6Wm68jKfUYr9BP8AgiD+w/cW3iOX4teOLAw6fbxPa6AJkwbiQ/LJcKCOVUblDf3icH5TXU/s" + "\r\n" + " 9f8ABJnXPiX4kh8QftXFNG0dSJYtCtJla6uDwVE7gFUTnlQS3BB21+gfhzw5YeENCtNM8MWkFh" + "\r\n" + " p9jEIbe3hQKkSDoABX6PwlwpVw1VY3GRs18Met+77eS3vqfhvjV49QzrK58O5PV5/aaVakfh5d" + "\r\n" + " +SD+1d/FJe7y6K93b//Z" + "\r\n" + "REV:2012-05-24T12:32:30Z" + "\r\n" + "UID:" + uid + "\r\n" + "END:VCARD";
        ImageTest.assertEquals((String)"response code wrong", (int)201, (int)super.putVCard(uid, vCard));
        Contact contact = super.getContact(uid);
        super.rememberForCleanUp(contact);
        ImageTest.assertEquals((String)"uid wrong", (String)uid, (String)contact.getUid());
        ImageTest.assertEquals((String)"firstname wrong", (String)firstName, (String)contact.getGivenName());
        ImageTest.assertEquals((String)"lastname wrong", (String)lastName, (String)contact.getSurName());
        ImageTest.assertEquals((String)"wrong numer of images", (int)1, (int)contact.getNumberOfImages());
        ImageTest.assertNotNull((String)"no image found in contact", (Object)contact.getImage1());
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(contact.getImage1()));
        ImageTest.assertEquals((String)"image width wrong", (int)200, (int)image.getWidth());
        ImageTest.assertEquals((String)"image height wrong", (int)200, (int)image.getHeight());
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        ImageTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = ImageTest.assertContains(uid, addressData);
        ImageTest.assertEquals((String)"N wrong", (String)firstName, (String)card.getVCard().getName().getGivenName());
        ImageTest.assertEquals((String)"N wrong", (String)lastName, (String)card.getVCard().getName().getFamilyName());
        ImageTest.assertEquals((String)"FN wrong", (String)(firstName + " " + lastName), (String)card.getVCard().getFormattedName().getFormattedName());
        ImageTest.assertTrue((String)"PHOTO wrong", (boolean)card.getVCard().getPhotos().hasNext());
        byte[] vCardPhoto = ((PhotoFeature)card.getVCard().getPhotos().next()).getPhoto();
        ImageTest.assertNotNull((String)"POHTO wrong", (Object)vCardPhoto);
        Assert.assertArrayEquals((String)"image data wrong", (byte[])contact.getImage1(), (byte[])vCardPhoto);
    }

    public void testAddPhotoOnServer() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String uid = ImageTest.randomUID();
        String firstName = "test";
        String lastName = "kimberly";
        Contact contact = new Contact();
        contact.setSurName(lastName);
        contact.setGivenName(firstName);
        contact.setDisplayName(firstName + " " + lastName);
        contact.setUid(uid);
        super.rememberForCleanUp(super.create(contact));
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        ImageTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = ImageTest.assertContains(uid, addressData);
        ImageTest.assertEquals((String)"N wrong", (String)firstName, (String)card.getVCard().getName().getGivenName());
        ImageTest.assertEquals((String)"N wrong", (String)lastName, (String)card.getVCard().getName().getFamilyName());
        ImageTest.assertEquals((String)"FN wrong", (String)(firstName + " " + lastName), (String)card.getVCard().getFormattedName().getFormattedName());
        String updatedFirstName = "test2";
        String udpatedLastName = "waldemar2";
        contact.setSurName(udpatedLastName);
        contact.setGivenName(updatedFirstName);
        contact.setDisplayName(updatedFirstName + " " + udpatedLastName);
        contact.setImage1(AbstractContactTest.image);
        contact.setImageContentType("image/png");
        contact = super.update(contact);
        eTags = super.syncCollection(syncToken).getETagsStatusOK();
        ImageTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        addressData = super.addressbookMultiget(eTags.keySet());
        card = ImageTest.assertContains(uid, addressData);
        ImageTest.assertEquals((String)"N wrong", (String)updatedFirstName, (String)card.getVCard().getName().getGivenName());
        ImageTest.assertEquals((String)"N wrong", (String)udpatedLastName, (String)card.getVCard().getName().getFamilyName());
        ImageTest.assertEquals((String)"FN wrong", (String)(updatedFirstName + " " + udpatedLastName), (String)card.getVCard().getFormattedName().getFormattedName());
        ImageTest.assertTrue((String)"PHOTO wrong", (boolean)card.getVCard().getPhotos().hasNext());
        byte[] vCardPhoto = ((PhotoFeature)card.getVCard().getPhotos().next()).getPhoto();
        ImageTest.assertNotNull((String)"POHTO wrong", (Object)vCardPhoto);
        Assert.assertArrayEquals((String)"image data wrong", (byte[])contact.getImage1(), (byte[])vCardPhoto);
    }

    public void testAddPhotoOnClient() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String uid = ImageTest.randomUID();
        String firstName = "test";
        String lastName = "jaqueline";
        Contact contact = new Contact();
        contact.setSurName(lastName);
        contact.setGivenName(firstName);
        contact.setDisplayName(firstName + " " + lastName);
        contact.setUid(uid);
        super.rememberForCleanUp(super.create(contact));
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        ImageTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = ImageTest.assertContains(uid, addressData);
        ImageTest.assertEquals((String)"N wrong", (String)firstName, (String)card.getVCard().getName().getGivenName());
        ImageTest.assertEquals((String)"N wrong", (String)lastName, (String)card.getVCard().getName().getFamilyName());
        ImageTest.assertEquals((String)"FN wrong", (String)(firstName + " " + lastName), (String)card.getVCard().getFormattedName().getFormattedName());
        PhotoType photo = new PhotoType();
        photo.setImageMediaType(ImageMediaType.PNG);
        photo.setEncodingType(EncodingType.BINARY);
        photo.setPhoto(AbstractContactTest.image);
        card.getVCard().addPhoto((PhotoFeature)photo);
        ImageTest.assertEquals((String)"response code wrong", (int)201, (int)super.putVCardUpdate(card.getUID(), card.toString(), "\"" + card.getETag() + "\""));
        Contact updatedContact = super.getContact(uid);
        super.rememberForCleanUp(updatedContact);
        ImageTest.assertEquals((String)"wrong numer of images", (int)1, (int)updatedContact.getNumberOfImages());
        ImageTest.assertNotNull((String)"no image found in contact", (Object)updatedContact.getImage1());
        eTags = super.syncCollection(syncToken).getETagsStatusOK();
        ImageTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        addressData = super.addressbookMultiget(eTags.keySet());
        card = ImageTest.assertContains(uid, addressData);
        ImageTest.assertTrue((String)"PHOTO wrong", (boolean)card.getVCard().getPhotos().hasNext());
        byte[] vCardPhoto = ((PhotoFeature)card.getVCard().getPhotos().next()).getPhoto();
        ImageTest.assertNotNull((String)"POHTO wrong", (Object)vCardPhoto);
        Assert.assertArrayEquals((String)"image data wrong", (byte[])updatedContact.getImage1(), (byte[])vCardPhoto);
    }

    public void testRemovePhotoOnServer() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String uid = ImageTest.randomUID();
        String firstName = "test";
        String lastName = "kimberly";
        Contact contact = new Contact();
        contact.setSurName(lastName);
        contact.setGivenName(firstName);
        contact.setDisplayName(firstName + " " + lastName);
        contact.setImage1(AbstractContactTest.image);
        contact.setImageContentType("image/png");
        contact.setUid(uid);
        super.rememberForCleanUp(super.create(contact));
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        ImageTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = ImageTest.assertContains(uid, addressData);
        ImageTest.assertEquals((String)"N wrong", (String)firstName, (String)card.getVCard().getName().getGivenName());
        ImageTest.assertEquals((String)"N wrong", (String)lastName, (String)card.getVCard().getName().getFamilyName());
        ImageTest.assertEquals((String)"FN wrong", (String)(firstName + " " + lastName), (String)card.getVCard().getFormattedName().getFormattedName());
        ImageTest.assertTrue((String)"PHOTO wrong", (boolean)card.getVCard().getPhotos().hasNext());
        byte[] vCardPhoto = ((PhotoFeature)card.getVCard().getPhotos().next()).getPhoto();
        ImageTest.assertNotNull((String)"POHTO wrong", (Object)vCardPhoto);
        Assert.assertArrayEquals((String)"image data wrong", (byte[])contact.getImage1(), (byte[])vCardPhoto);
        contact.setImage1(null);
        contact.setNumberOfImages(0);
        contact = super.update(contact);
        eTags = super.syncCollection(syncToken).getETagsStatusOK();
        ImageTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        addressData = super.addressbookMultiget(eTags.keySet());
        card = ImageTest.assertContains(uid, addressData);
        ImageTest.assertFalse((String)"PHOTO wrong", (boolean)card.getVCard().getPhotos().hasNext());
    }

    public void testRemovePhotoOnClient() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String uid = ImageTest.randomUID();
        String firstName = "test";
        String lastName = "kimberly";
        Contact contact = new Contact();
        contact.setSurName(lastName);
        contact.setGivenName(firstName);
        contact.setDisplayName(firstName + " " + lastName);
        contact.setImage1(AbstractContactTest.image);
        contact.setImageContentType("image/png");
        contact.setUid(uid);
        super.rememberForCleanUp(super.create(contact));
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        ImageTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = ImageTest.assertContains(uid, addressData);
        ImageTest.assertEquals((String)"N wrong", (String)firstName, (String)card.getVCard().getName().getGivenName());
        ImageTest.assertEquals((String)"N wrong", (String)lastName, (String)card.getVCard().getName().getFamilyName());
        ImageTest.assertEquals((String)"FN wrong", (String)(firstName + " " + lastName), (String)card.getVCard().getFormattedName().getFormattedName());
        ImageTest.assertTrue((String)"PHOTO wrong", (boolean)card.getVCard().getPhotos().hasNext());
        byte[] vCardPhoto = ((PhotoFeature)card.getVCard().getPhotos().next()).getPhoto();
        ImageTest.assertNotNull((String)"POHTO wrong", (Object)vCardPhoto);
        Assert.assertArrayEquals((String)"image data wrong", (byte[])contact.getImage1(), (byte[])vCardPhoto);
        card.getVCard().removePhoto((PhotoFeature)card.getVCard().getPhotos().next());
        ImageTest.assertEquals((String)"response code wrong", (int)201, (int)super.putVCardUpdate(card.getUID(), card.toString(), "\"" + card.getETag() + "\""));
        Contact updatedContact = super.getContact(uid);
        super.rememberForCleanUp(updatedContact);
        ImageTest.assertEquals((String)"wrong numer of images", (int)0, (int)updatedContact.getNumberOfImages());
        ImageTest.assertNull((String)"image found in contact", (Object)updatedContact.getImage1());
        eTags = super.syncCollection(syncToken).getETagsStatusOK();
        ImageTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        addressData = super.addressbookMultiget(eTags.keySet());
        card = ImageTest.assertContains(uid, addressData);
        ImageTest.assertFalse((String)"PHOTO wrong", (boolean)card.getVCard().getPhotos().hasNext());
    }
}

