/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.contactcollector;

import com.openexchange.contactcollector.osgi.CCServiceRegistry;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.contact.ContactInterface;
import com.openexchange.groupware.contact.ContactInterfaceDiscoveryService;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.search.ContactSearchObject;
import com.openexchange.groupware.search.Order;
import com.openexchange.session.Session;
import com.openexchange.setuptools.TestConfig;
import com.openexchange.setuptools.TestContextToolkit;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import java.util.ArrayList;
import junit.framework.TestCase;

public class OrderByTest
extends TestCase {
    private String user;
    private Context ctx;
    private int userId;
    private Session session;
    private FolderObject contactFolder;

    public void setUp() throws Exception {
        String contextName;
        Init.startServer();
        TestConfig config = new TestConfig();
        this.user = config.getUser();
        int pos = this.user.indexOf(64);
        if (pos == -1) {
            contextName = config.getContextName();
        } else {
            contextName = this.user.substring(pos + 1);
            this.user = this.user.substring(0, pos);
        }
        TestContextToolkit tools = new TestContextToolkit();
        this.ctx = tools.getContextByName(contextName);
        this.userId = tools.resolveUser(this.user, this.ctx);
        this.session = tools.getSessionForUser(this.user, this.ctx);
        this.contactFolder = this.getStandardContactFolder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOrderByUserfield20() throws Throwable {
        ContactInterface contactInterface = ((ContactInterfaceDiscoveryService)CCServiceRegistry.getInstance().getService(ContactInterfaceDiscoveryService.class)).getContactInterfaceProvider(this.contactFolder.getObjectID(), this.ctx.getContextId()).newContactInterface(this.session);
        Contact contact1 = new Contact();
        Contact contact2 = new Contact();
        Contact contact3 = new Contact();
        contact1.setParentFolderID(this.contactFolder.getObjectID());
        contact2.setParentFolderID(this.contactFolder.getObjectID());
        contact3.setParentFolderID(this.contactFolder.getObjectID());
        contact1.setSurName("orderbyTest_contact1");
        contact2.setSurName("orderbyTest_contact2");
        contact3.setSurName("orderbyTest_contact3");
        contact1.setEmail1("orderbyTest@contact1.com");
        contact2.setEmail1("orderbyTest@contact2.com");
        contact3.setEmail1("orderbyTest@contact3.com");
        contact1.setUserField20("3");
        contact2.setUserField20("1");
        contact3.setUserField20("2");
        try {
            contactInterface.insertContactObject(contact1);
            contactInterface.insertContactObject(contact2);
            contactInterface.insertContactObject(contact3);
            ContactSearchObject searchObject = new ContactSearchObject();
            searchObject.setEmailAutoComplete(true);
            searchObject.setDynamicSearchField(new int[]{555, 556, 557});
            searchObject.setDynamicSearchFieldValue(new String[]{"orderbyTest", "orderbyTest", "orderbyTest"});
            int[] columns = new int[]{20, 5, 1, 502};
            SearchIterator iterator = contactInterface.getContactsByExtendedSearch(searchObject, 590, Order.ASCENDING, null, columns);
            ArrayList<String> surnames = new ArrayList<String>();
            while (iterator.hasNext()) {
                Contact foundContact = (Contact)iterator.next();
                if (!foundContact.getSurName().startsWith("orderbyTest_")) continue;
                surnames.add(foundContact.getSurName());
            }
            OrderByTest.assertEquals((int)3, (int)surnames.size());
            OrderByTest.assertEquals((String)"Contact on wrong position", (String)"orderbyTest_contact2", (String)((String)surnames.get(0)));
            OrderByTest.assertEquals((String)"Contact on wrong position", (String)"orderbyTest_contact3", (String)((String)surnames.get(1)));
            OrderByTest.assertEquals((String)"Contact on wrong position", (String)"orderbyTest_contact1", (String)((String)surnames.get(2)));
        }
        finally {
            contactInterface.deleteContactObject(contact1.getObjectID(), this.contactFolder.getObjectID(), contact1.getLastModified());
            contactInterface.deleteContactObject(contact2.getObjectID(), this.contactFolder.getObjectID(), contact2.getLastModified());
            contactInterface.deleteContactObject(contact3.getObjectID(), this.contactFolder.getObjectID(), contact3.getLastModified());
        }
    }

    private FolderObject getStandardContactFolder() {
        OXFolderAccess access = new OXFolderAccess(this.ctx);
        FolderObject fo = null;
        try {
            fo = access.getDefaultFolder(this.userId, 3);
        }
        catch (OXException e) {
            e.printStackTrace();
            return null;
        }
        return fo;
    }
}

