/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.task.AbstractTaskTest;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.tools.RandomString;

public class TruncationTest
extends AbstractTaskTest {
    public TruncationTest(String name) {
        super(name);
    }

    public void testTruncation() throws Throwable {
        Task task = new Task();
        task.setTitle(RandomString.generateChars(257));
        task.setTripMeter(RandomString.generateChars(256));
        task.setParentFolderID(this.getPrivateFolder());
        InsertResponse response = this.getClient().execute(new InsertRequest(task, this.getTimeZone(), false));
        TruncationTest.assertTrue((String)"Server did not detect truncated data.", (boolean)response.hasError());
        TruncationTest.assertTrue((String)"Array of truncated attribute identifier is empty.", (response.getProblematics().length > 0 ? 1 : 0) != 0);
        StringBuilder sb = new StringBuilder();
        sb.append("Truncated attribute identifier: [");
        int truncatedAttributeId = -1;
        for (OXException.ProblematicAttribute problematic : response.getProblematics()) {
            if (!(problematic instanceof OXException.Truncated)) continue;
            truncatedAttributeId = ((OXException.Truncated)problematic).getId();
            sb.append(truncatedAttributeId);
            sb.append(',');
        }
        sb.setCharAt(sb.length() - 1, ']');
        TruncationTest.assertEquals((String)"Wrong attribute discovered as truncated.", (int)200, (int)truncatedAttributeId);
    }
}

