/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.test.TaskTestManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;

public class Bug13173Test
extends AbstractAJAXSession {
    Task testTask;
    int folderId;
    TimeZone timezone;
    TaskTestManager ttm;
    ArrayList<Task> duplicates;

    public Bug13173Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.folderId = this.client.getValues().getPrivateTaskFolder();
        this.timezone = this.client.getValues().getTimeZone();
        this.ttm = new TaskTestManager(this.client);
        this.testTask = new Task();
        this.testTask.setTitle("Bug13173Test is testing Bug13173");
        this.testTask.setParentFolderID(this.folderId);
        this.testTask.setStartDate(new Date());
        this.testTask.setEndDate(new Date());
        this.testTask.setCreatedBy(this.client.getValues().getUserId());
        this.testTask.setRecurrenceType(1);
        this.testTask.setInterval(1);
        this.testTask.setOccurrence(2);
        this.testTask.setPercentComplete(75);
        this.testTask.setStatus(2);
    }

    @Override
    protected void tearDown() throws Exception {
        this.ttm.cleanUp();
        this.deleteDuplicates(this.duplicates);
        super.tearDown();
    }

    public void testBug13173() throws Exception {
        this.testTask = this.ttm.insertTaskOnServer(this.testTask);
        this.setTaskComplete(this.testTask);
        this.setTaskIncomplete(this.testTask);
        this.setTaskComplete(this.testTask);
        this.duplicates = this.getDuplicates();
        Bug13173Test.assertTrue((String)"There are existing Duplicates", (this.duplicates.size() <= 1 ? 1 : 0) != 0);
    }

    private void setTaskComplete(Task task) {
        task.setPercentComplete(100);
        task.setStatus(3);
        this.testTask = this.ttm.updateTaskOnServer(task);
    }

    private void setTaskIncomplete(Task task) {
        task.setPercentComplete(75);
        task.setStatus(2);
        this.testTask = this.ttm.updateTaskOnServer(task);
    }

    private void deleteDuplicates(ArrayList<Task> duplicates) {
        for (Task t : duplicates) {
            t.setParentFolderID(this.folderId);
            this.ttm.deleteTaskOnServer(t);
        }
    }

    private void deleteAll() {
        Task[] tasks;
        for (Task t : tasks = this.ttm.getAllTasksOnServer(this.folderId)) {
            if (!t.getTitle().equals(this.testTask.getTitle())) continue;
            t.setParentFolderID(this.folderId);
            this.ttm.deleteTaskOnServer(t);
        }
    }

    private ArrayList<Task> getDuplicates() {
        Task[] allTasks = this.ttm.getAllTasksOnServer(this.folderId, Task.ALL_COLUMNS);
        ArrayList<Task> returnList = new ArrayList<Task>();
        if (allTasks.length != 0) {
            for (Task t : allTasks) {
                boolean oid;
                boolean title = t.getTitle().equals(this.testTask.getTitle());
                boolean creater = t.getCreatedBy() == this.testTask.getCreatedBy();
                boolean startDate = t.getStartDate().equals(this.testTask.getStartDate());
                boolean percentComplete = t.getPercentComplete() == this.testTask.getPercentComplete();
                boolean bl = oid = t.getObjectID() == this.testTask.getObjectID();
                if (oid || !title || !creater || !startDate || !percentComplete) continue;
                returnList.add(t);
            }
        }
        return returnList;
    }
}

