/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.resource.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.framework.Params;
import com.openexchange.ajax.resource.actions.AbstractResourceRequest;
import com.openexchange.ajax.resource.actions.ResourceUpdateResponse;
import com.openexchange.resource.Resource;
import com.openexchange.resource.json.ResourceWriter;
import org.json.JSONException;
import org.json.JSONObject;

public final class ResourceUpdateRequest
extends AbstractResourceRequest {
    private final boolean failOnError;
    private final JSONObject resourceJSON;
    private final long clientLastModified;
    private final Resource resource;

    public ResourceUpdateRequest(Resource resource, long clientLastModified, boolean failOnError) throws JSONException {
        this.failOnError = failOnError;
        this.clientLastModified = clientLastModified;
        this.resource = resource;
        this.resourceJSON = ResourceWriter.writeResource((Resource)resource);
    }

    @Override
    public Object getBody() throws JSONException {
        return this.resourceJSON;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        return new Params("action", "update", "timestamp", String.valueOf(this.clientLastModified), "id", String.valueOf(this.resource.getIdentifier())).toArray();
    }

    public ResourceUpdateParser getParser() {
        return new ResourceUpdateParser(this.failOnError);
    }

    private static final class ResourceUpdateParser
    extends AbstractAJAXParser<ResourceUpdateResponse> {
        ResourceUpdateParser(boolean failOnError) {
            super(failOnError);
        }

        @Override
        protected ResourceUpdateResponse createResponse(Response response) throws JSONException {
            return new ResourceUpdateResponse(response);
        }
    }
}

