/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail.netsol.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractUploadParser;
import com.openexchange.ajax.framework.Header;
import com.openexchange.ajax.mail.netsol.actions.NetsolSendResponse;
import java.io.InputStream;
import org.json.JSONException;

public class NetsolSendRequest
implements AJAXRequest<NetsolSendResponse> {
    public static final String MAIL_URL = "/ajax/mail";
    private final String mailStr;
    private final InputStream upload;
    private final String uploadContentType;
    private final String uploadFilename;
    private String recipientTo;

    public NetsolSendRequest(String mailStr) {
        this(mailStr, null);
    }

    public NetsolSendRequest(String mailStr, InputStream upload) {
        this(mailStr, upload, "text/plain; charset=us-ascii", "text.txt");
    }

    public NetsolSendRequest(String mailStr, InputStream upload, String uploadContentType, String uploadFilename) {
        this.mailStr = mailStr;
        this.upload = upload;
        this.uploadContentType = uploadContentType;
        this.uploadFilename = uploadFilename;
    }

    @Override
    public Object getBody() {
        return null;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.UPLOAD;
    }

    @Override
    public Header[] getHeaders() {
        return NO_HEADER;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        AJAXRequest.Parameter[] retval = new AJAXRequest.Parameter[this.upload == null ? 2 : 3];
        retval[0] = new AJAXRequest.Parameter("action", "new");
        retval[1] = new AJAXRequest.FieldParameter("json_0", this.mailStr);
        if (this.upload != null) {
            retval[2] = new AJAXRequest.FileParameter("file_0", this.uploadFilename, this.upload, this.uploadContentType);
        }
        return retval;
    }

    @Override
    public String getServletPath() {
        return MAIL_URL;
    }

    public SendParser getParser() {
        return new SendParser(true);
    }

    class SendParser
    extends AbstractUploadParser<NetsolSendResponse> {
        public SendParser(boolean failOnError) {
            super(failOnError);
        }

        @Override
        protected NetsolSendResponse createResponse(Response response) throws JSONException {
            return new NetsolSendResponse(response);
        }
    }
}

