/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail.filter.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.mail.filter.ConfigTestHolder;
import com.openexchange.ajax.mail.filter.actions.ConfigResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ConfigParser
extends AbstractAJAXParser<ConfigResponse> {
    public ConfigParser(boolean failOnError) {
        super(failOnError);
    }

    @Override
    protected ConfigResponse createResponse(Response response) throws JSONException {
        JSONObject jsonObj = (JSONObject)response.getData();
        JSONArray jsonTestArray = jsonObj.getJSONArray("tests");
        JSONArray jsonActionArray = jsonObj.getJSONArray("actioncommands");
        ConfigTestHolder[] configTests = new ConfigTestHolder[jsonTestArray.length()];
        for (int a = 0; a < configTests.length; ++a) {
            JSONObject jsonTestObj = jsonTestArray.getJSONObject(a);
            String testString = jsonTestObj.getString("test");
            JSONArray jsonComparisonArray = jsonTestObj.getJSONArray("comparison");
            String[] comparisons = new String[jsonComparisonArray.length()];
            for (int b = 0; b < comparisons.length; ++b) {
                comparisons[b] = jsonComparisonArray.getString(b);
            }
            configTests[a] = new ConfigTestHolder(testString, comparisons);
        }
        String[] actions = new String[jsonActionArray.length()];
        for (int a = 0; a < actions.length; ++a) {
            actions[a] = jsonActionArray.getString(a);
        }
        return new ConfigResponse(response, configTests, actions);
    }
}

