/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.mail.actions.AbstractMailRequest;
import com.openexchange.ajax.mail.actions.UpdateMailResponse;
import java.util.LinkedList;
import org.json.JSONException;
import org.json.JSONObject;

public class MoveMailRequest
extends AbstractMailRequest<UpdateMailResponse> {
    private final String destination;
    private final String origin;
    private final String mailID;
    private final boolean failOnError;

    public MoveMailRequest(String origin, String destination, String mailID, boolean failOnError) {
        this.origin = origin;
        this.destination = destination;
        this.mailID = mailID;
        this.failOnError = failOnError;
    }

    public MoveMailRequest(String origin, String destination, String mailID) {
        this(origin, destination, mailID, true);
    }

    @Override
    public Object getBody() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("folder_id", (Object)this.destination);
        return json;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        LinkedList<AJAXRequest.Parameter> list = new LinkedList<AJAXRequest.Parameter>();
        list.add(new AJAXRequest.Parameter("action", "update"));
        list.add(new AJAXRequest.Parameter("folder", this.origin));
        list.add(new AJAXRequest.Parameter("id", this.mailID));
        return list.toArray(new AJAXRequest.Parameter[list.size()]);
    }

    @Override
    public AbstractAJAXParser<? extends UpdateMailResponse> getParser() {
        return new AbstractAJAXParser<UpdateMailResponse>(this.failOnError){

            @Override
            protected UpdateMailResponse createResponse(Response response) {
                return new UpdateMailResponse(response);
            }
        };
    }
}

