/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.actions.MailSearchRequest;
import com.openexchange.ajax.mail.actions.MailSearchResponse;
import com.openexchange.ajax.mail.actions.NewMailRequest;
import com.openexchange.exception.OXException;
import com.openexchange.mail.MailListField;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MailSearchTest
extends AbstractMailTest {
    private String folder;

    public MailSearchTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.folder = this.getInboxFolder();
        this.clearFolder(this.folder);
    }

    @Override
    public void tearDown() throws Exception {
        this.clearFolder(this.folder);
        super.tearDown();
    }

    public void testSearch() throws Exception {
        String searchText = "Re: Your order for East Texas Lighthouse";
        JSONArray search = this.searchBySubject("Re: Your order for East Texas Lighthouse");
        MailSearchTest.assertEquals((String)"Should not yield results in empty folder.", (int)0, (int)search.length());
        String eml = "Message-Id: <4A002517.4650.0059.1@deployfast.com>\nX-Mailer: Novell GroupWise Internet Agent 8.0.0 \nDate: Tue, 05 May 2009 11:37:58 -0500\nTo: #TOADDR#\nSubject: Re: Your order for East Texas Lighthouse\nMime-Version: 1.0\nContent-Type: text/plain; charset=\"UTF-8\"\nContent-Transfer-Encoding: 8bit\n\nThis is a MIME message. If you are reading this text, you may want to \nconsider changing to a mail reader or gateway that understands how to \n" + "properly handle MIME multipart messages.".replaceFirst("#TOADDR#", this.getSendAddress());
        this.getClient().execute(new NewMailRequest(this.folder, eml, -1, true));
        search = this.searchBySubject("Re: Your order for East Texas Lighthouse");
        MailSearchTest.assertEquals((String)"Should yield one result.", (int)1, (int)search.length());
        this.getClient().execute(new NewMailRequest(this.folder, eml, -1, true));
        search = this.searchBySubject("Re: Your order for East Texas Lighthouse");
        MailSearchTest.assertEquals((String)"Should yield two results when facing two identical mails.", (int)2, (int)search.length());
        eml = "Message-Id: <4A002517.4650.0059.1@deployfast.com>\nX-Mailer: Novell GroupWise Internet Agent 8.0.0 \nDate: Tue, 05 May 2009 11:37:58 -0500\nTo: #TOADDR#\nSubject: Barfoo\nMime-Version: 1.0\nContent-Type: text/plain; charset=\"UTF-8\"\nContent-Transfer-Encoding: 8bit\n\nThis is a MIME message. If you are reading this text, you may want to \nconsider changing to a mail reader or gateway that understands how to \n" + "properly handle MIME multipart messages.".replaceFirst("#TOADDR#", this.getSendAddress());
        this.getClient().execute(new NewMailRequest(this.folder, eml, -1, true));
        search = this.searchBySubject("Re: Your order for East Texas Lighthouse");
        MailSearchTest.assertEquals((String)"Should still yield two results after being sent a different one", (int)2, (int)search.length());
    }

    public JSONArray searchBySubject(String pattern) throws OXException, IOException, JSONException {
        JSONArray body = new JSONArray();
        JSONObject obj = new JSONObject();
        obj.put("col", MailListField.SUBJECT.getField());
        obj.put("pattern", (Object)pattern);
        body.put((Object)obj);
        MailSearchRequest request = new MailSearchRequest(body, this.folder, COLUMNS_DEFAULT_LIST, 0, "asc", true);
        MailSearchResponse response = this.getClient().execute(request);
        return response.getDataAsJSONArray();
    }
}

