/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.links;

import com.openexchange.ajax.contact.action.GetRequest;
import com.openexchange.ajax.contact.action.GetResponse;
import com.openexchange.ajax.contact.action.InsertResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.links.LinkTools;
import com.openexchange.ajax.links.actions.AllRequest;
import com.openexchange.ajax.links.actions.AllResponse;
import com.openexchange.ajax.links.actions.DeleteRequest;
import com.openexchange.ajax.links.actions.InsertRequest;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.LinkObject;
import com.openexchange.groupware.tasks.Task;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public final class FunctionTests
extends AbstractAJAXSession {
    public FunctionTests(String name) {
        super(name);
    }

    public void testNew() throws Exception {
        AJAXClient client = this.getClient();
        int fid1 = client.getValues().getPrivateContactFolder();
        Contact co = new Contact();
        co.setSurName("Meier");
        co.setGivenName("Herbert");
        co.setDisplayName("Meier, Herbert");
        co.setParentFolderID(fid1);
        InsertResponse response = Executor.execute(client, new com.openexchange.ajax.contact.action.InsertRequest(co));
        int oid1 = response.getId();
        int fid2 = client.getValues().getPrivateAppointmentFolder();
        Appointment ao = new Appointment();
        ao.setTitle("Nasenmann");
        Calendar c = Calendar.getInstance();
        c.set(11, 8);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        c.setTimeZone(TimeZone.getTimeZone("GMT"));
        long startTime = c.getTimeInMillis();
        long endTime = startTime + 3600000L;
        ao.setStartDate(new Date(startTime));
        ao.setEndDate(new Date(endTime));
        ao.setLocation("Location");
        ao.setShownAs(3);
        ao.setParentFolderID(fid2);
        ao.setIgnoreConflicts(true);
        TimeZone tz = client.getValues().getTimeZone();
        CommonInsertResponse response2 = Executor.execute(client, new com.openexchange.ajax.appointment.action.InsertRequest(ao, tz));
        int oid2 = response2.getId();
        LinkObject lo = new LinkObject();
        lo.setFirstFolder(fid1);
        lo.setFirstId(oid1);
        lo.setFirstType(7);
        lo.setSecondFolder(fid2);
        lo.setSecondId(oid2);
        lo.setSecondType(1);
        InsertRequest request = new InsertRequest(lo);
        LinkTools.insert(client, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testContactAndTask() throws Throwable {
        AJAXClient client = this.getClient();
        int taskFolder = client.getValues().getPrivateTaskFolder();
        int contactFolder = client.getValues().getPrivateContactFolder();
        Task task = new Task();
        task.setTitle("Link contact and task test.");
        task.setParentFolderID(taskFolder);
        com.openexchange.ajax.task.actions.InsertResponse response = client.execute(new com.openexchange.ajax.task.actions.InsertRequest(task, client.getValues().getTimeZone()));
        task.setObjectID(response.getId());
        task.setLastModified(response.getTimestamp());
        Contact contact = new Contact();
        contact.setDisplayName("Link contact and task test.");
        contact.setParentFolderID(contactFolder);
        InsertResponse response2 = Executor.execute(client, new com.openexchange.ajax.contact.action.InsertRequest(contact));
        contact.setObjectID(response2.getId());
        TimeZone tz = client.getValues().getTimeZone();
        GetResponse gResponse = Executor.execute(client, new GetRequest(contactFolder, response2, tz));
        contact.setLastModified(gResponse.getTimestamp());
        try {
            LinkObject link = new LinkObject(contact.getObjectID(), 7, contact.getParentFolderID(), task.getObjectID(), 4, task.getParentFolderID(), -1);
            CommonInsertResponse response3 = LinkTools.insert(client, new InsertRequest(link));
            FunctionTests.assertFalse((String)"Inserting link failed.", (boolean)response3.hasError());
            AllResponse allR = LinkTools.all(client, new AllRequest(contact.getObjectID(), 7, contact.getParentFolderID()));
            LinkObject[] links = allR.getLinks();
            FunctionTests.assertTrue((String)"Too few links found.", (links.length >= 1 ? 1 : 0) != 0);
            LinkTools.delete(client, new DeleteRequest(link));
        }
        finally {
            client.execute(new com.openexchange.ajax.task.actions.DeleteRequest(task));
            client.execute(new com.openexchange.ajax.contact.action.DeleteRequest(contact));
        }
    }
}

