/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.kata.folders;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.kata.NeedExistingStep;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.test.FolderTestManager;
import org.junit.Assert;

public class FolderDeleteStep
extends NeedExistingStep<FolderObject> {
    private final FolderObject entry;

    public FolderDeleteStep(FolderObject entry, String name, String expectedError) {
        super(name, expectedError);
        this.entry = entry;
    }

    @Override
    public void cleanUp() throws Exception {
    }

    @Override
    public void perform(AJAXClient client) throws Exception {
        this.assumeIdentity(this.entry);
        FolderTestManager manager = new FolderTestManager(client);
        manager.setFailOnError(false);
        Assert.assertNotNull((String)"Should have found folder before deletion", (Object)manager.getFolderFromServer(this.entry, false));
        manager.deleteFolderOnServer(this.entry);
        Assert.assertNull((String)"Should not have found folder after deletion", (Object)manager.getFolderFromServer(this.entry, false));
        this.forgetIdentity(this.entry);
    }
}

