/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore;

import com.openexchange.ajax.writer.InfostoreWriter;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.database.impl.DocumentMetadataImpl;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.tools.iterator.ArrayIterator;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorAdapter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONWriter;

public class InfostoreWriterTest
extends TestCase {
    private static final List<DocumentMetadata> DUMMY_DATA = new ArrayList<DocumentMetadata>();
    private static final Date now = new Date(1153481105872L);

    public void testWriteList() throws Exception {
        StringWriter results = new StringWriter();
        InfostoreWriter w = new InfostoreWriter(new JSONWriter((Writer)new PrintWriter(results)));
        w.writeMetadata((SearchIterator)new SearchIteratorAdapter(DUMMY_DATA.iterator()), new Metadata[]{Metadata.URL_LITERAL, Metadata.TITLE_LITERAL, Metadata.CREATED_BY_LITERAL}, TimeZone.getTimeZone("utc"));
        JSONArray listOfArrays = new JSONArray(results.toString());
        InfostoreWriterTest.assertEquals((int)3, (int)listOfArrays.length());
        HashSet<String> urls = new HashSet<String>(Arrays.asList("http://www.nice-files.de", "http://www.google.de"));
        HashSet<String> titles = new HashSet<String>(Arrays.asList("Google", "Knowledge", "File Attached"));
        String createdBy = "1";
        for (int i = 0; i < 3; ++i) {
            JSONArray result = listOfArrays.getJSONArray(i);
            InfostoreWriterTest.assertEquals((int)3, (int)result.length());
            InfostoreWriterTest.assertEquals((String)"1", (String)result.getString(2));
            InfostoreWriterTest.assertTrue((boolean)titles.remove(result.getString(1)));
            urls.remove(result.getString(0));
        }
        InfostoreWriterTest.assertTrue((boolean)urls.isEmpty());
        InfostoreWriterTest.assertTrue((boolean)titles.isEmpty());
    }

    public void testCategories() throws Exception {
        StringWriter results = new StringWriter();
        InfostoreWriter w = new InfostoreWriter(new JSONWriter((Writer)new PrintWriter(results)));
        DocumentMetadataImpl m = new DocumentMetadataImpl();
        m.setCategories("cat1, cat2, cat3");
        w.writeMetadata((SearchIterator)new ArrayIterator((Object[])new DocumentMetadata[]{m}), new Metadata[]{Metadata.CATEGORIES_LITERAL}, TimeZone.getTimeZone("utc"));
        JSONArray listOfArrays = new JSONArray(results.toString());
        JSONArray metadata1 = listOfArrays.getJSONArray(0);
        JSONArray categories = metadata1.getJSONArray(0);
        InfostoreWriterTest.assertEquals((Object)"cat1", (Object)categories.get(0));
        InfostoreWriterTest.assertEquals((Object)"cat2", (Object)categories.get(1));
        InfostoreWriterTest.assertEquals((Object)"cat3", (Object)categories.get(2));
        results = new StringWriter();
        w = new InfostoreWriter(new JSONWriter((Writer)new PrintWriter(results)));
        w.write((DocumentMetadata)m, TimeZone.getTimeZone("utc"));
        JSONObject o = new JSONObject(results.toString());
        categories = o.getJSONArray("categories");
        InfostoreWriterTest.assertEquals((Object)"cat1", (Object)categories.get(0));
        InfostoreWriterTest.assertEquals((Object)"cat2", (Object)categories.get(1));
        InfostoreWriterTest.assertEquals((Object)"cat3", (Object)categories.get(2));
        m.setCategories(null);
        results = new StringWriter();
        w = new InfostoreWriter(new JSONWriter((Writer)new PrintWriter(results)));
        w.writeMetadata((SearchIterator)new ArrayIterator((Object[])new DocumentMetadata[]{m}), new Metadata[]{Metadata.CATEGORIES_LITERAL}, TimeZone.getTimeZone("utc"));
        listOfArrays = new JSONArray(results.toString());
        metadata1 = listOfArrays.getJSONArray(0);
        categories = metadata1.getJSONArray(0);
        InfostoreWriterTest.assertEquals((int)0, (int)categories.length());
        results = new StringWriter();
        w = new InfostoreWriter(new JSONWriter((Writer)new PrintWriter(results)));
        w.write((DocumentMetadata)m, TimeZone.getTimeZone("utc"));
        o = new JSONObject(results.toString());
        categories = o.getJSONArray("categories");
        InfostoreWriterTest.assertEquals((int)0, (int)categories.length());
    }

    public void testWriteObject() throws Exception {
        DocumentMetadataImpl dm = new DocumentMetadataImpl();
        dm.setFolderId(22L);
        dm.setModifiedBy(1);
        dm = new DocumentMetadataImpl((DocumentMetadata)dm);
        dm.setCreationDate(now);
        dm.setCreatedBy(1);
        dm.setDescription("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.");
        dm.setLastModified(now);
        dm.setTitle("Google");
        dm.setURL("http://www.google.de");
        dm.setVersion(0);
        dm.setId(1);
        StringWriter result = new StringWriter();
        InfostoreWriter w = new InfostoreWriter(new JSONWriter((Writer)new PrintWriter(result)));
        w.write((DocumentMetadata)dm, TimeZone.getTimeZone("utc"));
        JSONObject o = new JSONObject(result.toString());
        InfostoreWriterTest.assertEquals((String)dm.getDescription(), (String)o.getString("description"));
        InfostoreWriterTest.assertEquals((String)dm.getTitle(), (String)o.getString("title"));
        InfostoreWriterTest.assertEquals((String)dm.getURL(), (String)o.getString("url"));
    }

    public void testLocked() throws Exception {
        DocumentMetadataImpl dm = new DocumentMetadataImpl();
        dm.setFolderId(22L);
        dm.setModifiedBy(1);
        dm = new DocumentMetadataImpl((DocumentMetadata)dm);
        dm.setCreationDate(now);
        dm.setCreatedBy(1);
        dm.setDescription("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.");
        dm.setLastModified(now);
        dm.setTitle("Google");
        dm.setURL("http://www.google.de");
        dm.setVersion(0);
        dm.setId(1);
        dm.setLockedUntil(new Date(System.currentTimeMillis() - 1000L));
        StringWriter result = new StringWriter();
        InfostoreWriter w = new InfostoreWriter(new JSONWriter((Writer)new PrintWriter(result)));
        w.write((DocumentMetadata)dm, TimeZone.getTimeZone("utc"));
        JSONObject o = new JSONObject(result.toString());
        InfostoreWriterTest.assertEquals((long)0L, (long)o.getLong(Metadata.LOCKED_UNTIL_LITERAL.getName()));
        long later = System.currentTimeMillis() + 1000L;
        dm.setLockedUntil(new Date(later));
        result = new StringWriter();
        w = new InfostoreWriter(new JSONWriter((Writer)new PrintWriter(result)));
        w.write((DocumentMetadata)dm, TimeZone.getTimeZone("utc"));
        o = new JSONObject(result.toString());
        InfostoreWriterTest.assertEquals((long)later, (long)o.getLong(Metadata.LOCKED_UNTIL_LITERAL.getName()));
    }

    public void testTimeZone() throws Exception {
        DocumentMetadataImpl dm = new DocumentMetadataImpl();
        dm.setLastModified(new Date(230023L));
        StringWriter result = new StringWriter();
        InfostoreWriter w = new InfostoreWriter(new JSONWriter((Writer)new PrintWriter(result)));
        w.write((DocumentMetadata)dm, TimeZone.getTimeZone("Europe/Berlin"));
        JSONObject o = new JSONObject(result.toString());
        InfostoreWriterTest.assertEquals((long)3830023L, (long)o.getLong(Metadata.LAST_MODIFIED_LITERAL.getName()));
    }

    static {
        DocumentMetadataImpl dm = new DocumentMetadataImpl();
        dm.setFolderId(22L);
        dm.setModifiedBy(1);
        dm = new DocumentMetadataImpl((DocumentMetadata)dm);
        dm.setCreationDate(now);
        dm.setCreatedBy(1);
        dm.setDescription("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.");
        dm.setLastModified(now);
        dm.setTitle("Google");
        dm.setURL("http://www.google.de");
        dm.setVersion(0);
        dm.setId(1);
        DUMMY_DATA.add((DocumentMetadata)dm);
        dm = new DocumentMetadataImpl((DocumentMetadata)dm);
        dm.setURL(null);
        dm.setCreationDate(new Date(now.getTime() - 86400000L));
        dm.setLastModified(new Date(now.getTime() - 64800000L));
        dm.setDescription("Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.");
        dm.setTitle("Knowledge");
        dm.setId(2);
        DUMMY_DATA.add((DocumentMetadata)dm);
        dm = new DocumentMetadataImpl((DocumentMetadata)dm);
        dm.setURL("http://www.nice-files.de");
        dm.setVersion(3);
        dm.setFileMIMEType("text/html");
        dm.setFileName("gnatzel.html");
        dm.setTitle("File Attached");
        dm.setFileSize(4096L);
        dm.setCreationDate(new Date(now.getTime() - 172800000L));
        dm.setLastModified(new Date(now.getTime() - 21600000L));
        dm.setId(3);
        DUMMY_DATA.add((DocumentMetadata)dm);
    }
}

