/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport;

import com.openexchange.ajax.importexport.AbstractVCardImportTest;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.importexport.ImportResult;
import com.openexchange.java.Charsets;
import com.openexchange.webdav.xml.ContactTest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class VCardImportBugTests
extends AbstractVCardImportTest {
    public VCardImportBugTests(String name) throws Exception {
        super(name);
    }

    public void testImportVCard() throws Exception {
        Contact contactObj = new Contact();
        contactObj.setSurName("surname");
        contactObj.setGivenName("givenName");
        contactObj.setBirthday(this.simpleDateFormat.parse("2007-04-04"));
        ImportResult[] importResult = VCardImportBugTests.importVCard(this.getWebConversation(), new Contact[]{contactObj}, this.contactFolderId, this.timeZone, this.emailaddress, this.getHostName(), this.getSessionId());
        VCardImportBugTests.assertEquals((String)"import result size is not 1", (int)1, (int)importResult.length);
        VCardImportBugTests.assertTrue((String)"server errors of server", (boolean)importResult[0].isCorrect());
        int objectId = Integer.parseInt(importResult[0].getObjectId());
        VCardImportBugTests.assertTrue((String)"object id is 0", (objectId > 0 ? 1 : 0) != 0);
        Contact[] contactArray = this.exportContact(this.getWebConversation(), this.contactFolderId, this.emailaddress, this.timeZone, this.getHostName(), this.getSessionId());
        boolean found = false;
        for (int a = 0; a < contactArray.length; ++a) {
            if (!contactObj.getSurName().equals(contactArray[a].getSurName())) continue;
            contactObj.setParentFolderID(this.contactFolderId);
            ContactTest.compareObject(contactObj, contactArray[a]);
            found = true;
        }
        VCardImportBugTests.assertTrue((String)"inserted object not found in response", (boolean)found);
    }

    public void testImportVCardWithBrokenContact() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BEGIN:VCARD").append('\n');
        stringBuffer.append("VERSION:3.0").append('\n');
        stringBuffer.append("FN:testImportVCardWithBrokenContact1").append('\n');
        stringBuffer.append("N:testImportVCardWithBrokenContact1;givenName;;;").append('\n');
        stringBuffer.append("BDAY:20070404").append('\n');
        stringBuffer.append("END:VCARD").append('\n');
        stringBuffer.append("BEGIN:VCARD").append('\n');
        stringBuffer.append("VERSION:3.0").append('\n');
        stringBuffer.append("FN:testImportVCardWithBrokenContact2").append('\n');
        stringBuffer.append("N:testImportVCardWithBrokenContact2;givenName;;;").append('\n');
        stringBuffer.append("BDAY:INVALID_DATE").append('\n');
        stringBuffer.append("END:VCARD").append('\n');
        stringBuffer.append("BEGIN:VCARD").append('\n');
        stringBuffer.append("VERSION:3.0").append('\n');
        stringBuffer.append("FN:testImportVCardWithBrokenContact3").append('\n');
        stringBuffer.append("N:testImportVCardWithBrokenContact3;givenName;;;").append('\n');
        stringBuffer.append("BDAY:20070404").append('\n');
        stringBuffer.append("END:VCARD").append('\n');
        ImportResult[] importResult = VCardImportBugTests.importVCard(this.getWebConversation(), new ByteArrayInputStream(stringBuffer.toString().getBytes()), this.contactFolderId, this.timeZone, this.emailaddress, this.getHostName(), this.getSessionId());
        VCardImportBugTests.assertEquals((String)"invalid import result array size", (int)3, (int)importResult.length);
        VCardImportBugTests.assertTrue((String)"server errors of server", (boolean)importResult[0].isCorrect());
        VCardImportBugTests.assertTrue((String)"Should work even in the face of an invalid birthday", (boolean)importResult[1].isCorrect());
        VCardImportBugTests.assertTrue((String)"server errors of server", (boolean)importResult[2].isCorrect());
    }

    public void test6823() throws OXException, IOException, SAXException, JSONException, Exception {
        String vcard = "BEGIN:VCARD\nVERSION:3.0\nN:;Svetlana;;;\nFN:Svetlana\nTEL;type=CELL;type=pref:6670373\nCATEGORIES:Nicht abgelegt\nX-ABUID:CBC739E8-694E-4589-8651-8C30E1A6E724\\:ABPerson\nEND:VCARD";
        ImportResult[] importResult = VCardImportBugTests.importVCard(this.getWebConversation(), new ByteArrayInputStream("BEGIN:VCARD\nVERSION:3.0\nN:;Svetlana;;;\nFN:Svetlana\nTEL;type=CELL;type=pref:6670373\nCATEGORIES:Nicht abgelegt\nX-ABUID:CBC739E8-694E-4589-8651-8C30E1A6E724\\:ABPerson\nEND:VCARD".getBytes()), this.contactFolderId, this.timeZone, this.emailaddress, this.getHostName(), this.getSessionId());
        VCardImportBugTests.assertTrue((String)"Only one import", (importResult.length == 1 ? 1 : 0) != 0);
        VCardImportBugTests.assertFalse((String)"No error?", (boolean)importResult[0].hasError());
    }

    public void test6962followup() throws OXException, IOException, SAXException, JSONException, Exception {
        String vcard = "BEGIN:VCARD\nVERSION:3.0\nN:;Svetlana;;;\nFN:Svetlana\nTEL;type=CELL;type=pref:673730\nEND:VCARD\nBEGIN:VCARD\nVERSION:666\nN:;Svetlana;;;\nFN:Svetlana\nTEL;type=CELL;type=pref:6670373\nEND:VCARD";
        ImportResult[] importResult = VCardImportBugTests.importVCard(this.getWebConversation(), new ByteArrayInputStream("BEGIN:VCARD\nVERSION:3.0\nN:;Svetlana;;;\nFN:Svetlana\nTEL;type=CELL;type=pref:673730\nEND:VCARD\nBEGIN:VCARD\nVERSION:666\nN:;Svetlana;;;\nFN:Svetlana\nTEL;type=CELL;type=pref:6670373\nEND:VCARD".getBytes()), this.contactFolderId, this.timeZone, this.emailaddress, this.getHostName(), this.getSessionId());
        VCardImportBugTests.assertTrue((String)"Two import attempts", (importResult.length == 2 ? 1 : 0) != 0);
        VCardImportBugTests.assertFalse((String)"No error on first attempt?", (boolean)importResult[0].hasError());
        VCardImportBugTests.assertTrue((String)"Error on second attempt?", (boolean)importResult[1].hasError());
        importResult[1].getException();
    }

    public void test7106() throws OXException, IOException, SAXException, JSONException, Exception {
        String vcard = "BEGIN:VCARD\nVERSION:3.0\nN:;H\u00fcb\u00fcrt;;;\nFN:H\u00fcb\u00fcrt S\u00f6nderzeich\u00f6n\nTEL;type=CELL;type=pref:6670373\nEND:VCARD\n";
        ImportResult[] importResult = VCardImportBugTests.importVCard(this.getWebConversation(), new ByteArrayInputStream("BEGIN:VCARD\nVERSION:3.0\nN:;H\u00fcb\u00fcrt;;;\nFN:H\u00fcb\u00fcrt S\u00f6nderzeich\u00f6n\nTEL;type=CELL;type=pref:6670373\nEND:VCARD\n".getBytes(Charsets.UTF_8)), this.contactFolderId, this.timeZone, this.emailaddress, this.getHostName(), this.getSessionId());
        VCardImportBugTests.assertFalse((String)"Worked?", (boolean)importResult[0].hasError());
        int contactId = Integer.parseInt(importResult[0].getObjectId());
        Contact myImport = ContactTest.loadContact(this.getWebConversation(), contactId, this.contactFolderId, this.getHostName(), this.getLogin(), this.getPassword(), "");
        VCardImportBugTests.assertEquals((String)"Checking surname:", (String)"H\u00fcb\u00fcrt S\u00f6nderzeich\u00f6n", (String)myImport.getDisplayName());
    }

    public void test7248() throws OXException, IOException, SAXException, JSONException, Exception {
        String vcard = "BEGIN:VCARD\nVERSION:2.1\nN:Colombara;Robert\nFN:Robert Colombara\nADR;WORK:;;;;;;DE\nADR;HOME:;;;;;- / -\nEND:VCARD";
        ImportResult[] importResult = VCardImportBugTests.importVCard(this.getWebConversation(), new ByteArrayInputStream("BEGIN:VCARD\nVERSION:2.1\nN:Colombara;Robert\nFN:Robert Colombara\nADR;WORK:;;;;;;DE\nADR;HOME:;;;;;- / -\nEND:VCARD".getBytes()), this.contactFolderId, this.timeZone, this.emailaddress, this.getHostName(), this.getSessionId());
        VCardImportBugTests.assertEquals((String)"Should have one import only", (int)1, (int)importResult.length);
        VCardImportBugTests.assertFalse((String)("Import does have error: " + (Object)((Object)importResult[0].getException())), (boolean)importResult[0].hasError());
        int contactId = Integer.parseInt(importResult[0].getObjectId());
        Contact myImport = ContactTest.loadContact(this.getWebConversation(), contactId, this.contactFolderId, this.getHostName(), this.getLogin(), this.getPassword(), "");
        VCardImportBugTests.assertEquals((String)"Checking surname:", (String)"Colombara", (String)myImport.getSurName());
    }

    public void test7249() throws OXException, IOException, SAXException, JSONException, Exception {
        String vcard = "BEGIN:VCARD\nVERSION:2.1\nFN:Conference_Room_Olpe\nEMAIL;PREF;INTERNET:Conference_Room_Olpe_EMAIL\nEND:VCARD";
        ImportResult[] importResult = VCardImportBugTests.importVCard(this.getWebConversation(), new ByteArrayInputStream("BEGIN:VCARD\nVERSION:2.1\nFN:Conference_Room_Olpe\nEMAIL;PREF;INTERNET:Conference_Room_Olpe_EMAIL\nEND:VCARD".getBytes()), this.contactFolderId, this.timeZone, this.emailaddress, this.getHostName(), this.getSessionId());
        VCardImportBugTests.assertFalse((String)"Worked?", (boolean)importResult[0].hasError());
        int contactId = Integer.parseInt(importResult[0].getObjectId());
        Contact myImport = ContactTest.loadContact(this.getWebConversation(), contactId, this.contactFolderId, this.getHostName(), this.getLogin(), this.getPassword(), "");
        VCardImportBugTests.assertEquals((String)"Checking surname:", (String)"Conference_Room_Olpe", (String)myImport.getDisplayName());
        VCardImportBugTests.assertEquals((String)"Checking email1 (must be null):", null, (String)myImport.getEmail1());
        VCardImportBugTests.assertEquals((String)"Checking email2 (must be null):", null, (String)myImport.getEmail2());
        VCardImportBugTests.assertEquals((String)"Checking email3 (must be null):", null, (String)myImport.getEmail3());
    }

    public void test7250() throws OXException, IOException, SAXException, JSONException, Exception {
        String vcard = "BEGIN:VCARD\nVERSION:2.1\nN;CHARSET=Windows-1252:B\u00f6rnig;Anke;;;\nFN;CHARSET=Windows-1252:Anke  B\u00f6rnig\nEND:VCARD";
        ImportResult[] importResult = VCardImportBugTests.importVCard(this.getWebConversation(), new ByteArrayInputStream("BEGIN:VCARD\nVERSION:2.1\nN;CHARSET=Windows-1252:B\u00f6rnig;Anke;;;\nFN;CHARSET=Windows-1252:Anke  B\u00f6rnig\nEND:VCARD".getBytes(Charsets.forName((String)"Cp1252"))), this.contactFolderId, this.timeZone, this.emailaddress, this.getHostName(), this.getSessionId());
        VCardImportBugTests.assertFalse((String)"Worked?", (boolean)importResult[0].hasError());
        int contactId = Integer.parseInt(importResult[0].getObjectId());
        Contact myImport = ContactTest.loadContact(this.getWebConversation(), contactId, this.contactFolderId, this.getHostName(), this.getLogin(), this.getPassword(), "");
        VCardImportBugTests.assertEquals((String)"Checking surname:", (String)"B\u00f6rnig", (String)myImport.getSurName());
    }

    public void testForDataTruncation() throws OXException, IOException, SAXException, JSONException, Exception {
        String name = "Hadschi Halef Omar Ben Hadschi Abul Abbas Ibn Hadschi Dawuhd al Gossarah Hadschi Halef Omar Ben Hadschi Abul Abbas Ibn Hadschi D...as War Knapp Und Wird Hier Abgeschnitten";
        String truncatedName = "Hadschi Halef Omar Ben Hadschi Abul Abbas Ibn Hadschi Dawuhd al Gossarah Hadschi Halef Omar Ben Hadschi Abul Abbas Ibn Hadschi D";
        String vcard = "BEGIN:VCARD\nVERSION:2.1\nN;CHARSET=Windows-1252:Hadschi Halef Omar Ben Hadschi Abul Abbas Ibn Hadschi Dawuhd al Gossarah Hadschi Halef Omar Ben Hadschi Abul Abbas Ibn Hadschi D...as War Knapp Und Wird Hier Abgeschnitten;;;\nEND:VCARD";
        ImportResult[] importResult = VCardImportBugTests.importVCard(this.getWebConversation(), new ByteArrayInputStream("BEGIN:VCARD\nVERSION:2.1\nN;CHARSET=Windows-1252:Hadschi Halef Omar Ben Hadschi Abul Abbas Ibn Hadschi Dawuhd al Gossarah Hadschi Halef Omar Ben Hadschi Abul Abbas Ibn Hadschi D...as War Knapp Und Wird Hier Abgeschnitten;;;\nEND:VCARD".getBytes(Charsets.forName((String)"Cp1252"))), this.contactFolderId, this.timeZone, this.emailaddress, this.getHostName(), this.getSessionId());
        VCardImportBugTests.assertFalse((String)"Worked?", (boolean)importResult[0].hasError());
        int contactId = Integer.parseInt(importResult[0].getObjectId());
        Contact myImport = ContactTest.loadContact(this.getWebConversation(), contactId, this.contactFolderId, this.getHostName(), this.getLogin(), this.getPassword(), "");
        VCardImportBugTests.assertEquals((String)"Checking surname:", (String)"Hadschi Halef Omar Ben Hadschi Abul Abbas Ibn Hadschi Dawuhd al Gossarah Hadschi Halef Omar Ben Hadschi Abul Abbas Ibn Hadschi D", (String)myImport.getSurName());
    }
}

