/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.importexport.Tools;
import com.openexchange.ajax.importexport.actions.ICalImportRequest;
import com.openexchange.ajax.importexport.actions.ICalImportResponse;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.importexport.exceptions.ImportExportExceptionCodes;

public class Bug10382Test
extends AbstractAJAXSession {
    private AJAXClient client;
    private AJAXClient client2;

    public Bug10382Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
    }

    @Override
    protected void tearDown() throws Exception {
        this.client2.logout();
        super.tearDown();
    }

    public void testBug() throws Throwable {
        Appointment appointment = new Appointment();
        appointment.setTitle("Bug10382Test");
        ICalImportResponse response = Executor.execute(this.client, new ICalImportRequest(this.client2.getValues().getPrivateAppointmentFolder(), Tools.toICal(this.client, appointment), false));
        Bug10382Test.assertTrue((String)"ICal imported without permissions.", (boolean)response.hasError());
        OXException exception = response.getException();
        Bug10382Test.assertNotNull((String)"Expected exception but got nothing.", (Object)((Object)exception));
        Bug10382Test.assertTrue((String)("Expected error code I_E-" + ImportExportExceptionCodes.NO_IMPORTER.getNumber() + " but got " + exception.getErrorCode()), (boolean)exception.similarTo((OXExceptionCode)ImportExportExceptionCodes.NO_IMPORTER));
    }
}

