/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder.actions;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.AbstractFolderRequest;
import com.openexchange.ajax.folder.actions.InsertParser;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.groupware.container.FolderObject;
import java.util.List;
import org.json.JSONException;

public class InsertRequest
extends AbstractFolderRequest<InsertResponse> {
    private final FolderObject folder;
    final boolean failOnError;

    public InsertRequest(API api, FolderObject folder) {
        this(api, folder, true);
    }

    public InsertRequest(API api, FolderObject folder, boolean failOnError) {
        super(api);
        this.failOnError = failOnError;
        this.folder = folder;
    }

    @Override
    public Object getBody() throws JSONException {
        return this.convert(this.folder);
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    protected void addParameters(List<AJAXRequest.Parameter> params) {
        params.add(new AJAXRequest.Parameter("action", "new"));
        if (this.folder.containsModule() && this.folder.getModule() == 7) {
            String[] parts = this.folder.getFullName().split("/");
            StringBuilder parentBuilder = new StringBuilder();
            for (int i = 0; i < parts.length - 1; ++i) {
                parentBuilder.append(parts[i]);
                parentBuilder.append('/');
            }
            String parent = parentBuilder.substring(0, parentBuilder.length() - 1);
            params.add(new AJAXRequest.Parameter("folder_id", parent));
        } else {
            params.add(new AJAXRequest.Parameter("folder_id", this.folder.getParentFolderID()));
        }
    }

    public InsertParser getParser() {
        return new InsertParser(this.failOnError);
    }
}

