/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.recurrence;

import com.openexchange.ajax.appointment.recurrence.ManagedAppointmentTest;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;
import com.openexchange.groupware.calendar.OXCalendarExceptionCodes;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Changes;
import com.openexchange.groupware.container.Expectations;

public class TestsForChangingAmongMonthlyRecurrences
extends ManagedAppointmentTest {
    public TestsForChangingAmongMonthlyRecurrences(String name) {
        super(name);
    }

    private Changes generateMonthlyChanges() {
        Changes changes = new Changes();
        changes.put(209, (Object)3);
        changes.put(215, (Object)1);
        changes.put(213, (Object)1);
        return changes;
    }

    public void testShouldChangeFromMonthly1ToMonthly2WhenCreating() throws Exception {
        Appointment app = this.generateMonthlyAppointment();
        Changes changes = this.generateMonthlyChanges();
        changes.put(212, (Object)2);
        Expectations expectations = new Expectations(changes);
        this.positiveAssertionOnCreateAndUpdate.check(app, changes, expectations);
    }

    public void testShouldChangeFromMonthly1ToMonthly2WhenUpdating() throws Exception {
        Appointment app = this.generateMonthlyAppointment();
        Changes changes = this.generateMonthlyChanges();
        changes.put(212, (Object)2);
        Expectations expectations = new Expectations(changes);
        this.positiveAssertionOnCreateAndUpdate.check(app, changes, expectations);
    }

    public void testShouldNotFailChangingFromMonthly1ToMonthly2() throws Exception {
        Appointment app = this.generateMonthlyAppointment();
        Changes changes = new Changes();
        changes.put(212, (Object)2);
        this.positiveAssertionOnCreate.check(app, changes, new Expectations(changes));
    }

    public void testShouldFailChangingFromMonthly1ToMonthly2UsingOnlyAdditionalData() throws Exception {
        Appointment app = this.generateMonthlyAppointment();
        Changes changes = new Changes();
        changes.put(209, (Object)3);
        changes.put(212, (Object)2);
        this.negativeAssertionOnUpdate.check(app, changes, OXExceptionFactory.getInstance().create((OXExceptionCode)OXCalendarExceptionCodes.INCOMPLETE_REC_INFOS_INTERVAL));
    }

    public void testShouldChangeFromMonthly2ToMonthly1With127DuringCreation() throws Exception {
        Appointment app = this.generateMonthlyAppointment();
        Changes changes = new Changes();
        changes.put(209, (Object)3);
        changes.put(212, (Object)127);
        changes.put(215, (Object)1);
        changes.put(213, (Object)1);
        Expectations expectations = new Expectations(changes);
        this.positiveAssertionOnCreate.check(app, changes, expectations);
    }

    public void testShouldChangeFromMonthly2ToMonthly1With127WhenUpdating() throws Exception {
        Appointment app = this.generateMonthlyAppointment();
        Changes changes = new Changes();
        changes.put(209, (Object)3);
        changes.put(212, (Object)127);
        changes.put(215, (Object)1);
        changes.put(213, (Object)1);
        Expectations expectations = new Expectations(changes);
        this.positiveAssertionOnCreateAndUpdate.check(app, changes, expectations);
    }

    public void testShouldChangeFromMonthly2ToMonthly1WithNullDuringCreation() throws Exception {
        Appointment app = this.generateMonthlyAppointment();
        Changes changes = new Changes();
        changes.put(209, (Object)3);
        changes.put(212, null);
        changes.put(215, (Object)1);
        changes.put(213, (Object)1);
        Expectations expectations = new Expectations(changes);
        expectations.put(212, (Object)127);
        this.positiveAssertionOnCreate.check(app, changes, expectations);
    }

    public void testShouldChangeFromMonthly2ToMonthly1WithNullWhenUpdating() throws Exception {
        Appointment app = this.generateMonthlyAppointment();
        Changes changes = new Changes();
        changes.put(209, (Object)3);
        changes.put(212, null);
        changes.put(215, (Object)1);
        changes.put(213, (Object)1);
        Expectations expectations = new Expectations(changes);
        expectations.put(212, (Object)127);
        this.positiveAssertionOnCreateAndUpdate.check(app, changes, expectations);
    }

    public void testShouldFailChangingFromMonthly2ToMonthly1UsingOnlyAdditionalData() throws Exception {
        Appointment app = this.generateMonthlyAppointment();
        Changes changes = new Changes();
        changes.put(209, (Object)3);
        changes.put(212, (Object)127);
        this.negativeAssertionOnUpdate.check(app, changes, OXExceptionFactory.getInstance().create((OXExceptionCode)OXCalendarExceptionCodes.INCOMPLETE_REC_INFOS_INTERVAL));
    }
}

