/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.Calendar;
import java.util.TimeZone;

public class Bug15937Test
extends AbstractAJAXSession {
    private AJAXClient client;
    private Appointment appointment;
    private TimeZone timeZone;

    public Bug15937Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.timeZone = this.client.getValues().getTimeZone();
        this.appointment = new Appointment();
        this.appointment.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.appointment.setTitle("Test for bug 15937");
        this.appointment.setIgnoreConflicts(true);
        Calendar calendar = TimeTools.createCalendar(this.timeZone);
        this.appointment.setStartDate(calendar.getTime());
        calendar.add(10, 1);
        this.appointment.setEndDate(calendar.getTime());
        this.appointment.setNumberOfAttachments(42);
        InsertRequest request = new InsertRequest(this.appointment, this.timeZone);
        AppointmentInsertResponse response = this.client.execute(request);
        response.fillAppointment(this.appointment);
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.execute(new DeleteRequest(this.appointment));
        super.tearDown();
    }

    public void testNumberOfAttachments() throws Throwable {
        GetRequest request = new GetRequest(this.appointment);
        GetResponse response = this.client.execute(request);
        Appointment testAppointment = response.getAppointment(this.timeZone);
        Bug15937Test.assertTrue((String)"Number of attachments should be send.", (boolean)testAppointment.containsNumberOfAttachments());
        Bug15937Test.assertEquals((String)"Number of attachments must be zero.", (int)0, (int)testAppointment.getNumberOfAttachments());
    }
}

