/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment;

import com.openexchange.ajax.AppointmentTest;
import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.CommonDeleteResponse;
import com.openexchange.groupware.container.Appointment;
import java.util.Date;
import org.junit.Test;

public class DeleteMultipleAppointmentTest
extends AppointmentTest {
    private AJAXClient client;
    private Appointment appointment1;
    private Appointment appointment2;

    public DeleteMultipleAppointmentTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client = new AJAXClient(AJAXClient.User.User1);
        this.appointment1 = new Appointment();
        this.appointment1.setIgnoreConflicts(true);
        this.appointment1.setTitle("Test 1");
        this.appointment1.setTimezone(this.timeZone.getDisplayName());
        this.appointment1.setStartDate(new Date());
        this.appointment1.setEndDate(new Date(System.currentTimeMillis() + 0x6DDD00L));
        this.appointment1.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        InsertRequest insReq1 = new InsertRequest(this.appointment1, this.timeZone);
        AppointmentInsertResponse insRes1 = this.client.execute(insReq1);
        insRes1.fillAppointment(this.appointment1);
        this.appointment2 = new Appointment();
        this.appointment2.setIgnoreConflicts(true);
        this.appointment2.setTitle("Test 2");
        this.appointment2.setTimezone(this.timeZone.getDisplayName());
        this.appointment2.setStartDate(new Date());
        this.appointment2.setEndDate(new Date(System.currentTimeMillis() + 0x6DDD00L));
        this.appointment2.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        InsertRequest insReq2 = new InsertRequest(this.appointment2, this.timeZone);
        AppointmentInsertResponse insRes2 = this.client.execute(insReq2);
        insRes2.fillAppointment(this.appointment2);
    }

    @Override
    public void tearDown() throws Exception {
        GetRequest getReq2;
        GetResponse getRes2;
        GetRequest getReq1 = new GetRequest(this.appointment1, false);
        GetResponse getRes1 = this.client.execute(getReq1);
        if (!getRes1.hasError()) {
            DeleteRequest delReq = new DeleteRequest(this.appointment1);
            this.client.execute(delReq);
        }
        if (!(getRes2 = this.client.execute(getReq2 = new GetRequest(this.appointment2, false))).hasError()) {
            DeleteRequest delReq = new DeleteRequest(this.appointment2);
            this.client.execute(delReq);
        }
        super.tearDown();
    }

    @Test
    public void testDeleteMultiple() throws Exception {
        int[] ids = new int[]{this.appointment1.getObjectID(), this.appointment2.getObjectID()};
        DeleteRequest delReq = new DeleteRequest(ids, this.client.getValues().getPrivateAppointmentFolder(), new Date(System.currentTimeMillis() + 300000L), true);
        CommonDeleteResponse delRes = this.client.execute(delReq);
        DeleteMultipleAppointmentTest.assertFalse((String)("Multiple delete failed: " + delRes.getErrorMessage()), (boolean)delRes.hasError());
    }
}

