/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.PutMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.ajax.AbstractAJAXTest;
import com.openexchange.ajax.LoginTest;
import com.openexchange.ajax.config.ConfigTools;
import com.openexchange.ajax.folder.FolderTools;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.FolderUpdatesResponse;
import com.openexchange.ajax.folder.actions.GetRequest;
import com.openexchange.ajax.folder.actions.GetResponse;
import com.openexchange.ajax.folder.actions.ListRequest;
import com.openexchange.ajax.folder.actions.ListResponse;
import com.openexchange.ajax.folder.actions.UpdatesRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.parser.FolderParser;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.java.Charsets;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.test.TestException;
import com.openexchange.tools.URLParameter;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.SAXException;

public class FolderTest
extends AbstractAJAXTest {
    private String sessionId;
    public static final String FOLDER_URL = "/ajax/folders";
    private static final int[] mapping_01 = new int[]{0, 2, 4, -1, 8};
    private static final int[] mapping = new int[]{0, -1, 1, -1, 2, -1, -1, -1, 4};

    public FolderTest(String name) {
        super(name);
    }

    private static String getCommaSeperatedIntegers(int[] intArray) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < intArray.length - 1; ++i) {
            sb.append(intArray[i]);
            sb.append(',');
        }
        sb.append(intArray[intArray.length - 1]);
        return sb.toString();
    }

    private static int[] parsePermissionBits(int bits) {
        int[] retval = new int[5];
        for (int i = retval.length - 1; i >= 0; --i) {
            int exponent = i * 7;
            retval[i] = bits >> exponent;
            bits -= retval[i] << exponent;
            retval[i] = retval[i] == 64 ? 128 : (i < retval.length - 1 ? mapping_01[retval[i]] : retval[i]);
        }
        return retval;
    }

    @Deprecated
    public static final int getUserId(WebConversation conversation, String hostname, String entityArg, String password) throws IOException, SAXException, JSONException, OXException, OXException {
        WebConversation conversation2 = new WebConversation();
        String sessionId = LoginTest.getSessionId(conversation2, hostname, entityArg, password);
        return ConfigTools.getUserId(conversation2, hostname, sessionId);
    }

    public static List<FolderObject> getRootFolders(WebConversation conversation, String hostname, String sessionId, boolean printOutput) throws MalformedURLException, IOException, SAXException, JSONException, OXException {
        return FolderTest.getRootFolders(conversation, null, hostname, sessionId, printOutput);
    }

    public static List<FolderObject> getRootFolders(WebConversation conversation, String protocol, String hostname, String sessionId, boolean printOutput) throws MalformedURLException, IOException, SAXException, JSONException, OXException {
        return FolderTest.getRootFolders(conversation, protocol, hostname, sessionId);
    }

    public static List<FolderObject> getRootFolders(WebConversation conversation, String protocol, String hostname, String sessionId) throws MalformedURLException, IOException, SAXException, JSONException, OXException {
        GetMethodWebRequest req = new GetMethodWebRequest((null == protocol ? "http://" : protocol + "://") + hostname + FOLDER_URL);
        req.setParameter("session", sessionId);
        req.setParameter("action", "root");
        String columns = "1,301,300,304";
        req.setParameter("columns", "1,301,300,304");
        WebResponse resp = conversation.getResponse((WebRequest)req);
        ArrayList<FolderObject> folders = new ArrayList<FolderObject>();
        JSONObject respObj = new JSONObject(resp.getText());
        JSONArray arr = respObj.getJSONArray("data");
        for (int i = 0; i < arr.length(); ++i) {
            JSONArray nestedArr = arr.getJSONArray(i);
            FolderObject rootFolder = new FolderObject();
            rootFolder.setObjectID(nestedArr.getInt(0));
            rootFolder.setModule(FolderParser.getModuleFromString((String)nestedArr.getString(1), (int)nestedArr.getInt(0)));
            rootFolder.setFolderName(nestedArr.getString(2));
            rootFolder.setSubfolderFlag(nestedArr.getBoolean(3));
            folders.add(rootFolder);
        }
        return folders;
    }

    public static List<FolderObject> getSubfolders(WebConversation conversation, String hostname, String sessionId, String parentIdentifier, boolean printOutput) throws MalformedURLException, IOException, SAXException, JSONException, OXException, OXException {
        return FolderTest.getSubfolders(conversation, null, hostname, sessionId, parentIdentifier);
    }

    public static List<FolderObject> getSubfolders(WebConversation conversation, String protocol, String hostname, String sessionId, String parentIdentifier) throws MalformedURLException, IOException, SAXException, JSONException, OXException, OXException {
        return FolderTest.getSubfolders(conversation, protocol, hostname, sessionId, parentIdentifier, false);
    }

    public static List<FolderObject> getSubfolders(WebConversation conversation, String hostname, String sessionId, String parentIdentifier, boolean printOutput, boolean ignoreMailfolder) throws MalformedURLException, IOException, SAXException, JSONException, OXException, OXException {
        return FolderTest.getSubfolders(conversation, null, hostname, sessionId, parentIdentifier, ignoreMailfolder);
    }

    public static List<FolderObject> getSubfolders(WebConversation conversation, String protocol, String hostname, String sessionId, String parentIdentifier, boolean ignoreMailfolder) throws MalformedURLException, IOException, SAXException, JSONException, OXException, OXException {
        AJAXClient client = new AJAXClient(new AJAXSession(conversation, hostname, sessionId));
        client.setProtocol(protocol);
        client.setHostname(hostname);
        return FolderTools.getSubFolders(client, parentIdentifier, ignoreMailfolder);
    }

    public static FolderObject getFolder(WebConversation conversation, String hostname, String sessionId, String folderIdentifier, Calendar timestamp, boolean printOutput) throws MalformedURLException, IOException, SAXException, JSONException, OXException {
        return FolderTest.getFolder(conversation, null, hostname, sessionId, folderIdentifier, timestamp);
    }

    public static FolderObject getFolder(WebConversation conversation, String protocol, String hostname, String sessionId, String folderIdentifier, Calendar timestamp) throws MalformedURLException, IOException, SAXException, JSONException, OXException {
        GetMethodWebRequest req = new GetMethodWebRequest((null == protocol ? "http://" : protocol + "://") + hostname + FOLDER_URL);
        req.setParameter("session", sessionId);
        req.setParameter("action", "get");
        req.setParameter("id", folderIdentifier);
        req.setParameter("columns", FolderTest.getCommaSeperatedIntegers(new int[]{1, 300, 305, 306}));
        WebResponse resp = conversation.getResponse((WebRequest)req);
        JSONObject respObj = new JSONObject(resp.getText());
        if (respObj.has("error") && !respObj.isNull("error")) {
            throw OXException.general((String)("Error occured: " + respObj.getString("error")));
        }
        if (!respObj.has("data") || respObj.isNull("data")) {
            throw OXException.general((String)"Error occured: Missing key \"data\"");
        }
        JSONObject jsonFolder = respObj.getJSONObject("data");
        FolderObject fo = new FolderObject();
        try {
            fo.setObjectID(jsonFolder.getInt("id"));
        }
        catch (JSONException exc) {
            fo.removeObjectID();
            fo.setFullName(jsonFolder.getString("id"));
        }
        if (!jsonFolder.isNull("created_by")) {
            fo.setCreatedBy(jsonFolder.getInt("created_by"));
        }
        if (!jsonFolder.isNull("creation_date")) {
            fo.setCreationDate(new Date(jsonFolder.getLong("creation_date")));
        }
        fo.setFolderName(jsonFolder.getString("title"));
        if (!jsonFolder.isNull("module")) {
            fo.setModule(FolderParser.getModuleFromString((String)jsonFolder.getString("module"), (int)(fo.containsObjectID() ? fo.getObjectID() : -1)));
        }
        if (jsonFolder.has("permissions") && !jsonFolder.isNull("permissions")) {
            JSONArray jsonArr = jsonFolder.getJSONArray("permissions");
            OCLPermission[] perms = new OCLPermission[jsonArr.length()];
            for (int i = 0; i < jsonArr.length(); ++i) {
                int[] permissionBits;
                JSONObject elem = jsonArr.getJSONObject(i);
                int entity = elem.getInt("entity");
                OCLPermission oclPerm = new OCLPermission();
                oclPerm.setEntity(entity);
                if (fo.containsObjectID()) {
                    oclPerm.setFuid(fo.getObjectID());
                }
                if (!oclPerm.setAllPermission((permissionBits = FolderTest.parsePermissionBits(elem.getInt("bits")))[0], permissionBits[1], permissionBits[2], permissionBits[3])) {
                    throw OXException.general((String)("Invalid permission values: fp=" + permissionBits[0] + " orp=" + permissionBits[1] + " owp=" + permissionBits[2] + " odp=" + permissionBits[3]));
                }
                oclPerm.setFolderAdmin(permissionBits[4] > 0);
                oclPerm.setGroupPermission(elem.getBoolean("group"));
                perms[i] = oclPerm;
            }
            fo.setPermissionsAsArray(perms);
        }
        if (respObj.has("timestamp") && !respObj.isNull("timestamp")) {
            timestamp.setTimeInMillis(respObj.getLong("timestamp"));
        }
        return fo;
    }

    public static int insertFolder(WebConversation conversation, String hostname, String sessionId, int entityId, boolean isGroup, int[] permsArr, boolean isAdmin, int parentFolderId, String folderName, String moduleStr, int type, int sharedForUserId, int[] sharedPermsArr, boolean sharedIsAdmin, boolean printOutput) throws JSONException, MalformedURLException, IOException, SAXException, OXException {
        return FolderTest.insertFolder(conversation, null, hostname, sessionId, entityId, isGroup, permsArr, isAdmin, parentFolderId, folderName, moduleStr, type, sharedForUserId, sharedPermsArr, sharedIsAdmin);
    }

    public static int insertFolder(WebConversation conversation, String protocol, String hostname, String sessionId, int entityId, boolean isGroup, int[] permsArr, boolean isAdmin, int parentFolderId, String folderName, String moduleStr, int type, int sharedForUserId, int[] sharedPermsArr, boolean sharedIsAdmin) throws JSONException, MalformedURLException, IOException, SAXException, OXException {
        JSONObject jsonFolder = new JSONObject();
        jsonFolder.put("title", (Object)folderName);
        JSONArray perms = new JSONArray();
        JSONObject jsonPermission = new JSONObject();
        jsonPermission.put("entity", entityId);
        jsonPermission.put("group", isGroup);
        jsonPermission.put("bits", FolderTest.createPermissionBits(permsArr[0], permsArr[1], permsArr[2], permsArr[3], isAdmin));
        perms.put((Object)jsonPermission);
        if (sharedForUserId != -1) {
            jsonPermission = new JSONObject();
            jsonPermission.put("entity", sharedForUserId);
            jsonPermission.put("group", false);
            jsonPermission.put("bits", FolderTest.createPermissionBits(sharedPermsArr[0], sharedPermsArr[1], sharedPermsArr[2], sharedPermsArr[3], sharedIsAdmin));
            perms.put((Object)jsonPermission);
        }
        jsonFolder.put("permissions", (Object)perms);
        jsonFolder.put("module", (Object)moduleStr);
        jsonFolder.put("type", type);
        URLParameter urlParam = new URLParameter();
        urlParam.setParameter("action", "new");
        urlParam.setParameter("session", sessionId);
        urlParam.setParameter("folder_id", Integer.toString(parentFolderId));
        byte[] bytes = jsonFolder.toString().getBytes(Charsets.UTF_8);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        PutMethodWebRequest req = new PutMethodWebRequest((null == protocol ? "http://" : protocol + "://") + hostname + FOLDER_URL + urlParam.getURLParameters(), (InputStream)bais, "text/javascript; charset=UTF-8");
        WebResponse resp = conversation.getResponse((WebRequest)req);
        JSONObject respObj = new JSONObject(resp.getText());
        if (!respObj.has("data") || respObj.has("error")) {
            throw OXException.general((String)("Folder Insert failed" + (respObj.has("error") ? ": " + respObj.getString("error") : "")));
        }
        return respObj.getInt("data");
    }

    public static int insertFolder(WebConversation conversation, String hostname, String sessionId, int entityId, boolean isGroup, int parentFolderId, String folderName, String moduleStr, int type, int sharedForUserId, boolean printOutput) throws JSONException, MalformedURLException, IOException, SAXException, OXException {
        return FolderTest.insertFolder(conversation, null, hostname, sessionId, entityId, isGroup, parentFolderId, folderName, moduleStr, type, sharedForUserId);
    }

    public static int insertFolder(WebConversation conversation, String protocol, String hostname, String sessionId, int entityId, boolean isGroup, int parentFolderId, String folderName, String moduleStr, int type, int sharedForUserId) throws JSONException, MalformedURLException, IOException, SAXException, OXException {
        JSONObject jsonFolder = new JSONObject();
        jsonFolder.put("title", (Object)folderName);
        JSONArray perms = new JSONArray();
        JSONObject jsonPermission = new JSONObject();
        jsonPermission.put("entity", entityId);
        jsonPermission.put("group", isGroup);
        jsonPermission.put("bits", FolderTest.createPermissionBits(8, 4, 4, 4, true));
        perms.put((Object)jsonPermission);
        if (sharedForUserId != -1) {
            jsonPermission = new JSONObject();
            jsonPermission.put("entity", sharedForUserId);
            jsonPermission.put("group", false);
            jsonPermission.put("bits", FolderTest.createPermissionBits(4, 4, 0, 0, false));
            perms.put((Object)jsonPermission);
        }
        jsonFolder.put("permissions", (Object)perms);
        jsonFolder.put("module", (Object)moduleStr);
        jsonFolder.put("type", type);
        URLParameter urlParam = new URLParameter();
        urlParam.setParameter("action", "new");
        urlParam.setParameter("session", sessionId);
        urlParam.setParameter("folder_id", Integer.toString(parentFolderId));
        byte[] bytes = jsonFolder.toString().getBytes(Charsets.UTF_8);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        PutMethodWebRequest req = new PutMethodWebRequest((null == protocol ? "http://" : protocol + "://") + hostname + FOLDER_URL + urlParam.getURLParameters(), (InputStream)bais, "text/javascript; charset=UTF-8");
        WebResponse resp = conversation.getResponse((WebRequest)req);
        JSONObject respObj = new JSONObject(resp.getText());
        if (!respObj.has("data") || respObj.has("error")) {
            throw OXException.general((String)("Folder Insert failed" + (respObj.has("error") ? ": " + respObj.getString("error") : "")));
        }
        return respObj.getInt("data");
    }

    public static boolean renameFolder(WebConversation conversation, String hostname, String sessionId, int folderId, String folderName, String moduleStr, int type, long timestamp, boolean printOutput) throws JSONException, MalformedURLException, IOException, SAXException {
        return FolderTest.renameFolder(conversation, null, hostname, sessionId, folderId, folderName, moduleStr, type, timestamp);
    }

    public static boolean renameFolder(WebConversation conversation, String protocol, String hostname, String sessionId, int folderId, String folderName, String moduleStr, int type, long timestamp) throws JSONException, MalformedURLException, IOException, SAXException {
        JSONObject jsonFolder = new JSONObject();
        jsonFolder.put("id", folderId);
        jsonFolder.put("title", (Object)folderName);
        jsonFolder.put("module", (Object)moduleStr);
        jsonFolder.put("type", type);
        URLParameter urlParam = new URLParameter();
        urlParam.setParameter("action", "update");
        urlParam.setParameter("session", sessionId);
        urlParam.setParameter("id", Integer.toString(folderId));
        urlParam.setParameter("timestamp", String.valueOf(timestamp));
        byte[] bytes = jsonFolder.toString().getBytes(Charsets.UTF_8);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        PutMethodWebRequest req = new PutMethodWebRequest((null == protocol ? "http://" : protocol + "://") + hostname + FOLDER_URL + urlParam.getURLParameters(), (InputStream)bais, "text/javascript; charset=UTF-8");
        WebResponse resp = conversation.getResponse((WebRequest)req);
        JSONObject respObj = new JSONObject(resp.getText());
        return !respObj.has("error");
    }

    public static boolean updateFolder(WebConversation conversation, String hostname, String sessionId, String entityArg, String secondEntityArg, int folderId, long timestamp, boolean printOutput) throws JSONException, MalformedURLException, IOException, SAXException {
        return FolderTest.updateFolder(conversation, null, hostname, sessionId, entityArg, secondEntityArg, folderId, timestamp);
    }

    public static boolean updateFolder(WebConversation conversation, String protocol, String hostname, String sessionId, String entityArg, String secondEntityArg, int folderId, long timestamp) throws JSONException, MalformedURLException, IOException, SAXException {
        return FolderTest.updateFolder(conversation, protocol, hostname, sessionId, entityArg, secondEntityArg, folderId, timestamp, 0);
    }

    public static boolean updateFolder(WebConversation conversation, String protocol, String hostname, String sessionId, String entityArg, String secondEntityArg, int folderId, long timestamp, int permissions) throws JSONException, MalformedURLException, IOException, SAXException {
        String entity;
        String string = entity = entityArg.indexOf(64) == -1 ? entityArg : entityArg.substring(0, entityArg.indexOf(64));
        String secondEntity = secondEntityArg == null ? null : (secondEntityArg.indexOf(64) == -1 ? secondEntityArg : secondEntityArg.substring(0, secondEntityArg.indexOf(64)));
        JSONObject jsonFolder = new JSONObject();
        jsonFolder.put("id", folderId);
        JSONArray perms = new JSONArray();
        JSONObject jsonPermission = new JSONObject();
        jsonPermission.put("entity", (Object)entity);
        jsonPermission.put("group", false);
        jsonPermission.put("bits", 0 == permissions ? FolderTest.createPermissionBits(8, 8, 8, 8, true) : permissions);
        perms.put((Object)jsonPermission);
        if (null != secondEntity) {
            jsonPermission = new JSONObject();
            jsonPermission.put("entity", (Object)secondEntity);
            jsonPermission.put("group", false);
            jsonPermission.put("bits", FolderTest.createPermissionBits(4, 0, 0, 0, false));
            perms.put((Object)jsonPermission);
        }
        jsonFolder.put("permissions", (Object)perms);
        URLParameter urlParam = new URLParameter();
        urlParam.setParameter("action", "update");
        urlParam.setParameter("session", sessionId);
        urlParam.setParameter("id", Integer.toString(folderId));
        urlParam.setParameter("timestamp", String.valueOf(timestamp));
        byte[] bytes = jsonFolder.toString().getBytes(Charsets.UTF_8);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        PutMethodWebRequest req = new PutMethodWebRequest((null == protocol ? "http://" : protocol + "://") + hostname + FOLDER_URL + urlParam.getURLParameters(), (InputStream)bais, "text/javascript; charset=UTF-8");
        WebResponse resp = conversation.getResponse((WebRequest)req);
        JSONObject respObj = new JSONObject(resp.getText());
        return !respObj.has("error");
    }

    public static boolean moveFolder(WebConversation conversation, String hostname, String sessionId, String folderId, String tgtFolderId, long timestamp, boolean printOutput) throws JSONException, MalformedURLException, IOException, SAXException {
        return FolderTest.moveFolder(conversation, null, hostname, sessionId, folderId, tgtFolderId, timestamp);
    }

    public static boolean moveFolder(WebConversation conversation, String protocol, String hostname, String sessionId, String folderId, String tgtFolderId, long timestamp) throws JSONException, MalformedURLException, IOException, SAXException {
        JSONObject jsonFolder = new JSONObject();
        jsonFolder.put("id", (Object)folderId);
        jsonFolder.put("folder_id", (Object)tgtFolderId);
        URLParameter urlParam = new URLParameter();
        urlParam.setParameter("action", "update");
        urlParam.setParameter("session", sessionId);
        urlParam.setParameter("id", String.valueOf(folderId));
        urlParam.setParameter("timestamp", String.valueOf(timestamp));
        byte[] bytes = jsonFolder.toString().getBytes(Charsets.UTF_8);
        UnsynchronizedByteArrayInputStream bais = new UnsynchronizedByteArrayInputStream(bytes);
        PutMethodWebRequest req = new PutMethodWebRequest((null == protocol ? "http://" : protocol + "://") + hostname + FOLDER_URL + urlParam.getURLParameters(), (InputStream)bais, "text/javascript; charset=UTF-8");
        WebResponse resp = conversation.getResponse((WebRequest)req);
        JSONObject respObj = new JSONObject(resp.getText());
        return !respObj.has("error");
    }

    public static int[] deleteFolders(WebConversation conversation, String hostname, String sessionId, int[] folderIds, long timestamp, boolean printOutput) throws JSONException, IOException, SAXException {
        return FolderTest.deleteFolders(conversation, null, hostname, sessionId, folderIds, timestamp);
    }

    public static int[] deleteFolders(WebConversation conversation, String protocol, String hostname, String sessionId, int[] folderIds, long timestamp) throws JSONException, IOException, SAXException {
        JSONArray deleteIds = new JSONArray(Arrays.toString(folderIds));
        byte[] bytes = deleteIds.toString().getBytes(Charsets.UTF_8);
        UnsynchronizedByteArrayInputStream bais = new UnsynchronizedByteArrayInputStream(bytes);
        URLParameter urlParam = new URLParameter();
        urlParam.setParameter("action", "delete");
        urlParam.setParameter("session", sessionId);
        urlParam.setParameter("timestamp", String.valueOf(timestamp));
        PutMethodWebRequest req = new PutMethodWebRequest((null == protocol ? "http://" : protocol + "://") + hostname + FOLDER_URL + urlParam.getURLParameters(), (InputStream)bais, "text/javascript; charset=UTF-8");
        WebResponse resp = conversation.getResponse((WebRequest)req);
        JSONObject respObj = new JSONObject(resp.getText());
        if (respObj.has("error")) {
            throw new JSONException("JSON Response object contains an error: " + respObj.getString("error"));
        }
        JSONArray arr = respObj.getJSONArray("data");
        int[] retval = new int[arr.length()];
        for (int i = 0; i < arr.length(); ++i) {
            retval[i] = arr.getInt(i);
        }
        return retval;
    }

    public static int[] clearFolder(WebConversation conversation, String hostname, String sessionId, int[] folderIds, long timestamp) throws JSONException, IOException, SAXException {
        return FolderTest.clearFolder(conversation, null, hostname, sessionId, folderIds, timestamp);
    }

    public static int[] clearFolder(WebConversation conversation, String protocol, String hostname, String sessionId, int[] folderIds, long timestamp) throws JSONException, IOException, SAXException {
        JSONArray clearIds = new JSONArray(Arrays.toString(folderIds));
        URLParameter urlParam = new URLParameter();
        urlParam.setParameter("action", "clear");
        urlParam.setParameter("session", sessionId);
        urlParam.setParameter("timestamp", Long.toString(timestamp));
        PutMethodWebRequest req = new PutMethodWebRequest((null == protocol ? "http://" : protocol + "://") + hostname + FOLDER_URL + urlParam.getURLParameters(), (InputStream)new UnsynchronizedByteArrayInputStream(clearIds.toString().getBytes(Charsets.UTF_8)), "text/javascript; charset=UTF-8");
        WebResponse resp = conversation.getResponse((WebRequest)req);
        JSONObject respObj = new JSONObject(resp.getText());
        if (respObj.has("error")) {
            throw new JSONException("JSON Response object contains an error: " + respObj.getString("error"));
        }
        JSONArray arr = respObj.getJSONArray("data");
        int[] retval = new int[arr.length()];
        for (int i = 0; i < arr.length(); ++i) {
            retval[i] = arr.getInt(i);
        }
        return retval;
    }

    public static int createPermissionBits(int fp, int orp, int owp, int odp, boolean adminFlag) {
        int[] perms = new int[]{fp, orp, owp, odp, adminFlag ? 1 : 0};
        return FolderTest.createPermissionBits(perms);
    }

    private static int createPermissionBits(int[] permission) {
        int retval = 0;
        boolean first = true;
        for (int i = permission.length - 1; i >= 0; --i) {
            int exponent = i * 7;
            if (first) {
                retval += permission[i] << exponent;
                first = false;
                continue;
            }
            if (permission[i] == 128) {
                retval += 64 << exponent;
                continue;
            }
            retval += mapping[permission[i]] << exponent;
        }
        return retval;
    }

    public static FolderObject getStandardFolder(int module, String protocol, WebConversation conversation, String hostname, String sessionId) throws MalformedURLException, OXException, OXException, IOException, SAXException, JSONException {
        List<FolderObject> subfolders = FolderTest.getSubfolders(conversation, protocol, hostname, sessionId, Integer.toString(1), true);
        if (null != subfolders && 0 < subfolders.size()) {
            for (FolderObject subfolder : subfolders) {
                if (module != subfolder.getModule() || !subfolder.isDefaultFolder()) continue;
                return subfolder;
            }
        }
        throw OXException.general((String)String.format("No standard folder for module '%d' found", module));
    }

    public static FolderObject getStandardTaskFolder(WebConversation conversation, String hostname, String sessionId) throws MalformedURLException, IOException, SAXException, JSONException, OXException, OXException {
        return FolderTest.getStandardTaskFolder(conversation, null, hostname, sessionId);
    }

    public static FolderObject getStandardTaskFolder(WebConversation conversation, String protocol, String hostname, String sessionId) throws MalformedURLException, IOException, SAXException, JSONException, OXException, OXException {
        List<FolderObject> subfolders = FolderTest.getSubfolders(conversation, protocol, hostname, sessionId, "1", true);
        for (FolderObject subfolder : subfolders) {
            if (subfolder.getModule() != 1 || !subfolder.isDefaultFolder()) continue;
            return subfolder;
        }
        throw OXException.general((String)"No Standard Task Folder found!");
    }

    public static FolderObject getStandardCalendarFolder(WebConversation conversation, String hostname, String sessionId) throws MalformedURLException, IOException, SAXException, JSONException, OXException, OXException {
        return FolderTest.getStandardCalendarFolder(conversation, null, hostname, sessionId);
    }

    public static FolderObject getStandardCalendarFolder(WebConversation conversation, String protocol, String hostname, String sessionId) throws MalformedURLException, IOException, SAXException, JSONException, OXException, OXException {
        List<FolderObject> subfolders = FolderTest.getSubfolders(conversation, protocol, hostname, sessionId, "1", true);
        for (FolderObject subfolder : subfolders) {
            if (subfolder.getModule() != 2 || !subfolder.isDefaultFolder()) continue;
            return subfolder;
        }
        throw OXException.general((String)"No Standard Calendar Folder found!");
    }

    public static FolderObject getStandardContactFolder(WebConversation conversation, String hostname, String sessionId) throws MalformedURLException, IOException, SAXException, JSONException, OXException, OXException {
        return FolderTest.getStandardContactFolder(conversation, null, hostname, sessionId);
    }

    public static FolderObject getStandardContactFolder(WebConversation conversation, String protocol, String hostname, String sessionId) throws MalformedURLException, IOException, SAXException, JSONException, OXException, OXException {
        List<FolderObject> subfolders = FolderTest.getSubfolders(conversation, protocol, hostname, sessionId, FolderStorage.PRIVATE_ID, true);
        for (FolderObject subfolder : subfolders) {
            if (subfolder.getModule() != 3 || !subfolder.isDefaultFolder()) continue;
            return subfolder;
        }
        throw OXException.general((String)"No Standard Contact Folder found!");
    }

    public static FolderObject getStandardInfostoreFolder(WebConversation conversation, String hostname, String sessionId) throws MalformedURLException, IOException, SAXException, JSONException, OXException, OXException {
        return FolderTest.getStandardInfostoreFolder(conversation, null, hostname, sessionId);
    }

    public static FolderObject getStandardInfostoreFolder(WebConversation conversation, String protocol, String hostname, String sessionId) throws MalformedURLException, IOException, SAXException, JSONException, OXException, OXException {
        List<FolderObject> subfolders = FolderTest.getSubfolders(conversation, protocol, hostname, sessionId, "1", true);
        for (FolderObject subfolder : subfolders) {
            if (subfolder.getModule() != 8 || !subfolder.isDefaultFolder()) continue;
            return subfolder;
        }
        throw OXException.general((String)"No Standard Infostore Folder found!");
    }

    public static FolderObject getMyInfostoreFolder(WebConversation conversation, String hostname, String sessionId, int loginId) throws MalformedURLException, IOException, SAXException, JSONException, OXException, OXException, OXException {
        return FolderTest.getMyInfostoreFolder(conversation, null, hostname, sessionId, loginId);
    }

    public static FolderObject getMyInfostoreFolder(WebConversation conversation, String protocol, String hostname, String sessionId, int loginId) throws MalformedURLException, IOException, SAXException, JSONException, OXException, OXException, OXException {
        FolderObject infostore = null;
        List<FolderObject> l = FolderTest.getRootFolders(conversation, protocol, hostname, sessionId, false);
        for (FolderObject rf : l) {
            if (rf.getObjectID() != 9) continue;
            infostore = rf;
            break;
        }
        if (null == infostore) {
            throw new TestException("System infostore folder not found!");
        }
        FolderObject userStore = null;
        l = FolderTest.getSubfolders(conversation, protocol, hostname, sessionId, Integer.toString(infostore.getObjectID()));
        for (FolderObject f : l) {
            if (f.getObjectID() != 10) continue;
            userStore = f;
            break;
        }
        if (null == userStore) {
            throw new TestException("System user store folder not found!");
        }
        l = FolderTest.getSubfolders(conversation, protocol, hostname, sessionId, Integer.toString(userStore.getObjectID()));
        for (FolderObject f : l) {
            if (!f.containsDefaultFolder() || !f.isDefaultFolder() || f.getCreator() != loginId) continue;
            return f;
        }
        throw new TestException("Private infostore folder not found!");
    }

    public void setUp() throws Exception {
        this.sessionId = this.getSessionId();
    }

    @Override
    public void tearDown() throws Exception {
        this.logout();
        super.tearDown();
    }

    public void testGetUserId() throws OXException, OXException, IOException, SAXException, JSONException {
        FolderTest.getUserId(this.getWebConversation(), this.getHostName(), this.getLogin(), this.getPassword());
    }

    public void testGetRootFolders() throws OXException, IOException, SAXException, JSONException, OXException {
        int[] assumedIds = new int[]{1, 2, 3, 9};
        List<FolderObject> l = FolderTest.getRootFolders(this.getWebConversation(), this.getHostName(), this.getSessionId(), true);
        FolderTest.assertFalse((l == null || l.size() == 0 ? 1 : 0) != 0);
        int i = 0;
        for (FolderObject rf : l) {
            FolderTest.assertTrue((rf.getObjectID() == assumedIds[i] ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testDeleteFolder() throws OXException, JSONException, IOException, SAXException, OXException, OXException {
        int userId = FolderTest.getUserId(this.getWebConversation(), this.getHostName(), this.getLogin(), this.getPassword());
        int parent = FolderTest.insertFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), userId, false, 2, "DeleteMeImmediately" + System.currentTimeMillis(), "calendar", 2, -1, true);
        FolderTest.assertFalse((parent == -1 ? 1 : 0) != 0);
        Calendar cal = GregorianCalendar.getInstance();
        FolderTest.getFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), "" + parent, cal, true);
        int child01 = FolderTest.insertFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), userId, false, parent, "DeleteMeImmediatelyChild01" + System.currentTimeMillis(), "calendar", 2, -1, true);
        FolderTest.assertFalse((child01 == -1 ? 1 : 0) != 0);
        FolderTest.getFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), "" + child01, cal, true);
        int child02 = FolderTest.insertFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), userId, false, parent, "DeleteMeImmediatelyChild02" + System.currentTimeMillis(), "calendar", 2, -1, true);
        FolderTest.assertFalse((child02 == -1 ? 1 : 0) != 0);
        FolderTest.getFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), "" + child02, cal, true);
        int[] failedIds = FolderTest.deleteFolders(this.getWebConversation(), this.getHostName(), this.getSessionId(), new int[]{parent}, cal.getTimeInMillis(), true);
        FolderTest.assertTrue((failedIds == null || failedIds.length == 0 ? 1 : 0) != 0);
    }

    public void testCheckFolderPermissions() throws OXException, OXException, IOException, SAXException, JSONException, OXException {
        int userId = FolderTest.getUserId(this.getWebConversation(), this.getHostName(), this.getLogin(), this.getPassword());
        int fuid = FolderTest.insertFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), userId, false, 2, "CheckMyPermissions", "calendar", 2, -1, true);
        Calendar cal = GregorianCalendar.getInstance();
        FolderTest.getFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), "" + fuid, cal, true);
        FolderTest.updateFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), this.getLogin(), this.getSeconduser(), fuid, cal.getTimeInMillis(), true);
        FolderTest.getFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), "" + fuid, cal, true);
        FolderTest.deleteFolders(this.getWebConversation(), this.getHostName(), this.getSessionId(), new int[]{fuid}, cal.getTimeInMillis(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInsertRenameFolder() throws OXException, OXException, IOException, SAXException, JSONException, OXException, OXException {
        int fuid = -1;
        int[] failedIds = null;
        boolean updated = false;
        try {
            int userId = FolderTest.getUserId(this.getWebConversation(), this.getHostName(), this.getLogin(), this.getPassword());
            fuid = FolderTest.insertFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), userId, false, 1, "NewPrivateFolder" + System.currentTimeMillis(), "calendar", 1, -1, true);
            FolderTest.assertFalse((fuid == -1 ? 1 : 0) != 0);
            Calendar cal = GregorianCalendar.getInstance();
            FolderTest.getFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), "" + fuid, cal, true);
            updated = FolderTest.renameFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), fuid, "ChangedPrivateFolderName" + System.currentTimeMillis(), "calendar", 1, cal.getTimeInMillis(), true);
            FolderTest.assertTrue((boolean)updated);
            FolderTest.getFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), "" + fuid, cal, true);
            failedIds = FolderTest.deleteFolders(this.getWebConversation(), this.getHostName(), this.getSessionId(), new int[]{fuid}, cal.getTimeInMillis(), true);
            FolderTest.assertFalse((failedIds != null && failedIds.length > 0 ? 1 : 0) != 0);
            fuid = FolderTest.insertFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), userId, false, 2, "NewPublicFolder" + System.currentTimeMillis(), "calendar", 1, -1, true);
            FolderTest.assertFalse((fuid == -1 ? 1 : 0) != 0);
            FolderTest.getFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), "" + fuid, cal, true);
            failedIds = FolderTest.deleteFolders(this.getWebConversation(), this.getHostName(), this.getSessionId(), new int[]{fuid}, cal.getTimeInMillis(), true);
            FolderTest.assertFalse((failedIds != null && failedIds.length > 0 ? 1 : 0) != 0);
            fuid = -1;
            FolderObject myInfostore = FolderTest.getMyInfostoreFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), userId);
            fuid = FolderTest.insertFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), userId, false, myInfostore.getObjectID(), "NewInfostoreFolder" + System.currentTimeMillis(), "infostore", 2, -1, true);
            FolderTest.assertFalse((fuid == -1 ? 1 : 0) != 0);
            FolderTest.getFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), "" + fuid, cal, true);
            updated = FolderTest.renameFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), fuid, "ChangedInfostoreFolderName" + System.currentTimeMillis(), "infostore", 2, cal.getTimeInMillis(), true);
            FolderTest.assertTrue((boolean)updated);
            FolderTest.getFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), "" + fuid, cal, true);
            failedIds = FolderTest.deleteFolders(this.getWebConversation(), this.getHostName(), this.getSessionId(), new int[]{fuid}, cal.getTimeInMillis(), true);
            FolderTest.assertFalse((failedIds != null && failedIds.length > 0 ? 1 : 0) != 0);
            fuid = -1;
        }
        catch (Throwable throwable) {
            try {
                if (fuid != -1) {
                    Calendar cal = GregorianCalendar.getInstance();
                    FolderTest.getFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), "" + fuid, cal, false);
                    FolderTest.deleteFolders(this.getWebConversation(), this.getHostName(), this.getSessionId(), new int[]{fuid}, cal.getTimeInMillis(), false);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            throw throwable;
        }
        try {
            if (fuid != -1) {
                Calendar cal = GregorianCalendar.getInstance();
                FolderTest.getFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), "" + fuid, cal, false);
                FolderTest.deleteFolders(this.getWebConversation(), this.getHostName(), this.getSessionId(), new int[]{fuid}, cal.getTimeInMillis(), false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testSharedFolder() throws OXException, OXException, IOException, SAXException, JSONException, OXException {
        int fuid01 = -1;
        int fuid02 = -1;
        String anotherSessionId = null;
        int userId = FolderTest.getUserId(this.getWebConversation(), this.getHostName(), this.getLogin(), this.getPassword());
        int secId = FolderTest.getUserId(this.getWebConversation(), this.getHostName(), this.getSeconduser(), this.getPassword());
        fuid01 = FolderTest.insertFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), userId, false, 1, "SharedFolder01" + System.currentTimeMillis(), "calendar", 1, secId, true);
        FolderTest.assertFalse((fuid01 == -1 ? 1 : 0) != 0);
        fuid02 = FolderTest.insertFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), userId, false, 1, "SharedFolder02" + System.currentTimeMillis(), "calendar", 1, secId, true);
        FolderTest.assertFalse((fuid02 == -1 ? 1 : 0) != 0);
        anotherSessionId = LoginTest.getSessionId(this.getSecondWebConversation(), this.getHostName(), this.getSeconduser(), this.getPassword());
        boolean found01 = false;
        boolean found02 = false;
        List<FolderObject> l = FolderTest.getSubfolders(this.getSecondWebConversation(), this.getHostName(), anotherSessionId, "3", true);
        FolderTest.assertFalse((l == null || l.size() == 0 ? 1 : 0) != 0);
        block0: for (FolderObject virtualFO : l) {
            List<FolderObject> subList = FolderTest.getSubfolders(this.getSecondWebConversation(), this.getHostName(), anotherSessionId, virtualFO.getFullName(), true);
            for (FolderObject sharedFolder : subList) {
                if (sharedFolder.getObjectID() == fuid01 && (found01 = true) && found02) break block0;
                if (sharedFolder.getObjectID() != fuid02) continue;
                found02 = true;
                if (!found01 || !found02) continue;
                break block0;
            }
        }
        FolderTest.assertTrue((boolean)found01);
        FolderTest.assertTrue((boolean)found02);
        String sesID = this.getSessionId();
        FolderTest.deleteFolders(this.getWebConversation(), this.getHostName(), sesID, new int[]{fuid01, fuid02}, System.currentTimeMillis(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testGetSubfolder() throws OXException, OXException, IOException, SAXException, JSONException, OXException {
        int fuid = -1;
        int[] subfuids = null;
        try {
            int userId = FolderTest.getUserId(this.getWebConversation(), this.getHostName(), this.getLogin(), this.getPassword());
            fuid = FolderTest.insertFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), userId, false, 1, "NewPrivateFolder" + System.currentTimeMillis(), "calendar", 1, -1, true);
            DecimalFormat df = new DecimalFormat("00");
            subfuids = new int[3];
            for (int i = 0; i < subfuids.length; ++i) {
                subfuids[i] = FolderTest.insertFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), userId, false, fuid, "NewPrivateSubFolder" + String.valueOf(System.currentTimeMillis()) + "_" + df.format(i + 1), "calendar", 1, -1, true);
            }
            List<FolderObject> l = FolderTest.getSubfolders(this.getWebConversation(), this.getHostName(), this.getSessionId(), "" + fuid, true);
            FolderTest.assertFalse((l == null || l.size() == 0 ? 1 : 0) != 0);
            int i = 0;
            for (FolderObject subFolder : l) {
                FolderTest.assertTrue((subFolder.getObjectID() == subfuids[i] ? 1 : 0) != 0);
                ++i;
            }
            if (fuid == -1) return;
        }
        catch (Throwable throwable) {
            if (fuid == -1) throw throwable;
            Calendar cal = GregorianCalendar.getInstance();
            FolderTest.getFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), "" + fuid, cal, true);
            int[] failedIds = FolderTest.deleteFolders(this.getWebConversation(), this.getHostName(), this.getSessionId(), new int[]{fuid}, cal.getTimeInMillis(), true);
            if (failedIds == null || failedIds.length <= 0 || subfuids == null) throw throwable;
            for (int i = 0; i < subfuids.length; ++i) {
                if (subfuids[i] <= 0) continue;
                FolderTest.getFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), "" + subfuids[i], cal, true);
                FolderTest.deleteFolders(this.getWebConversation(), this.getHostName(), this.getSessionId(), new int[]{subfuids[i]}, cal.getTimeInMillis(), true);
            }
            throw throwable;
        }
        Calendar cal = GregorianCalendar.getInstance();
        FolderTest.getFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), "" + fuid, cal, true);
        int[] failedIds = FolderTest.deleteFolders(this.getWebConversation(), this.getHostName(), this.getSessionId(), new int[]{fuid}, cal.getTimeInMillis(), true);
        if (failedIds == null || failedIds.length <= 0 || subfuids == null) return;
        for (int i = 0; i < subfuids.length; ++i) {
            if (subfuids[i] <= 0) continue;
            FolderTest.getFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), "" + subfuids[i], cal, true);
            FolderTest.deleteFolders(this.getWebConversation(), this.getHostName(), this.getSessionId(), new int[]{subfuids[i]}, cal.getTimeInMillis(), true);
        }
        return;
    }

    public void testMoveFolder() throws OXException, OXException, IOException, SAXException, JSONException, OXException {
        int parent01 = -1;
        int parent02 = -1;
        int moveFuid = -1;
        int[] failedIds = null;
        boolean moved = false;
        int userId = FolderTest.getUserId(this.getWebConversation(), this.getHostName(), this.getLogin(), this.getPassword());
        parent01 = FolderTest.insertFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), userId, false, 1, "Parent01" + System.currentTimeMillis(), "calendar", 1, -1, true);
        FolderTest.assertFalse((parent01 == -1 ? 1 : 0) != 0);
        parent02 = FolderTest.insertFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), userId, false, 1, "Parent02" + System.currentTimeMillis(), "calendar", 1, -1, true);
        FolderTest.assertFalse((parent02 == -1 ? 1 : 0) != 0);
        moveFuid = FolderTest.insertFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), userId, false, parent01, "MoveMe" + System.currentTimeMillis(), "calendar", 1, -1, true);
        FolderTest.assertFalse((moveFuid == -1 ? 1 : 0) != 0);
        Calendar cal = GregorianCalendar.getInstance();
        FolderTest.getFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), "" + moveFuid, cal, true);
        moved = FolderTest.moveFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), "" + moveFuid, "" + parent02, cal.getTimeInMillis(), true);
        FolderTest.assertTrue((boolean)moved);
        FolderObject movedFolderObj = null;
        movedFolderObj = FolderTest.getFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), "" + moveFuid, cal, true);
        FolderTest.assertTrue((boolean)(movedFolderObj.containsParentFolderID() ? movedFolderObj.getParentFolderID() == parent02 : true));
        failedIds = FolderTest.deleteFolders(this.getWebConversation(), this.getHostName(), this.getSessionId(), new int[]{parent01, parent02}, cal.getTimeInMillis(), true);
        FolderTest.assertFalse((failedIds != null && failedIds.length > 0 ? 1 : 0) != 0);
    }

    public void testFolderNamesShouldBeEqualRegardlessOfRequestMethod() {
        try {
            List<FolderObject> rootFolders = FolderTest.getRootFolders(this.getWebConversation(), this.getHostName(), this.getSessionId(), true);
            for (FolderObject rootFolder : rootFolders) {
                FolderObject individuallyLoaded = FolderTest.getFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), "" + rootFolder.getObjectID(), Calendar.getInstance(), true);
                FolderTest.assertEquals((String)("Foldernames differ : " + rootFolder.getFolderName() + " != " + individuallyLoaded.getFolderName()), (String)rootFolder.getFolderName(), (String)individuallyLoaded.getFolderName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FolderTest.fail((String)e.getMessage());
        }
    }

    public void testLastModifiedUTCInGet() throws JSONException, OXException, IOException, SAXException {
        AJAXClient client = new AJAXClient(new AJAXSession(this.getWebConversation(), this.getHostName(), this.getSessionId()));
        GetRequest getRequest = new GetRequest((API)EnumAPI.OX_OLD, 2, new int[]{6});
        GetResponse response = Executor.execute(client, getRequest);
        FolderTest.assertTrue((boolean)((JSONObject)response.getData()).has("last_modified_utc"));
    }

    public void testLastModifiedUTCInList() throws JSONException, IOException, SAXException, OXException {
        AJAXClient client = new AJAXClient(new AJAXSession(this.getWebConversation(), this.getHostName(), this.getSessionId()));
        ListRequest listRequest = new ListRequest((API)EnumAPI.OX_OLD, "10", new int[]{6}, false);
        ListResponse listResponse = client.execute(listRequest);
        JSONArray arr = (JSONArray)listResponse.getData();
        int size = arr.length();
        FolderTest.assertTrue((size > 0 ? 1 : 0) != 0);
        for (int i = 0; i < size; ++i) {
            JSONArray row = arr.optJSONArray(i);
            FolderTest.assertNotNull((Object)row);
            FolderTest.assertTrue((row.length() == 1 ? 1 : 0) != 0);
            FolderTest.assertNotNull((Object)row.get(0));
        }
    }

    public void testLastModifiedUTCInUpdates() throws JSONException, OXException, IOException, SAXException {
        AJAXClient client = new AJAXClient(new AJAXSession(this.getWebConversation(), this.getHostName(), this.getSessionId()));
        UpdatesRequest updatesRequest = new UpdatesRequest(EnumAPI.OX_OLD, 10, new int[]{6}, -1, null, new Date(0L));
        FolderUpdatesResponse response = Executor.execute(client, updatesRequest);
        JSONArray arr = (JSONArray)response.getData();
        int size = arr.length();
        FolderTest.assertTrue((size > 0 ? 1 : 0) != 0);
        for (int i = 0; i < size; ++i) {
            JSONArray row = arr.optJSONArray(i);
            FolderTest.assertNotNull((Object)row);
            FolderTest.assertTrue((row.length() == 1 ? 1 : 0) != 0);
            FolderTest.assertNotNull((Object)row.get(0));
        }
    }
}

