/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.user.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.api2.ContactInterfaceFactory;
import com.openexchange.contact.ContactService;
import com.openexchange.contacts.json.mapping.ContactMapper;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.ContactInterface;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.ldap.User;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.user.UserService;
import com.openexchange.user.json.UserContact;
import com.openexchange.user.json.actions.AbstractUserAction;
import com.openexchange.user.json.services.ServiceRegistry;
import com.openexchange.user.json.writer.UserWriter;
import org.json.JSONObject;

@Action(method=RequestMethod.GET, name="get", description="Get a user.", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="id", optional=true, description="Object ID of the requested user. Since v6.18.1, this parameter is optional: the default is the currently logged in user.")}, responseDescription="Response with timestamp: An object containing all data of the requested user. The fields of the object are listed in Common object data, Detailed contact data and Detailed user data.")
public final class GetAction
extends AbstractUserAction {
    public static final String ACTION = "get";

    public AJAXRequestResult perform(AJAXRequestData request, ServerSession session) throws OXException {
        int[] columns = GetAction.parseOptionalIntArrayParameter("columns", request);
        ContactField[] contactFields = null == columns || 0 == columns.length ? ContactMapper.getInstance().getAllFields() : (ContactField[])ContactMapper.getInstance().getFields(columns);
        String idParam = request.getParameter("id");
        int userId = null == idParam ? session.getUserId() : GetAction.checkIntParameter("id", request);
        UserService userService = (UserService)ServiceRegistry.getInstance().getService(UserService.class, true);
        User user = userService.getUser(userId, session.getContext());
        ContactService contactService = (ContactService)ServiceRegistry.getInstance().getService(ContactService.class, true);
        Contact contact = contactService.getUser((Session)session, userId, contactFields);
        return new AJAXRequestResult((Object)new UserContact(contact, user), contact.getLastModified(), "usercontact");
    }

    public AJAXRequestResult performOLD(AJAXRequestData request, ServerSession session) throws OXException {
        String idParam = request.getParameter("id");
        int userId = null == idParam ? session.getUserId() : GetAction.checkIntParameter("id", request);
        UserService userService = (UserService)ServiceRegistry.getInstance().getService(UserService.class, true);
        User user = userService.getUser(userId, session.getContext());
        ContactInterface contactInterface = ((ContactInterfaceFactory)ServiceRegistry.getInstance().getService(ContactInterfaceFactory.class, true)).create(6, (Session)session);
        Contact userContact = contactInterface.getUserById(userId, false);
        String timeZoneId = request.getParameter("timezone");
        GetAction.censor(session, userContact);
        JSONObject jsonObject = UserWriter.writeSingle2Object(null, null, GetAction.censor(session, user), userContact, timeZoneId);
        return new AJAXRequestResult((Object)jsonObject, userContact.getLastModified());
    }
}

