/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe.database;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.database.provider.DBTransactionPolicy;
import com.openexchange.database.provider.SimpleDBProvider;
import com.openexchange.datatypes.genericonf.storage.GenericConfigurationStorageService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.delete.DeleteEvent;
import com.openexchange.groupware.delete.DeleteListener;
import com.openexchange.subscribe.SubscriptionSourceDiscoveryService;
import com.openexchange.subscribe.SubscriptionStorage;
import com.openexchange.subscribe.sql.SubscriptionSQLStorage;
import java.sql.Connection;

public class SubscriptionUserDeleteListener
implements DeleteListener {
    private GenericConfigurationStorageService storageService;
    private SubscriptionSourceDiscoveryService discoveryService;

    public void deletePerformed(DeleteEvent event, Connection readCon, Connection writeCon) throws OXException {
        if (event.getType() != 1) {
            return;
        }
        try {
            this.getStorage(writeCon).deleteAllSubscriptionsForUser(event.getId(), event.getContext());
        }
        catch (OXException e) {
            throw new OXException(e);
        }
    }

    protected SubscriptionStorage getStorage(Connection writeCon) {
        return new SubscriptionSQLStorage((DBProvider)new SimpleDBProvider(writeCon, writeCon), DBTransactionPolicy.NO_TRANSACTIONS, this.storageService, this.discoveryService);
    }

    public void setStorageService(GenericConfigurationStorageService storageService) {
        this.storageService = storageService;
    }

    public void setDiscoveryService(SubscriptionSourceDiscoveryService discoveryService) {
        this.discoveryService = discoveryService;
    }
}

