/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.smtp.config;

import com.openexchange.exception.OXException;
import com.openexchange.mail.api.MailCapabilities;
import com.openexchange.mail.transport.config.ITransportProperties;
import com.openexchange.mail.transport.config.TransportConfig;
import com.openexchange.smtp.SMTPExceptionCode;
import com.openexchange.smtp.config.ISMTPProperties;
import com.openexchange.tools.net.URIDefaults;
import com.openexchange.tools.net.URIParser;
import java.net.URI;
import java.net.URISyntaxException;
import javax.mail.internet.IDNA;

public final class SMTPConfig
extends TransportConfig {
    private static final String PROTOCOL_SMTP_SECURE = "smtps";
    private boolean secure;
    private int smtpPort;
    private String smtpServer;
    private ISMTPProperties transportProperties;

    public MailCapabilities getCapabilities() {
        return MailCapabilities.EMPTY_CAPS;
    }

    public int getPort() {
        return this.smtpPort;
    }

    public String getServer() {
        return this.smtpServer;
    }

    public boolean isSecure() {
        return this.secure;
    }

    protected void parseServerURL(String serverURL) throws OXException {
        URI uri;
        try {
            uri = URIParser.parse((String)serverURL, (URIDefaults)URIDefaults.SMTP);
        }
        catch (URISyntaxException e) {
            throw SMTPExceptionCode.URI_PARSE_FAILED.create(e, serverURL);
        }
        this.secure = PROTOCOL_SMTP_SECURE.equals(uri.getScheme());
        this.smtpServer = uri.getHost();
        this.smtpPort = uri.getPort();
    }

    public void setPort(int smtpPort) {
        this.smtpPort = smtpPort;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setServer(String smtpServer) {
        this.smtpServer = null == smtpServer ? null : IDNA.toUnicode((String)smtpServer);
    }

    public ITransportProperties getTransportProperties() {
        return this.transportProperties;
    }

    public ISMTPProperties getSMTPProperties() {
        return this.transportProperties;
    }

    public void setTransportProperties(ITransportProperties transportProperties) {
        this.transportProperties = (ISMTPProperties)transportProperties;
    }
}

