/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Date;

public class LastModifiedCache {
    private final TIntObjectMap<LastModifiedMemory> storage = new TIntObjectHashMap();

    public long getLastModified(int objectId, long lastModified) {
        LastModifiedMemory memory;
        if (this.storage.containsKey(objectId) && lastModified >= (memory = (LastModifiedMemory)this.storage.get(objectId)).getOriginal()) {
            return memory.getCurrent();
        }
        return lastModified;
    }

    public Date getLastModified(int objectId, Date lastModified) {
        if (lastModified == null) {
            return null;
        }
        return new Date(this.getLastModified(objectId, lastModified.getTime()));
    }

    public void update(int objectId, int recurrenceId, Date lastModified) {
        if (lastModified == null) {
            return;
        }
        if (recurrenceId != 0) {
            if (this.storage.containsKey(recurrenceId)) {
                ((LastModifiedMemory)this.storage.get(recurrenceId)).setCurrent(lastModified.getTime());
            } else {
                this.storage.put(recurrenceId, (Object)new LastModifiedMemory(lastModified.getTime(), lastModified.getTime()));
            }
        }
        if (objectId != 0) {
            if (this.storage.containsKey(objectId)) {
                ((LastModifiedMemory)this.storage.get(objectId)).setCurrent(lastModified.getTime());
            } else {
                this.storage.put(objectId, (Object)new LastModifiedMemory(lastModified.getTime(), lastModified.getTime()));
            }
        }
    }

    private static class LastModifiedMemory {
        private long original;
        private long current;

        public LastModifiedMemory(long original, long current) {
            this.original = original;
            this.current = current;
        }

        public long getOriginal() {
            return this.original;
        }

        public void setOriginal(long original) {
            this.original = original;
        }

        public long getCurrent() {
            return this.current;
        }

        public void setCurrent(long current) {
            this.current = current;
        }
    }
}

