/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.versit;

import com.openexchange.tools.versit.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

public class Property {
    public final String name;
    private final ArrayList<Parameter> Parameters = new ArrayList();
    private final HashMap<String, Parameter> Index = new HashMap();
    private Object value = null;
    private boolean invalid;

    public Property(String name) {
        this.name = name;
        this.invalid = false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append(this.getName());
        Object val = this.getValue();
        if (null != val) {
            sb.append(": ");
            sb.append(val);
        }
        return sb.toString();
    }

    public Parameter getParameter(String name) {
        return this.Index.get(name.toUpperCase(Locale.ENGLISH));
    }

    public Parameter getParameter(int index) {
        return this.Parameters.get(index);
    }

    public int getParameterCount() {
        return this.Parameters.size();
    }

    public void addParameter(Parameter parameter) {
        String Name2 = parameter.name.toUpperCase(Locale.ENGLISH);
        Parameter existingParam = this.Index.get(Name2);
        if (existingParam != null) {
            int count = parameter.getValueCount();
            for (int i = 0; i < count; ++i) {
                existingParam.addValue(parameter.getValue(i));
            }
        } else {
            this.Parameters.add(parameter);
            this.Index.put(parameter.name.toUpperCase(Locale.ENGLISH), parameter);
        }
    }

    public Object getValue() {
        return this.value;
    }

    public Property setValue(Object value) {
        this.value = value;
        return this;
    }

    public void markInvalid() {
        this.invalid = true;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public String getName() {
        return this.name;
    }
}

