/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.servlet;

import com.openexchange.config.ConfigTools;
import com.openexchange.config.ConfigurationService;
import com.openexchange.dispatcher.Parameterizable;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.servlet.DelegateServletInputStream;
import com.openexchange.tools.stream.CountingInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public final class CountingHttpServletRequest
implements HttpServletRequest,
Parameterizable {
    private final HttpServletRequest servletRequest;
    private final long max;
    private final Parameterizable parameterizable;
    private volatile ServletInputStream servletInputStream;

    public CountingHttpServletRequest(HttpServletRequest servletRequest) {
        this(servletRequest, ConfigTools.getLongProperty((String)"com.openexchange.servlet.maxBodySize", (long)0x6400000L, (ConfigurationService)ServerServiceRegistry.getInstance().getService(ConfigurationService.class)));
    }

    public CountingHttpServletRequest(HttpServletRequest servletRequest, long max) {
        this.max = max;
        this.servletRequest = servletRequest;
        this.parameterizable = servletRequest instanceof Parameterizable ? (Parameterizable)servletRequest : null;
    }

    public void putParameter(String name, String value) {
        if (null != this.parameterizable) {
            this.parameterizable.putParameter(name, value);
        }
    }

    public Object getAttribute(String name) {
        return this.servletRequest.getAttribute(name);
    }

    public String getAuthType() {
        return this.servletRequest.getAuthType();
    }

    public Cookie[] getCookies() {
        return this.servletRequest.getCookies();
    }

    public Enumeration<?> getAttributeNames() {
        return this.servletRequest.getAttributeNames();
    }

    public long getDateHeader(String name) {
        return this.servletRequest.getDateHeader(name);
    }

    public String getCharacterEncoding() {
        return this.servletRequest.getCharacterEncoding();
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        this.servletRequest.setCharacterEncoding(env);
    }

    public String getHeader(String name) {
        return this.servletRequest.getHeader(name);
    }

    public int getContentLength() {
        return this.servletRequest.getContentLength();
    }

    public String getContentType() {
        return this.servletRequest.getContentType();
    }

    public Enumeration<?> getHeaders(String name) {
        return this.servletRequest.getHeaders(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServletInputStream getInputStream() throws IOException {
        if (this.max <= 0L) {
            return this.servletRequest.getInputStream();
        }
        ServletInputStream tmp = this.servletInputStream;
        if (null == tmp) {
            HttpServletRequest httpServletRequest = this.servletRequest;
            synchronized (httpServletRequest) {
                tmp = this.servletInputStream;
                if (null == tmp) {
                    this.servletInputStream = tmp = new DelegateServletInputStream((InputStream)new CountingInputStream((InputStream)this.servletRequest.getInputStream(), this.max));
                }
            }
        }
        return tmp;
    }

    public String getParameter(String name) {
        return this.servletRequest.getParameter(name);
    }

    public Enumeration<?> getHeaderNames() {
        return this.servletRequest.getHeaderNames();
    }

    public int getIntHeader(String name) {
        return this.servletRequest.getIntHeader(name);
    }

    public Enumeration<?> getParameterNames() {
        return this.servletRequest.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        return this.servletRequest.getParameterValues(name);
    }

    public String getMethod() {
        return this.servletRequest.getMethod();
    }

    public String getPathInfo() {
        return this.servletRequest.getPathInfo();
    }

    public Map<?, ?> getParameterMap() {
        return this.servletRequest.getParameterMap();
    }

    public String getProtocol() {
        return this.servletRequest.getProtocol();
    }

    public String getPathTranslated() {
        return this.servletRequest.getPathTranslated();
    }

    public String getScheme() {
        return this.servletRequest.getScheme();
    }

    public String getServerName() {
        return this.servletRequest.getServerName();
    }

    public String getContextPath() {
        return this.servletRequest.getContextPath();
    }

    public int getServerPort() {
        return this.servletRequest.getServerPort();
    }

    public String getQueryString() {
        return this.servletRequest.getQueryString();
    }

    public BufferedReader getReader() throws IOException {
        return this.servletRequest.getReader();
    }

    public String getRemoteUser() {
        return this.servletRequest.getRemoteUser();
    }

    public String getRemoteAddr() {
        return this.servletRequest.getRemoteAddr();
    }

    public boolean isUserInRole(String role) {
        return this.servletRequest.isUserInRole(role);
    }

    public String getRemoteHost() {
        return this.servletRequest.getRemoteHost();
    }

    public Principal getUserPrincipal() {
        return this.servletRequest.getUserPrincipal();
    }

    public void setAttribute(String name, Object o) {
        this.servletRequest.setAttribute(name, o);
    }

    public String getRequestedSessionId() {
        return this.servletRequest.getRequestedSessionId();
    }

    public String getRequestURI() {
        return this.servletRequest.getRequestURI();
    }

    public void removeAttribute(String name) {
        this.servletRequest.removeAttribute(name);
    }

    public Locale getLocale() {
        return this.servletRequest.getLocale();
    }

    public StringBuffer getRequestURL() {
        return this.servletRequest.getRequestURL();
    }

    public Enumeration<?> getLocales() {
        return this.servletRequest.getLocales();
    }

    public String getServletPath() {
        return this.servletRequest.getServletPath();
    }

    public boolean isSecure() {
        return this.servletRequest.isSecure();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.servletRequest.getRequestDispatcher(path);
    }

    public HttpSession getSession(boolean create) {
        return this.servletRequest.getSession(create);
    }

    public String getRealPath(String path) {
        return this.servletRequest.getRealPath(path);
    }

    public HttpSession getSession() {
        return this.servletRequest.getSession();
    }

    public int getRemotePort() {
        return this.servletRequest.getRemotePort();
    }

    public boolean isRequestedSessionIdValid() {
        return this.servletRequest.isRequestedSessionIdValid();
    }

    public String getLocalName() {
        return this.servletRequest.getLocalName();
    }

    public String getLocalAddr() {
        return this.servletRequest.getLocalAddr();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.servletRequest.isRequestedSessionIdFromCookie();
    }

    public int getLocalPort() {
        return this.servletRequest.getLocalPort();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.servletRequest.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.servletRequest.isRequestedSessionIdFromUrl();
    }
}

