/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.regex;

import com.openexchange.tools.regex.RegexUtility;
import java.util.regex.Pattern;

public final class RFC2616Regex {
    private static final String tokenCharRegex = "[[\\p{L}\\p{ASCII}]&&[^\\p{Cntrl}()<>@,;:\\\"/\\[\\]?={}\\p{Blank}]]";
    public static final Pattern TOKEN = Pattern.compile("[[\\p{L}\\p{ASCII}]&&[^\\p{Cntrl}()<>@,;:\\\"/\\[\\]?={}\\p{Blank}]]+");
    private static final String qdtextRegex = "[\\p{L}\\p{ASCII}\\p{Blank}&&[^\\p{Cntrl}\"]]*";
    public static final Pattern QDTEXT = Pattern.compile("[\\p{L}\\p{ASCII}\\p{Blank}&&[^\\p{Cntrl}\"]]*");
    private static final String quotedPairRegex = "(?:\\\\[\\p{L}\\p{ASCII}])*";
    public static final Pattern QUOTED_PAIR = Pattern.compile("(?:\\\\[\\p{L}\\p{ASCII}])*");
    private static final String quotedStringRegex = "(?:\"(?:[\\p{L}\\p{ASCII}\\p{Blank}&&[^\\p{Cntrl}\"]]|(?:\\\\[\\p{L}\\p{ASCII}]))*\")";
    public static final Pattern QUOTED_STRING = Pattern.compile("(?:\"(?:[\\p{L}\\p{ASCII}\\p{Blank}&&[^\\p{Cntrl}\"]]|(?:\\\\[\\p{L}\\p{ASCII}]))*\")");
    private static final String valueRegex = RegexUtility.OR(RegexUtility.group(RegexUtility.zeroOrMoreTimes("[[\\p{L}\\p{ASCII}]&&[^\\p{Cntrl}()<>@,;:\\\"/\\[\\]?={}\\p{Blank}]]"), false), RegexUtility.group("(?:\"(?:[\\p{L}\\p{ASCII}\\p{Blank}&&[^\\p{Cntrl}\"]]|(?:\\\\[\\p{L}\\p{ASCII}]))*\")", false));
    public static final Pattern VALUE = Pattern.compile(valueRegex);
    private static final String pathRegex = RegexUtility.concat(";\\p{Blank}*\\$Path=", RegexUtility.group(RegexUtility.OR(RegexUtility.group(valueRegex, RegexUtility.GroupType.NON_CAPTURING), RegexUtility.group("/", RegexUtility.GroupType.NON_CAPTURING)), RegexUtility.GroupType.CAPTURING));
    private static final String domainRegex = RegexUtility.concat(";\\p{Blank}*\\$Domain=", RegexUtility.group(valueRegex, true));
    private static final String portRegex = RegexUtility.concat(";\\p{Blank}*\\$Port(=\"", RegexUtility.group(valueRegex, false), "\")?");
    private static final String cookieValueRegex = RegexUtility.concat(RegexUtility.group(RegexUtility.oneOrMoreTimes("[[\\p{L}\\p{ASCII}]&&[^\\p{Cntrl}()<>@,;:\\\"/\\[\\]?={}\\p{Blank}]]"), true), "=", RegexUtility.group(valueRegex, true), RegexUtility.optional(pathRegex, RegexUtility.GroupType.NON_CAPTURING), RegexUtility.optional(domainRegex, RegexUtility.GroupType.NON_CAPTURING), RegexUtility.optional(portRegex, RegexUtility.GroupType.NON_CAPTURING));
    public static final Pattern COOKIE_VALUE = Pattern.compile(cookieValueRegex);
    private static final String cookieVersionRegex = RegexUtility.concat("\\$Version=", RegexUtility.group(valueRegex, true));
    public static final Pattern COOKIE_VERSION = Pattern.compile(cookieVersionRegex);
    private static final String cookieVersionWithSeperatorRegex = RegexUtility.group(RegexUtility.concat(cookieVersionRegex, "(?:;|,)\\p{Space}*"), false);
    private static final String oneCookieRegex = RegexUtility.group(RegexUtility.concat("(?:^|(?:[;,]\\p{Space}*))", RegexUtility.optional(cookieVersionWithSeperatorRegex), cookieValueRegex), true);
    public static final Pattern COOKIE = Pattern.compile(oneCookieRegex);
    public static final Pattern COOKIE_PARAM_PATH = Pattern.compile(pathRegex);
    public static final Pattern COOKIE_PARAM_DOMAIN = Pattern.compile(domainRegex);
    private static final String cookiesRegex = RegexUtility.concat(oneCookieRegex, RegexUtility.zeroOrMoreTimes(RegexUtility.group(RegexUtility.concat("(?:;|,)\\p{Blank}*", oneCookieRegex), false)));
    public static final Pattern COOKIES = Pattern.compile(cookiesRegex);

    private RFC2616Regex() {
    }
}

