/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder;

import com.openexchange.cache.impl.FolderCacheManager;
import com.openexchange.cache.impl.FolderQueryCacheManager;
import com.openexchange.cache.registry.CacheAvailabilityListener;
import com.openexchange.cache.registry.CacheAvailabilityRegistry;
import com.openexchange.config.ConfigurationService;
import com.openexchange.database.DatabaseService;
import com.openexchange.database.internal.Initialization;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.cache.CacheFolderStorage;
import com.openexchange.folderstorage.cache.memory.FolderMapManagement;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.log.LogFactory;
import com.openexchange.management.ManagementService;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.oxfolder.GABRestorerMBeanImpl;
import com.openexchange.tools.oxfolder.memory.ConditionTreeMapManagement;
import com.openexchange.tools.oxfolder.permissionLoader.PermissionLoaderService;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;

public final class OXFolderProperties
implements com.openexchange.server.Initialization,
CacheAvailabilityListener {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(OXFolderProperties.class));
    private static OXFolderProperties instance = new OXFolderProperties();
    private final AtomicBoolean started = new AtomicBoolean();
    private boolean enableDBGrouping = true;
    private boolean enableFolderCache = true;
    private boolean ignoreSharedAddressbook = false;
    volatile boolean enableInternalUsersEdit = true;
    private boolean enableSharedFolderCaching = true;
    private static final String WARN_FOLDER_PROPERTIES_INIT = "Folder properties have not been started.";

    public static OXFolderProperties getInstance() {
        return instance;
    }

    private OXFolderProperties() {
    }

    public void start() throws OXException {
        if (!this.started.compareAndSet(false, true)) {
            LOG.error((Object)"Folder properties have already been started", new Throwable());
            return;
        }
        this.init();
        PermissionLoaderService.getInstance().startUp();
        CacheAvailabilityRegistry reg = CacheAvailabilityRegistry.getInstance();
        if (reg != null) {
            reg.registerListener(this);
        }
        if (this.enableFolderCache) {
            FolderCacheManager.initInstance();
        }
        FolderQueryCacheManager.initInstance();
        ConditionTreeMapManagement.startInstance();
    }

    public void stop() throws OXException {
        if (!this.started.compareAndSet(true, false)) {
            LOG.error((Object)"Folder properties cannot be stopped since they have not been started before", new Throwable());
            return;
        }
        CacheAvailabilityRegistry reg = CacheAvailabilityRegistry.getInstance();
        if (reg != null) {
            reg.unregisterListener(this);
        }
        ConditionTreeMapManagement.stopInstance();
        FolderCacheManager.releaseInstance();
        FolderQueryCacheManager.releaseInstance();
        PermissionLoaderService.dropInstance();
        this.reset();
    }

    @Override
    public void handleAvailability() throws OXException {
        FolderQueryCacheManager fqcm;
        FolderCacheManager fcm = FolderCacheManager.getInstance();
        if (null != fcm) {
            fcm.initCache();
        }
        if (null != (fqcm = FolderQueryCacheManager.getInstance())) {
            fqcm.initCache();
        }
    }

    @Override
    public void handleAbsence() throws OXException {
        FolderQueryCacheManager fqcm;
        FolderCacheManager fcm = FolderCacheManager.getInstance();
        if (null != fcm) {
            fcm.releaseCache();
        }
        if (null != (fqcm = FolderQueryCacheManager.getInstance())) {
            fqcm.releaseCache();
        }
    }

    private void reset() {
        this.enableSharedFolderCaching = true;
        this.enableDBGrouping = true;
        this.enableFolderCache = true;
        this.ignoreSharedAddressbook = false;
        this.enableInternalUsersEdit = false;
    }

    private void init() {
        ConfigurationService configurationService = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
        if (configurationService == null) {
            LOG.error((Object)"Cannot look-up configuration service");
            return;
        }
        String value = configurationService.getProperty("ENABLE_SHARED_FOLDER_CACHING");
        if (null != value) {
            this.enableSharedFolderCaching = Boolean.parseBoolean(value.trim());
        }
        if (null == (value = configurationService.getProperty("ENABLE_DB_GROUPING"))) {
            LOG.warn((Object)"Missing property ENABLE_DB_GROUPING.");
        } else {
            this.enableDBGrouping = Boolean.parseBoolean(value.trim());
        }
        value = configurationService.getProperty("ENABLE_FOLDER_CACHE");
        if (null == value) {
            LOG.warn((Object)"Missing property ENABLE_FOLDER_CACHE");
        } else {
            this.enableFolderCache = Boolean.parseBoolean(value.trim());
        }
        value = configurationService.getProperty("IGNORE_SHARED_ADDRESSBOOK");
        if (null == value) {
            LOG.warn((Object)"Missing property IGNORE_SHARED_ADDRESSBOOK");
        } else {
            this.ignoreSharedAddressbook = Boolean.parseBoolean(value.trim());
        }
        value = configurationService.getProperty("ENABLE_INTERNAL_USER_EDIT");
        if (null == value) {
            LOG.warn((Object)"Missing property ENABLE_INTERNAL_USER_EDIT");
        } else {
            boolean enableInternalUsersEdit = Boolean.parseBoolean(value.trim());
            OXFolderProperties.updatePermissions(enableInternalUsersEdit);
            this.enableInternalUsersEdit = enableInternalUsersEdit;
        }
        this.logInfo();
    }

    private void logInfo() {
        if (LOG.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder(512);
            sb.append("\nFolder Properties & Folder Cache Properties:\n");
            sb.append("\tENABLE_SHARED_FOLDER_CACHING=").append(this.enableSharedFolderCaching).append('\n');
            sb.append("\tENABLE_DB_GROUPING=").append(this.enableDBGrouping).append('\n');
            sb.append("\tENABLE_FOLDER_CACHE=").append(this.enableFolderCache).append('\n');
            sb.append("\tENABLE_INTERNAL_USER_EDIT=").append(this.enableInternalUsersEdit).append('\n');
            sb.append("\tIGNORE_SHARED_ADDRESSBOOK=").append(this.ignoreSharedAddressbook);
            LOG.info((Object)sb.toString());
        }
    }

    public static boolean isEnableDBGrouping() {
        if (!OXFolderProperties.instance.started.get()) {
            LOG.error((Object)WARN_FOLDER_PROPERTIES_INIT, new Throwable());
        }
        return OXFolderProperties.instance.enableDBGrouping;
    }

    public static boolean isEnableFolderCache() {
        if (!OXFolderProperties.instance.started.get()) {
            LOG.error((Object)WARN_FOLDER_PROPERTIES_INIT, new Throwable());
        }
        return OXFolderProperties.instance.enableFolderCache;
    }

    public static boolean isIgnoreSharedAddressbook() {
        if (!OXFolderProperties.instance.started.get()) {
            LOG.error((Object)WARN_FOLDER_PROPERTIES_INIT, new Throwable());
        }
        return OXFolderProperties.instance.ignoreSharedAddressbook;
    }

    public static boolean isEnableInternalUsersEdit() {
        if (!OXFolderProperties.instance.started.get()) {
            LOG.error((Object)WARN_FOLDER_PROPERTIES_INIT, new Throwable());
        }
        return OXFolderProperties.instance.enableInternalUsersEdit;
    }

    public static boolean isEnableSharedFolderCaching() {
        if (!OXFolderProperties.instance.started.get()) {
            LOG.error((Object)WARN_FOLDER_PROPERTIES_INIT, new Throwable());
        }
        return OXFolderProperties.instance.enableSharedFolderCaching;
    }

    public static ObjectName registerRestorerMBean(ManagementService managementService) {
        try {
            ObjectName objectName = OXFolderProperties.getObjectName(GABRestorerMBeanImpl.class.getName(), "com.openexchange.globaladdressbook");
            managementService.registerMBean(objectName, (Object)new GABRestorerMBeanImpl());
            return objectName;
        }
        catch (MalformedObjectNameException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static void unregisterRestorerMBean(ObjectName objectName, ManagementService managementService) {
        if (objectName != null) {
            try {
                managementService.unregisterMBean(objectName);
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static ObjectName getObjectName(String className, String domain) throws MalformedObjectNameException {
        int pos = className.lastIndexOf(46);
        return new ObjectName(domain, "name", pos == -1 ? className : className.substring(pos + 1));
    }

    public static void updatePermissions(boolean enableInternalUsersEdit) {
        Map<String, Set<Integer>> map = OXFolderProperties.getSchemasAndContexts();
        if (!map.isEmpty()) {
            int size = map.size();
            Iterator<Set<Integer>> iter = map.values().iterator();
            for (int i = 0; i < size; ++i) {
                Set<Integer> cids = iter.next();
                if (cids.isEmpty()) continue;
                OXFolderProperties.updateGABWritePermission(enableInternalUsersEdit, cids.iterator().next());
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)MessageFormat.format("Property ''ENABLE_INTERNAL_USER_EDIT'' change propagated. ENABLE_INTERNAL_USER_EDIT={0}", enableInternalUsersEdit));
        }
        if (FolderCacheManager.isInitialized()) {
            try {
                FolderCacheManager.getInstance().clearAll();
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        CacheFolderStorage.getInstance().clearAll();
        FolderMapManagement.getInstance().clear();
    }

    public static void updatePermissions(boolean enableInternalUsersEdit, int contextId) {
        OXFolderProperties.updateGABWritePermission(enableInternalUsersEdit, contextId);
        if (FolderCacheManager.isInitialized()) {
            try {
                FolderCacheManager.getInstance().removeFolderObject(6, ContextStorage.getStorageContext(contextId));
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        CacheFolderStorage.getInstance().clearCache(-1, contextId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateGABWritePermission(boolean enableInternalUsersEdit, int contextId) {
        Connection con = null;
        try {
            con = Database.get(contextId, true);
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        if (null != con) {
            PreparedStatement ps = null;
            try {
                ps = con.prepareStatement("UPDATE oxfolder_permissions SET owp = ? WHERE fuid = ?");
                ps.setInt(1, enableInternalUsersEdit ? 2 : 0);
                ps.setInt(2, 6);
                ps.executeUpdate();
            }
            catch (SQLException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                DBUtils.closeSQLStuff(ps);
                Database.back(contextId, true, con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Set<Integer>> getSchemasAndContexts() {
        block12: {
            HashMap<String, Set<Integer>> hashMap;
            Initialization dbInitialization = Initialization.getInstance();
            DatabaseService databaseService = dbInitialization.getDatabaseService();
            if (null == databaseService) {
                databaseService = dbInitialization.startIfAbsent(ServerServiceRegistry.getInstance().getService(ConfigurationService.class));
            }
            if (null == databaseService) {
                return Collections.emptyMap();
            }
            Connection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                con = databaseService.getReadOnly();
                stmt = con.prepareStatement("SELECT db_schema, cid FROM context_server2db_pool");
                rs = stmt.executeQuery();
                HashMap<String, Set<Integer>> schemasAndContexts = new HashMap<String, Set<Integer>>();
                while (rs.next()) {
                    String schemaName = rs.getString(1);
                    int contextId = rs.getInt(2);
                    HashSet<Integer> contextIds = (HashSet<Integer>)schemasAndContexts.get(schemaName);
                    if (null == contextIds) {
                        contextIds = new HashSet<Integer>();
                        schemasAndContexts.put(schemaName, contextIds);
                    }
                    contextIds.add(contextId);
                }
                hashMap = schemasAndContexts;
            }
            catch (Throwable throwable) {
                try {
                    DBUtils.closeSQLStuff(rs, stmt);
                    if (con != null) {
                        databaseService.backReadOnly(con);
                    }
                    throw throwable;
                }
                catch (OXException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                    break block12;
                }
                catch (SQLException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            DBUtils.closeSQLStuff(rs, stmt);
            if (con != null) {
                databaseService.backReadOnly(con);
            }
            return hashMap;
        }
        return Collections.emptyMap();
    }
}

