/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder;

import com.openexchange.api2.AppointmentSQLInterface;
import com.openexchange.cache.impl.FolderCacheManager;
import com.openexchange.cache.impl.FolderQueryCacheManager;
import com.openexchange.config.ConfigurationService;
import com.openexchange.contact.ContactService;
import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.database.provider.StaticDBPoolProvider;
import com.openexchange.event.impl.EventClient;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionConstants;
import com.openexchange.folder.FolderDeleteListenerService;
import com.openexchange.folder.internal.FolderDeleteListenerRegistry;
import com.openexchange.groupware.calendar.AppointmentSqlFactoryService;
import com.openexchange.groupware.calendar.CalendarCache;
import com.openexchange.groupware.contact.Contacts;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.facade.impl.InfostoreFacadeImpl;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.links.Links;
import com.openexchange.groupware.tasks.Tasks;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.java.Charsets;
import com.openexchange.log.LogFactory;
import com.openexchange.preferences.ServerUserSetting;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.StringCollection;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.OXFolderManager;
import com.openexchange.tools.oxfolder.OXFolderSQL;
import com.openexchange.tools.oxfolder.OXFolderUtility;
import com.openexchange.tools.oxfolder.memory.ConditionTreeMapManagement;
import com.openexchange.tools.oxfolder.treeconsistency.CheckPermissionOnInsert;
import com.openexchange.tools.oxfolder.treeconsistency.CheckPermissionOnRemove;
import com.openexchange.tools.session.ServerSessionAdapter;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntObjectProcedure;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;

final class OXFolderManagerImpl
extends OXFolderManager
implements OXExceptionConstants {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(OXFolderManagerImpl.class));
    static final int OPTION_NONE = 0;
    static final int OPTION_DENY_MODULE_UPDATE = 1;
    private static final String TABLE_OXFOLDER_TREE = "oxfolder_tree";
    private final Connection readCon;
    private final Connection writeCon;
    private final Context ctx;
    private final UserConfiguration userConfig;
    private final User user;
    private final Session session;
    private OXFolderAccess oxfolderAccess;
    private AppointmentSQLInterface cSql;
    private final int[] SYSTEM_PUBLIC_FOLDERS = new int[]{2, 15};
    private static final int SPECIAL_CONTACT_COLLECT_FOLDER = 0;
    private static Map<String, Integer> fieldMapping;

    public AppointmentSQLInterface getCSql() {
        return this.cSql;
    }

    public void setCSql(AppointmentSQLInterface sql) {
        this.cSql = sql;
    }

    OXFolderManagerImpl(Session session) throws OXException {
        this(session, null, null);
    }

    OXFolderManagerImpl(Session session, OXFolderAccess oxfolderAccess) throws OXException {
        this(session, oxfolderAccess, null, null);
    }

    OXFolderManagerImpl(Session session, Connection readCon, Connection writeCon) throws OXException {
        this(session, null, readCon, writeCon);
    }

    OXFolderManagerImpl(Session session, OXFolderAccess oxfolderAccess, Connection readCon, Connection writeCon) throws OXException {
        this.session = session;
        this.ctx = ContextStorage.getStorageContext(session.getContextId());
        this.userConfig = UserConfigurationStorage.getInstance().getUserConfigurationSafe(session.getUserId(), this.ctx);
        this.user = UserStorage.getStorageUser(session.getUserId(), this.ctx);
        this.readCon = readCon;
        this.writeCon = writeCon;
        this.oxfolderAccess = oxfolderAccess;
        AppointmentSqlFactoryService factory = ServerServiceRegistry.getInstance().getService(AppointmentSqlFactoryService.class);
        this.cSql = factory != null ? factory.createAppointmentSql(session) : null;
    }

    private OXFolderAccess getOXFolderAccess() {
        if (this.oxfolderAccess != null) {
            return this.oxfolderAccess;
        }
        this.oxfolderAccess = new OXFolderAccess(this.writeCon, this.ctx);
        return this.oxfolderAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FolderObject createFolder(FolderObject folderObj, boolean checkPermissions, long createTime) throws OXException {
        Set<Integer> diff;
        if (!folderObj.containsFolderName() || folderObj.getFolderName() == null || folderObj.getFolderName().length() == 0) {
            throw OXFolderExceptionCode.MISSING_FOLDER_ATTRIBUTE.create("title", "", this.ctx.getContextId());
        }
        if (!folderObj.containsParentFolderID()) {
            throw OXFolderExceptionCode.MISSING_FOLDER_ATTRIBUTE.create("folder_id", "", this.ctx.getContextId());
        }
        if (!folderObj.containsModule()) {
            throw OXFolderExceptionCode.MISSING_FOLDER_ATTRIBUTE.create("module", "", this.ctx.getContextId());
        }
        if (!folderObj.containsType()) {
            throw OXFolderExceptionCode.MISSING_FOLDER_ATTRIBUTE.create("type", "", this.ctx.getContextId());
        }
        if (9 == folderObj.getParentFolderID()) {
            folderObj.setType(2);
        }
        if (folderObj.getPermissions() == null || folderObj.getPermissions().size() == 0) {
            throw OXFolderExceptionCode.MISSING_FOLDER_ATTRIBUTE.create("permissions", "", this.ctx.getContextId());
        }
        OXFolderUtility.checkFolderStringData(folderObj);
        FolderObject parentFolder = this.getOXFolderAccess().getFolderObject(folderObj.getParentFolderID());
        if (checkPermissions) {
            try {
                EffectivePermission p = parentFolder.getEffectiveUserPermission(this.user.getId(), this.userConfig, this.readCon);
                if (!p.canCreateSubfolders()) {
                    OXException fe = OXFolderExceptionCode.NO_CREATE_SUBFOLDER_PERMISSION.create(OXFolderUtility.getUserName(this.user.getId(), this.ctx), OXFolderUtility.getFolderName(parentFolder), this.ctx.getContextId());
                    if (p.getUnderlyingPermission().canCreateSubfolders()) {
                        fe.setCategory(CATEGORY_PERMISSION_DENIED);
                    }
                    throw fe;
                }
                if (!this.userConfig.hasModuleAccess(folderObj.getModule())) {
                    throw OXFolderExceptionCode.NO_MODULE_ACCESS.create(CATEGORY_PERMISSION_DENIED, OXFolderUtility.getUserName(this.user.getId(), this.ctx), OXFolderUtility.folderModule2String(folderObj.getModule()), this.ctx.getContextId());
                }
                if (parentFolder.getType() == 2 && !this.userConfig.hasFullPublicFolderAccess() && folderObj.getModule() != 8) {
                    throw OXFolderExceptionCode.NO_PUBLIC_FOLDER_WRITE_ACCESS.create(OXFolderUtility.getUserName(this.user.getId(), this.ctx), OXFolderUtility.getFolderName(parentFolder), this.ctx.getContextId());
                }
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
        }
        if (!OXFolderUtility.checkFolderTypeAgainstParentType(parentFolder, folderObj.getType())) {
            throw OXFolderExceptionCode.INVALID_TYPE.create(OXFolderUtility.getFolderName(parentFolder), OXFolderUtility.folderType2String(folderObj.getType()), this.ctx.getContextId());
        }
        if (parentFolder.isShared(this.user.getId())) {
            OXFolderUtility.checkSharedSubfolderOwnerPermission(parentFolder, folderObj, this.user.getId(), this.ctx);
            folderObj.setCreatedBy(parentFolder.getCreatedBy());
        }
        if (!OXFolderManagerImpl.isKnownModule(folderObj.getModule())) {
            throw OXFolderExceptionCode.UNKNOWN_MODULE.create(OXFolderUtility.folderModule2String(folderObj.getModule()), this.ctx.getContextId());
        }
        if (!OXFolderUtility.checkFolderModuleAgainstParentModule(parentFolder.getObjectID(), parentFolder.getModule(), folderObj.getModule(), this.ctx.getContextId())) {
            throw OXFolderExceptionCode.INVALID_MODULE.create(OXFolderUtility.getFolderName(parentFolder), OXFolderUtility.folderModule2String(folderObj.getModule()), this.ctx.getContextId());
        }
        OXFolderUtility.checkPermissionsAgainstSessionUserConfig(folderObj, this.userConfig, this.ctx);
        OXFolderUtility.checkFolderPermissions(folderObj, this.user.getId(), this.ctx);
        OXFolderUtility.checkPermissionsAgainstUserConfigs(folderObj, this.ctx);
        if (2 == folderObj.getType()) {
            new CheckPermissionOnInsert(this.session, this.writeCon, this.ctx).checkParentPermissions(parentFolder.getObjectID(), folderObj.getNonSystemPermissionsAsArray(), createTime);
        }
        try {
            boolean throwException;
            String folderName;
            int parentFolderID;
            block46: {
                block45: {
                    parentFolderID = folderObj.getParentFolderID();
                    folderName = folderObj.getFolderName();
                    throwException = false;
                    if (parentFolderID == 1) break block45;
                    if (OXFolderSQL.lookUpFolder(parentFolderID, folderName, folderObj.getModule(), this.readCon, this.ctx) == -1) break block46;
                    throwException = true;
                    break block46;
                }
                TIntList folders2 = OXFolderSQL.lookUpFolders(parentFolderID, folderName, folderObj.getModule(), this.readCon, this.ctx);
                for (int fuid : folders2.toArray()) {
                    FolderObject toCheck = this.getOXFolderAccess().getFolderObject(fuid);
                    if (toCheck.getCreatedBy() != (folderObj.containsCreatedBy() ? folderObj.getCreatedBy() : this.user.getId())) continue;
                    throwException = true;
                    break;
                }
            }
            if (throwException) {
                throw OXFolderExceptionCode.NO_DUPLICATE_FOLDER.create(OXFolderUtility.getFolderName(parentFolder), this.ctx.getContextId());
            }
            OXFolderUtility.checki18nString(parentFolderID, folderName, this.user.getLocale(), this.ctx);
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        if (folderObj.getType() == 1 && folderObj.getPermissions().size() > 1 && !(diff = OXFolderUtility.getShareUsers(null, folderObj.getPermissions(), this.user.getId(), this.ctx)).isEmpty()) {
            FolderObject[] allSharedFolders;
            try {
                int[] fuids = OXFolderSQL.getSharedFoldersOf(this.user.getId(), this.readCon, this.ctx);
                allSharedFolders = new FolderObject[fuids.length];
                for (int i = 0; i < fuids.length; ++i) {
                    allSharedFolders[i] = this.getOXFolderAccess().getFolderObject(fuids[i]);
                }
            }
            catch (DataTruncation e) {
                throw this.parseTruncated(e, folderObj, TABLE_OXFOLDER_TREE);
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            OXFolderUtility.checkSimilarNamedSharedFolder(diff, allSharedFolders, folderObj.getFolderName(), this.ctx);
        }
        OXFolderUtility.checkForDuplicateNonSystemPermissions(folderObj, this.ctx);
        int fuid = -1;
        try {
            fuid = OXFolderSQL.getNextSerial(this.ctx, this.writeCon);
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        if (fuid < 20) {
            throw OXFolderExceptionCode.INVALID_SEQUENCE_ID.create(fuid, 20, this.ctx.getContextId());
        }
        try {
            OXFolderSQL.insertFolderSQL(fuid, this.user.getId(), folderObj, createTime, this.ctx, this.writeCon);
            folderObj.setObjectID(fuid);
        }
        catch (DataTruncation e) {
            throw this.parseTruncated(e, folderObj, TABLE_OXFOLDER_TREE);
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        Date creatingDate = new Date(createTime);
        folderObj.setCreationDate(creatingDate);
        if (!folderObj.containsCreatedBy()) {
            folderObj.setCreatedBy(this.user.getId());
        }
        folderObj.setLastModified(creatingDate);
        folderObj.setModifiedBy(this.user.getId());
        folderObj.setSubfolderFlag(false);
        folderObj.setDefaultFolder(false);
        parentFolder.setSubfolderFlag(true);
        parentFolder.setLastModified(creatingDate);
        ConditionTreeMapManagement.dropFor(this.ctx.getContextId());
        Connection wc = this.writeCon;
        boolean create = wc == null;
        try {
            if (create) {
                wc = DBPool.pickupWriteable(this.ctx);
            }
            if (FolderCacheManager.isInitialized()) {
                FolderCacheManager manager = FolderCacheManager.getInstance();
                manager.removeFolderObject(parentFolder.getObjectID(), this.ctx);
                folderObj.fill(manager.getFolderObject(fuid, false, this.ctx, wc));
            } else {
                folderObj.fill(FolderObject.loadFolderObjectFromDB(fuid, this.ctx, wc));
            }
            if (FolderQueryCacheManager.isInitialized()) {
                FolderQueryCacheManager.getInstance().invalidateContextQueries(this.session);
            }
            if (CalendarCache.isInitialized()) {
                CalendarCache.getInstance().invalidateGroup(this.ctx.getContextId());
            }
            try {
                new EventClient(this.session).create(folderObj);
            }
            catch (OXException e) {
                LOG.warn((Object)"Create event could not be enqueued", (Throwable)e);
            }
            FolderObject folderObject = folderObj;
            return folderObject;
        }
        finally {
            if (create && wc != null) {
                DBPool.closeWriterSilent(this.ctx, wc);
                wc = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FolderObject updateFolder(FolderObject fo, boolean checkPermissions, long lastModified) throws OXException {
        boolean isRenameOnly = false;
        if (checkPermissions) {
            if (fo.containsType() && fo.getType() == 2 && !UserConfigurationStorage.getInstance().getUserConfigurationSafe(this.session.getUserId(), this.ctx).hasFullPublicFolderAccess()) {
                throw OXFolderExceptionCode.NO_PUBLIC_FOLDER_WRITE_ACCESS.create(OXFolderUtility.getUserName(this.session, this.user), OXFolderUtility.getFolderName(fo), this.ctx.getContextId());
            }
            EffectivePermission perm = this.getOXFolderAccess().getFolderPermission(fo.getObjectID(), this.user.getId(), this.userConfig);
            if (!perm.isFolderVisible()) {
                if (!perm.getUnderlyingPermission().isFolderVisible()) {
                    throw OXFolderExceptionCode.NOT_VISIBLE.create(fo.getObjectID(), OXFolderUtility.getUserName(this.session, this.user), this.ctx.getContextId());
                }
                throw OXFolderExceptionCode.NOT_VISIBLE.create(CATEGORY_PERMISSION_DENIED, fo.getObjectID(), OXFolderUtility.getUserName(this.session, this.user), this.ctx.getContextId());
            }
            if (isRenameOnly) {
                EffectivePermission parentPerm = this.getOXFolderAccess().getFolderPermission(this.getFolderFromMaster(fo.getObjectID()).getParentFolderID(), this.user.getId(), this.userConfig);
                if (!perm.isFolderAdmin() && !parentPerm.canCreateSubfolders()) {
                    if (!perm.getUnderlyingPermission().isFolderAdmin() && !parentPerm.getUnderlyingPermission().canCreateSubfolders()) {
                        throw OXFolderExceptionCode.NO_RENAME_ACCESS.create(OXFolderUtility.getUserName(this.session, this.user), OXFolderUtility.getFolderName(fo), this.ctx.getContextId());
                    }
                    throw OXFolderExceptionCode.NO_RENAME_ACCESS.create(CATEGORY_PERMISSION_DENIED, OXFolderUtility.getUserName(this.session, this.user), OXFolderUtility.getFolderName(fo), this.ctx.getContextId());
                }
            } else if (!perm.isFolderAdmin()) {
                if (!perm.getUnderlyingPermission().isFolderAdmin()) {
                    throw OXFolderExceptionCode.NO_ADMIN_ACCESS.create(OXFolderUtility.getUserName(this.session, this.user), OXFolderUtility.getFolderName(fo), this.ctx.getContextId());
                }
                throw OXFolderExceptionCode.NO_ADMIN_ACCESS.create(CATEGORY_PERMISSION_DENIED, OXFolderUtility.getUserName(this.session, this.user), OXFolderUtility.getFolderName(fo), this.ctx.getContextId());
            }
        }
        boolean performMove = fo.containsParentFolderID();
        if (fo.containsPermissions() || fo.containsModule()) {
            if (performMove) {
                this.move(fo.getObjectID(), fo.getParentFolderID(), fo.getCreatedBy(), this.getFolderFromMaster(fo.getObjectID()), lastModified);
            }
            if (isRenameOnly) {
                this.rename(fo, this.getFolderFromMaster(fo.getObjectID()), lastModified);
            } else {
                this.update(fo, 0, this.getFolderFromMaster(fo.getObjectID()), lastModified);
            }
        } else if (fo.containsFolderName()) {
            if (performMove) {
                this.move(fo.getObjectID(), fo.getParentFolderID(), fo.getCreatedBy(), this.getFolderFromMaster(fo.getObjectID()), lastModified);
            }
            this.rename(fo, this.getFolderFromMaster(fo.getObjectID()), lastModified);
        } else if (performMove) {
            this.move(fo.getObjectID(), fo.getParentFolderID(), fo.getCreatedBy(), this.getFolderFromMaster(fo.getObjectID()), lastModified);
        }
        ConditionTreeMapManagement.dropFor(this.ctx.getContextId());
        Connection wc = this.writeCon;
        boolean create = wc == null;
        try {
            if (create) {
                wc = DBPool.pickupWriteable(this.ctx);
            }
            if (FolderCacheManager.isEnabled()) {
                fo.fill(FolderCacheManager.getInstance().getFolderObject(fo.getObjectID(), false, this.ctx, wc));
                if (fo.getParentFolderID() > 0) {
                    FolderCacheManager.getInstance().loadFolderObject(fo.getParentFolderID(), this.ctx, wc);
                }
            } else {
                fo.fill(FolderObject.loadFolderObjectFromDB(fo.getObjectID(), this.ctx, wc));
            }
            if (FolderQueryCacheManager.isInitialized()) {
                FolderQueryCacheManager.getInstance().invalidateContextQueries(this.session);
            }
            if (CalendarCache.isInitialized()) {
                CalendarCache.getInstance().invalidateGroup(this.ctx.getContextId());
            }
            if (5 != fo.getModule()) {
                try {
                    new EventClient(this.session).modify(this.getFolderFromMaster(fo.getObjectID()), fo, FolderObject.loadFolderObjectFromDB(fo.getParentFolderID(), this.ctx, wc, true, false));
                }
                catch (OXException e) {
                    LOG.warn((Object)"Update event could not be enqueued", (Throwable)e);
                }
            }
            FolderObject folderObject = fo;
            return folderObject;
        }
        finally {
            if (create && wc != null) {
                DBPool.closeWriterSilent(this.ctx, wc);
                wc = null;
            }
        }
    }

    private void update(FolderObject folderObj, int options, FolderObject storageObj, long lastModified) throws OXException {
        Set<Integer> diff;
        if (folderObj.getObjectID() <= 0) {
            throw OXFolderExceptionCode.INVALID_OBJECT_ID.create(OXFolderUtility.getFolderName(folderObj));
        }
        if (folderObj.getPermissions() == null || folderObj.getPermissions().size() == 0) {
            if (folderObj.containsPermissions()) {
                throw OXFolderExceptionCode.MISSING_FOLDER_ATTRIBUTE.create("permissions", OXFolderUtility.getFolderName(folderObj), this.ctx.getContextId());
            }
            folderObj.setPermissionsAsArray(storageObj.getPermissionsAsArray());
        }
        if (folderObj.containsParentFolderID() && storageObj.getParentFolderID() != folderObj.getParentFolderID()) {
            throw OXFolderExceptionCode.NO_MOVE_THROUGH_UPDATE.create(OXFolderUtility.getFolderName(folderObj));
        }
        if (folderObj.containsFolderName()) {
            if (folderObj.getFolderName() == null || folderObj.getFolderName().trim().length() == 0) {
                throw OXFolderExceptionCode.MISSING_FOLDER_ATTRIBUTE.create("title", OXFolderUtility.getFolderName(folderObj), this.ctx.getContextId());
            }
            if (storageObj.isDefaultFolder() && !folderObj.getFolderName().equals(storageObj.getFolderName())) {
                throw OXFolderExceptionCode.NO_DEFAULT_FOLDER_RENAME.create(OXFolderUtility.getFolderName(folderObj), this.ctx.getContextId());
            }
        }
        if (folderObj.containsModule() && folderObj.getModule() != storageObj.getModule() && 5 != storageObj.getModule()) {
            if (!OXFolderManagerImpl.isKnownModule(folderObj.getModule())) {
                throw OXFolderExceptionCode.UNKNOWN_MODULE.create(OXFolderUtility.folderModule2String(folderObj.getModule()), this.ctx.getContextId());
            }
            if (storageObj.isDefaultFolder()) {
                throw OXFolderExceptionCode.NO_DEFAULT_FOLDER_MODULE_UPDATE.create();
            }
            if (!this.isFolderEmpty(storageObj.getObjectID(), storageObj.getModule())) {
                throw OXFolderExceptionCode.DENY_FOLDER_MODULE_UPDATE.create();
            }
            if ((options & 1) > 0) {
                throw OXFolderExceptionCode.NO_FOLDER_MODULE_UPDATE.create();
            }
            FolderObject parent = this.getFolderFromMaster(storageObj.getParentFolderID());
            if (!OXFolderUtility.checkFolderModuleAgainstParentModule(parent.getObjectID(), parent.getModule(), folderObj.getModule(), this.ctx.getContextId())) {
                throw OXFolderExceptionCode.INVALID_MODULE.create(OXFolderUtility.getFolderName(parent), OXFolderUtility.folderModule2String(folderObj.getModule()), this.ctx.getContextId());
            }
        } else {
            folderObj.setModule(storageObj.getModule());
        }
        if (storageObj.isShared(this.user.getId())) {
            throw OXFolderExceptionCode.NO_SHARED_FOLDER_UPDATE.create(OXFolderUtility.getFolderName(folderObj), this.ctx.getContextId());
        }
        folderObj.setType(storageObj.getType());
        folderObj.setCreatedBy(storageObj.getCreatedBy());
        folderObj.setDefaultFolder(storageObj.isDefaultFolder());
        OXFolderUtility.checkPermissionsAgainstSessionUserConfig(folderObj, this.userConfig, this.ctx);
        OXFolderUtility.checkFolderPermissions(folderObj, this.user.getId(), this.ctx);
        OXFolderUtility.checkPermissionsAgainstUserConfigs(folderObj, this.ctx);
        OXFolderUtility.checkSystemFolderPermissions(folderObj.getObjectID(), folderObj.getNonSystemPermissionsAsArray(), this.user, this.ctx);
        if (2 == folderObj.getType()) {
            OCLPermission[] removedPerms = OXFolderUtility.getPermissionsWithoutFolderAccess(folderObj.getNonSystemPermissionsAsArray(), storageObj.getNonSystemPermissionsAsArray());
            if (removedPerms.length > 0) {
                new CheckPermissionOnRemove(this.session, this.writeCon, this.ctx).checkPermissionsOnUpdate(folderObj.getObjectID(), removedPerms, lastModified);
            }
            new CheckPermissionOnInsert(this.session, this.writeCon, this.ctx).checkParentPermissions(storageObj.getParentFolderID(), folderObj.getNonSystemPermissionsAsArray(), lastModified);
        }
        boolean rename = false;
        if (folderObj.containsFolderName() && !storageObj.getFolderName().equals(folderObj.getFolderName())) {
            rename = true;
            OXFolderUtility.checkFolderStringData(folderObj);
            try {
                String folderName = folderObj.getFolderName();
                int folderId = OXFolderSQL.lookUpFolderOnUpdate(folderObj.getObjectID(), storageObj.getParentFolderID(), folderName, folderObj.getModule(), this.readCon, this.ctx);
                if (folderId != -1 && folderId != folderObj.getObjectID()) {
                    throw OXFolderExceptionCode.NO_DUPLICATE_FOLDER.create(OXFolderUtility.getFolderName(new OXFolderAccess(this.readCon, this.ctx).getFolderObject(storageObj.getParentFolderID())), this.ctx.getContextId());
                }
                int parentFolderId = storageObj.getParentFolderID();
                OXFolderUtility.checki18nString(parentFolderId, folderName, this.user.getLocale(), this.ctx);
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
        }
        if (folderObj.getType() == 1 && folderObj.getPermissions().size() > 1 && !(diff = OXFolderUtility.getShareUsers(rename ? null : storageObj.getPermissions(), folderObj.getPermissions(), this.user.getId(), this.ctx)).isEmpty()) {
            FolderObject[] allSharedFolders;
            try {
                int[] fuids = OXFolderSQL.getSharedFoldersOf(this.user.getId(), this.readCon, this.ctx);
                allSharedFolders = new FolderObject[fuids.length];
                for (int i = 0; i < fuids.length; ++i) {
                    if (fuids[i] == folderObj.getObjectID()) continue;
                    allSharedFolders[i] = this.getOXFolderAccess().getFolderObject(fuids[i]);
                }
            }
            catch (DataTruncation e) {
                throw this.parseTruncated(e, folderObj, TABLE_OXFOLDER_TREE);
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            OXFolderUtility.checkSimilarNamedSharedFolder(diff, allSharedFolders, rename ? folderObj.getFolderName() : storageObj.getFolderName(), this.ctx);
        }
        OXFolderUtility.checkForDuplicateNonSystemPermissions(folderObj, this.ctx);
        try {
            OXFolderSQL.updateFolderSQL(this.user.getId(), folderObj, lastModified, this.ctx, this.writeCon);
        }
        catch (DataTruncation e) {
            throw this.parseTruncated(e, folderObj, TABLE_OXFOLDER_TREE);
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
    }

    private FolderObject getFolderFromMaster(int folderId) throws OXException {
        return this.getFolderFromMaster(folderId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FolderObject getFolderFromMaster(int folderId, boolean withSubfolders) throws OXException {
        FolderObject folderObject;
        Connection wc = this.writeCon;
        if (wc != null) return FolderObject.loadFolderObjectFromDB(folderId, this.ctx, wc, true, withSubfolders);
        try {
            wc = DBPool.pickupWriteable(this.ctx);
            folderObject = FolderObject.loadFolderObjectFromDB(folderId, this.ctx, wc, true, withSubfolders);
            if (wc == null) return folderObject;
        }
        catch (Throwable throwable) {
            if (wc == null) throw throwable;
            DBPool.closeWriterSilent(this.ctx, wc);
            throw throwable;
        }
        DBPool.closeWriterSilent(this.ctx, wc);
        return folderObject;
    }

    private boolean isFolderEmpty(int folderId, int module) throws OXException {
        if (module == 1) {
            Tasks tasks2 = Tasks.getInstance();
            return this.readCon == null ? tasks2.isFolderEmpty(this.ctx, folderId) : tasks2.isFolderEmpty(this.ctx, this.readCon, folderId);
        }
        if (module == 2) {
            AppointmentSQLInterface calSql = ServerServiceRegistry.getInstance().getService(AppointmentSqlFactoryService.class).createAppointmentSql(this.session);
            if (this.readCon == null) {
                try {
                    return calSql.isFolderEmpty(this.user.getId(), folderId);
                }
                catch (SQLException e) {
                    throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
                }
            }
            try {
                return calSql.isFolderEmpty(this.user.getId(), folderId, this.readCon);
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
        }
        if (module == 3) {
            return this.readCon == null ? !Contacts.containsAnyObjectInFolder(folderId, this.ctx) : !Contacts.containsAnyObjectInFolder(folderId, this.readCon, this.ctx);
        }
        if (module == 8) {
            InfostoreFacadeImpl db = new InfostoreFacadeImpl(this.readCon == null ? new DBPoolProvider() : new StaticDBPoolProvider(this.readCon));
            return db.isFolderEmpty(folderId, this.ctx);
        }
        if (module == 5) {
            return true;
        }
        throw OXFolderExceptionCode.UNKNOWN_MODULE.create(OXFolderUtility.folderModule2String(module), this.ctx.getContextId());
    }

    private static boolean isKnownModule(int module) {
        return module == 1 || module == 2 || module == 3 || module == 8;
    }

    private void rename(FolderObject folderObj, FolderObject storageObj, long lastModified) throws OXException {
        Set<Integer> diff;
        if (folderObj.getObjectID() <= 0) {
            throw OXFolderExceptionCode.INVALID_OBJECT_ID.create(OXFolderUtility.getFolderName(folderObj));
        }
        if (!folderObj.containsFolderName() || folderObj.getFolderName() == null || folderObj.getFolderName().trim().length() == 0) {
            throw OXFolderExceptionCode.MISSING_FOLDER_ATTRIBUTE.create("title", "", this.ctx.getContextId());
        }
        OXFolderUtility.checkFolderStringData(folderObj);
        if (storageObj.getFolderName().equals(folderObj.getFolderName())) {
            return;
        }
        if (storageObj.isDefaultFolder()) {
            throw OXFolderExceptionCode.NO_DEFAULT_FOLDER_RENAME.create(OXFolderUtility.getFolderName(folderObj), this.ctx.getContextId());
        }
        try {
            boolean throwException;
            int parentFolderID;
            String folderName;
            block17: {
                block16: {
                    folderName = folderObj.getFolderName();
                    parentFolderID = storageObj.getParentFolderID();
                    int folderId = folderObj.getObjectID();
                    throwException = false;
                    if (parentFolderID == 1) break block16;
                    if (OXFolderSQL.lookUpFolderOnUpdate(folderId, parentFolderID, folderName, storageObj.getModule(), this.readCon, this.ctx) == -1) break block17;
                    throwException = true;
                    break block17;
                }
                TIntList folders2 = OXFolderSQL.lookUpFolders(parentFolderID, folderName, storageObj.getModule(), this.readCon, this.ctx);
                for (int fuid : folders2.toArray()) {
                    FolderObject toCheck = this.getOXFolderAccess().getFolderObject(fuid);
                    if (toCheck.getCreatedBy() != (folderObj.containsCreatedBy() ? folderObj.getCreatedBy() : this.user.getId())) continue;
                    throwException = true;
                    break;
                }
            }
            if (throwException) {
                throw OXFolderExceptionCode.NO_DUPLICATE_FOLDER.create(OXFolderUtility.getFolderName(new OXFolderAccess(this.readCon, this.ctx).getFolderObject(storageObj.getParentFolderID())), this.ctx.getContextId());
            }
            OXFolderUtility.checki18nString(parentFolderID, folderName, this.user.getLocale(), this.ctx);
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        if (storageObj.getType() == 1 && storageObj.getPermissions().size() > 1 && !(diff = OXFolderUtility.getShareUsers(null, storageObj.getPermissions(), this.user.getId(), this.ctx)).isEmpty()) {
            FolderObject[] allSharedFolders;
            try {
                int[] fuids = OXFolderSQL.getSharedFoldersOf(this.user.getId(), this.readCon, this.ctx);
                allSharedFolders = new FolderObject[fuids.length];
                for (int i = 0; i < fuids.length; ++i) {
                    if (fuids[i] == folderObj.getObjectID()) continue;
                    allSharedFolders[i] = this.getOXFolderAccess().getFolderObject(fuids[i]);
                }
            }
            catch (DataTruncation e) {
                throw this.parseTruncated(e, folderObj, TABLE_OXFOLDER_TREE);
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            OXFolderUtility.checkSimilarNamedSharedFolder(diff, allSharedFolders, folderObj.getFolderName(), this.ctx);
        }
        try {
            OXFolderSQL.renameFolderSQL(this.user.getId(), folderObj, lastModified, this.ctx, this.writeCon);
        }
        catch (DataTruncation e) {
            throw this.parseTruncated(e, folderObj, TABLE_OXFOLDER_TREE);
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
    }

    private static boolean isInArray(int key, int[] a) {
        Arrays.sort(a);
        return Arrays.binarySearch(a, key) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void move(int folderId, int targetFolderId, int createdBy, FolderObject storageSrc, long lastModified) throws OXException {
        if (storageSrc.getParentFolderID() == targetFolderId) {
            return;
        }
        if (storageSrc.isDefaultFolder()) {
            throw OXFolderExceptionCode.NO_DEFAULT_FOLDER_MOVE.create(OXFolderUtility.getFolderName(storageSrc), this.ctx.getContextId());
        }
        FolderObject storageDest = this.getOXFolderAccess().getFolderObject(targetFolderId);
        try {
            boolean throwException;
            String folderName;
            block41: {
                int parentFolderID;
                block40: {
                    parentFolderID = storageDest.getObjectID();
                    folderName = storageSrc.getFolderName();
                    throwException = false;
                    if (parentFolderID == 1) break block40;
                    if (OXFolderSQL.lookUpFolderOnUpdate(folderId, parentFolderID, folderName, storageSrc.getModule(), this.readCon, this.ctx) == -1) break block41;
                    throwException = true;
                    break block41;
                }
                TIntList folders2 = OXFolderSQL.lookUpFolders(parentFolderID, folderName, storageSrc.getModule(), this.readCon, this.ctx);
                for (int fuid : folders2.toArray()) {
                    FolderObject toCheck = this.getOXFolderAccess().getFolderObject(fuid);
                    if (toCheck.getCreatedBy() != (createdBy > 0 ? createdBy : this.user.getId())) continue;
                    throwException = true;
                    break;
                }
            }
            if (throwException) {
                throw OXFolderExceptionCode.TARGET_FOLDER_CONTAINS_DUPLICATE.create(OXFolderUtility.getFolderName(storageDest), this.ctx.getContextId());
            }
            OXFolderUtility.checki18nString(targetFolderId, folderName, this.user.getLocale(), this.ctx);
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        try {
            if (storageSrc.isShared(this.user.getId())) {
                throw OXFolderExceptionCode.NO_SHARED_FOLDER_MOVE.create(OXFolderUtility.getFolderName(storageSrc), this.ctx.getContextId());
            }
            if (storageDest.isShared(this.user.getId())) {
                throw OXFolderExceptionCode.NO_SHARED_FOLDER_TARGET.create(OXFolderUtility.getFolderName(storageDest), this.ctx.getContextId());
            }
            if (storageSrc.getType() == 5) {
                throw OXFolderExceptionCode.NO_SYSTEM_FOLDER_MOVE.create(OXFolderUtility.getFolderName(storageSrc), this.ctx.getContextId());
            }
            if (storageSrc.getType() == 1 && (storageDest.getType() == 2 || storageDest.getType() == 5 && targetFolderId != 1)) {
                throw OXFolderExceptionCode.ONLY_PRIVATE_TO_PRIVATE_MOVE.create(OXFolderUtility.getFolderName(storageSrc), this.ctx.getContextId());
            }
            if (storageSrc.getType() == 2 && (storageDest.getType() == 1 || storageDest.getType() == 5 && !OXFolderManagerImpl.isInArray(targetFolderId, this.SYSTEM_PUBLIC_FOLDERS))) {
                throw OXFolderExceptionCode.ONLY_PUBLIC_TO_PUBLIC_MOVE.create(OXFolderUtility.getFolderName(storageSrc), this.ctx.getContextId());
            }
            if (storageSrc.getModule() == 8 && storageDest.getModule() != 8 && targetFolderId != 9) {
                throw OXFolderExceptionCode.INCOMPATIBLE_MODULES.create(OXFolderUtility.folderModule2String(storageSrc.getModule()), OXFolderUtility.folderModule2String(storageDest.getModule()));
            }
            if (storageSrc.getModule() != 8 && storageDest.getModule() == 8) {
                throw OXFolderExceptionCode.INCOMPATIBLE_MODULES.create(OXFolderUtility.folderModule2String(storageSrc.getModule()), OXFolderUtility.folderModule2String(storageDest.getModule()));
            }
            if (storageDest.getEffectiveUserPermission(this.user.getId(), this.userConfig).getFolderPermission() < 8) {
                throw OXFolderExceptionCode.NO_CREATE_SUBFOLDER_PERMISSION.create(OXFolderUtility.getUserName(this.user.getId(), this.ctx), OXFolderUtility.getFolderName(storageDest), this.ctx.getContextId());
            }
            if (folderId == targetFolderId) {
                throw OXFolderExceptionCode.NO_EQUAL_MOVE.create(this.ctx.getContextId());
            }
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        try {
            if (storageSrc.hasSubfolders()) {
                TIntArrayList parentIDList = new TIntArrayList(1);
                parentIDList.add(storageSrc.getObjectID());
                if (OXFolderUtility.isDescendentFolder((TIntList)parentIDList, targetFolderId, this.readCon, this.ctx)) {
                    throw OXFolderExceptionCode.NO_SUBFOLDER_MOVE.create(OXFolderUtility.getFolderName(storageSrc), this.ctx.getContextId());
                }
                int numOfMoveableSubfolders = OXFolderSQL.getNumOfMoveableSubfolders(storageSrc.getObjectID(), this.user.getId(), this.user.getGroups(), this.readCon, this.ctx);
                if (numOfMoveableSubfolders != storageSrc.getSubfolderIds(true, this.ctx).size()) {
                    throw OXFolderExceptionCode.NO_SUBFOLDER_MOVE_ACCESS.create(OXFolderUtility.getUserName(this.session, this.user), OXFolderUtility.getFolderName(storageSrc), this.ctx.getContextId());
                }
            }
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        try {
            this.processDeletedFolderThroughMove(storageSrc, new CheckPermissionOnRemove(this.session, this.writeCon, this.ctx), lastModified);
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        try {
            OXFolderSQL.moveFolderSQL(this.user.getId(), storageSrc, storageDest, lastModified, this.ctx, this.readCon, this.writeCon);
        }
        catch (DataTruncation e) {
            throw this.parseTruncated(e, storageSrc, TABLE_OXFOLDER_TREE);
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        try {
            this.processInsertedFolderThroughMove(this.getFolderFromMaster(folderId), new CheckPermissionOnInsert(this.session, this.writeCon, this.ctx), lastModified);
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        try {
            OXFolderSQL.updateLastModified(storageSrc.getParentFolderID(), lastModified, this.user.getId(), this.writeCon, this.ctx);
            OXFolderSQL.updateLastModified(storageSrc.getObjectID(), lastModified, this.user.getId(), this.writeCon, this.ctx);
            OXFolderSQL.updateLastModified(storageDest.getObjectID(), lastModified, this.user.getId(), this.writeCon, this.ctx);
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        ConditionTreeMapManagement.dropFor(this.ctx.getContextId());
        if (FolderCacheManager.isEnabled()) {
            boolean create;
            Connection wc = this.writeCon;
            boolean bl = create = wc == null;
            if (create) {
                wc = DBPool.pickupWriteable(this.ctx);
            }
            try {
                int destParentId;
                int srcParentId = storageSrc.getParentFolderID();
                if (srcParentId > 0) {
                    FolderCacheManager.getInstance().loadFolderObject(srcParentId, this.ctx, wc);
                }
                if ((destParentId = storageDest.getParentFolderID()) > 0) {
                    FolderCacheManager.getInstance().loadFolderObject(destParentId, this.ctx, wc);
                }
            }
            finally {
                if (create && wc != null) {
                    DBPool.closeWriterSilent(this.ctx, wc);
                }
            }
        }
    }

    private void processDeletedFolderThroughMove(FolderObject folder, CheckPermissionOnRemove checker, long lastModified) throws OXException, SQLException, OXException {
        int folderId = folder.getObjectID();
        ArrayList<Integer> subflds = FolderObject.getSubfolderIds(folderId, this.ctx, this.writeCon);
        for (Integer subfld : subflds) {
            this.processDeletedFolderThroughMove(this.getOXFolderAccess().getFolderObject(subfld), checker, lastModified);
        }
        checker.checkPermissionsOnDelete(folder.getParentFolderID(), folderId, folder.getNonSystemPermissionsAsArray(), lastModified);
        OXFolderSQL.deleteAllSystemPermission(folderId, this.writeCon, this.ctx);
    }

    private void processInsertedFolderThroughMove(FolderObject folder, CheckPermissionOnInsert checker, long lastModified) throws OXException, SQLException, OXException {
        int folderId = folder.getObjectID();
        checker.checkParentPermissions(folder.getParentFolderID(), folder.getNonSystemPermissionsAsArray(), lastModified);
        ArrayList<Integer> subflds = FolderObject.getSubfolderIds(folderId, this.ctx, this.writeCon);
        for (Integer subfld : subflds) {
            this.processInsertedFolderThroughMove(this.getOXFolderAccess().getFolderObject(subfld), checker, lastModified);
        }
    }

    @Override
    public FolderObject clearFolder(FolderObject fo, boolean checkPermissions, long lastModified) throws OXException {
        EffectivePermission p;
        if (fo.getObjectID() <= 0) {
            throw OXFolderExceptionCode.INVALID_OBJECT_ID.create(OXFolderUtility.getFolderName(fo));
        }
        if (!fo.containsParentFolderID() || fo.getParentFolderID() <= 0) {
            fo.setParentFolderID(this.getOXFolderAccess().getParentFolderID(fo.getObjectID()));
        } else {
            try {
                if (!OXFolderSQL.exists(fo.getObjectID(), this.readCon, this.ctx)) {
                    throw OXFolderExceptionCode.NOT_EXISTS.create(fo.getObjectID(), this.ctx.getContextId());
                }
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
        }
        if (checkPermissions && !(p = this.getOXFolderAccess().getFolderPermission(fo.getObjectID(), this.user.getId(), this.userConfig)).isFolderVisible()) {
            if (p.getUnderlyingPermission().isFolderVisible()) {
                throw OXFolderExceptionCode.NOT_VISIBLE.create(fo.getObjectID(), OXFolderUtility.getUserName(this.user.getId(), this.ctx), this.ctx.getContextId());
            }
            throw OXFolderExceptionCode.NOT_VISIBLE.create(CATEGORY_PERMISSION_DENIED, fo.getObjectID(), OXFolderUtility.getUserName(this.user.getId(), this.ctx), this.ctx.getContextId());
        }
        if (!this.getOXFolderAccess().canDeleteAllObjectsInFolder(fo, this.session, this.ctx)) {
            throw OXFolderExceptionCode.NOT_ALL_OBJECTS_DELETION.create(OXFolderUtility.getUserName(this.user.getId(), this.ctx), OXFolderUtility.getFolderName(fo.getObjectID(), this.ctx), this.ctx.getContextId());
        }
        int module = fo.getModule();
        switch (module) {
            case 2: {
                this.deleteContainedAppointments(fo.getObjectID());
                break;
            }
            case 1: {
                this.deleteContainedTasks(fo.getObjectID());
                break;
            }
            case 3: {
                this.deleteContainedContacts(fo.getObjectID());
                break;
            }
            case 4: {
                break;
            }
            case 8: {
                this.deleteContainedDocuments(fo.getObjectID());
                break;
            }
            case 6: {
                break;
            }
            default: {
                throw OXFolderExceptionCode.UNKNOWN_MODULE.create(module, this.ctx.getContextId());
            }
        }
        return fo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FolderObject deleteFolder(FolderObject fo, boolean checkPermissions, long lastModified) throws OXException {
        FolderObject folderObject;
        block25: {
            TIntObjectMap<TIntObjectMap<?>> deleteableFolders;
            int folderId = fo.getObjectID();
            if (folderId <= 0) {
                throw OXFolderExceptionCode.INVALID_OBJECT_ID.create(OXFolderUtility.getFolderName(fo));
            }
            if (folderId < 20) {
                throw OXFolderExceptionCode.NO_SYSTEM_FOLDER_MOVE.create(OXFolderUtility.getFolderName(fo), this.ctx.getContextId());
            }
            if (!fo.containsCreatedBy() || fo.getCreatedBy() <= 0) {
                fo.setCreatedBy(this.getOXFolderAccess().getFolderOwner(folderId));
            }
            if (!fo.containsParentFolderID() || fo.getParentFolderID() <= 0) {
                fo.setParentFolderID(this.getOXFolderAccess().getParentFolderID(folderId));
            } else {
                try {
                    if (!OXFolderSQL.exists(folderId, this.readCon, this.ctx)) {
                        throw OXFolderExceptionCode.NOT_EXISTS.create(folderId, this.ctx.getContextId());
                    }
                }
                catch (SQLException e) {
                    throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
                }
            }
            if (checkPermissions) {
                EffectivePermission p = this.getOXFolderAccess().getFolderPermission(folderId, this.user.getId(), this.userConfig);
                if (!p.isFolderVisible()) {
                    if (p.getUnderlyingPermission().isFolderVisible()) {
                        throw OXFolderExceptionCode.NOT_VISIBLE.create(folderId, OXFolderUtility.getUserName(this.user.getId(), this.ctx), this.ctx.getContextId());
                    }
                    throw OXFolderExceptionCode.NOT_VISIBLE.create(CATEGORY_PERMISSION_DENIED, folderId, OXFolderUtility.getUserName(this.user.getId(), this.ctx), this.ctx.getContextId());
                }
                if (!p.isFolderAdmin()) {
                    if (!p.getUnderlyingPermission().isFolderAdmin()) {
                        throw OXFolderExceptionCode.NO_ADMIN_ACCESS.create(OXFolderUtility.getUserName(this.user.getId(), this.ctx), OXFolderUtility.getFolderName(fo), this.ctx.getContextId());
                    }
                    throw OXFolderExceptionCode.NO_ADMIN_ACCESS.create(CATEGORY_PERMISSION_DENIED, OXFolderUtility.getUserName(this.user.getId(), this.ctx), OXFolderUtility.getFolderName(fo), this.ctx.getContextId());
                }
            }
            FolderObject parentObj = this.getOXFolderAccess().getFolderObject(fo.getParentFolderID());
            try {
                deleteableFolders = this.gatherDeleteableFolders(folderId, this.user.getId(), this.userConfig, StringCollection.getSqlInString(this.user.getId(), this.user.getGroups()));
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            int type = this.getOXFolderAccess().getFolderType(folderId);
            this.deleteValidatedFolders(deleteableFolders, lastModified, type);
            if (FolderQueryCacheManager.isInitialized()) {
                FolderQueryCacheManager.getInstance().invalidateContextQueries(this.session);
            }
            if (CalendarCache.isInitialized()) {
                CalendarCache.getInstance().invalidateGroup(this.ctx.getContextId());
            }
            ConditionTreeMapManagement.dropFor(this.ctx.getContextId());
            Connection wc = this.writeCon;
            boolean create = wc == null;
            try {
                if (create) {
                    wc = DBPool.pickupWriteable(this.ctx);
                }
                boolean hasSubfolders = !OXFolderSQL.getSubfolderIDs(parentObj.getObjectID(), wc, this.ctx).isEmpty();
                OXFolderSQL.updateSubfolderFlag(parentObj.getObjectID(), hasSubfolders, lastModified, wc, this.ctx);
                if (FolderCacheManager.isEnabled() && FolderCacheManager.isInitialized()) {
                    FolderCacheManager.getInstance().loadFolderObject(parentObj.getObjectID(), this.ctx, wc);
                }
                fo.fill(FolderObject.loadFolderObjectFromDB(folderId, this.ctx, wc, true, false, "del_oxfolder_tree", "del_oxfolder_permissions"));
                folderObject = fo;
                if (!create || wc == null) break block25;
            }
            catch (Throwable throwable) {
                try {
                    if (create && wc != null) {
                        DBPool.closeWriterSilent(this.ctx, wc);
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
                }
            }
            DBPool.closeWriterSilent(this.ctx, wc);
        }
        return folderObject;
    }

    void deleteValidatedFolders(TIntObjectMap<TIntObjectMap<?>> deleteableIDs, long lastModified, int type) throws OXException {
        OXException error;
        DeleteValidatedFoldersProcedure procedure = new DeleteValidatedFoldersProcedure(lastModified, type);
        if (!deleteableIDs.forEachEntry((TIntObjectProcedure)procedure) && null != (error = procedure.error)) {
            throw error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteValidatedFolder(int folderID, long lastModified, int type, boolean hardDelete) throws OXException {
        if (hardDelete) {
            this.deleteContainedItems(folderID);
            try {
                OXFolderSQL.delOXFolder(folderID, this.session.getUserId(), lastModified, true, false, this.ctx, this.writeCon);
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
        }
        Iterator<FolderDeleteListenerService> iter = FolderDeleteListenerRegistry.getInstance().getDeleteListenerServices();
        while (iter.hasNext()) {
            FolderDeleteListenerService next = iter.next();
            try {
                next.onFolderDelete(folderID, this.ctx);
            }
            catch (OXException e) {
                LOG.error((Object)new StringBuilder(128).append("Folder delete listener \"").append(next.getClass().getName()).append("\" failed for folder ").append(folderID).append(" int context ").append(this.ctx.getContextId()), (Throwable)e);
                throw e;
            }
        }
        this.deleteContainedItems(folderID);
        OCLPermission[] perms = this.getOXFolderAccess().getFolderObject(folderID).getPermissionsAsArray();
        int parent = this.getOXFolderAccess().getParentFolderID(folderID);
        try {
            OXFolderSQL.delWorkingOXFolder(folderID, this.session.getUserId(), lastModified, this.ctx, this.writeCon);
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        if (2 == type) {
            new CheckPermissionOnRemove(this.session, this.writeCon, this.ctx).checkPermissionsOnDelete(parent, folderID, perms, lastModified);
        }
        if (FolderQueryCacheManager.isInitialized()) {
            FolderQueryCacheManager.getInstance().invalidateContextQueries(this.ctx.getContextId());
        }
        if (CalendarCache.isInitialized()) {
            CalendarCache.getInstance().invalidateGroup(this.ctx.getContextId());
        }
        ConditionTreeMapManagement.dropFor(this.ctx.getContextId());
        if (FolderCacheManager.isEnabled() && FolderCacheManager.isInitialized()) {
            try {
                FolderCacheManager.getInstance().removeFolderObject(folderID, this.ctx);
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        Connection wc = this.writeCon;
        boolean closeWriter = false;
        if (wc == null) {
            wc = DBPool.pickupWriteable(this.ctx);
            closeWriter = true;
        }
        try {
            Links.deleteAllFolderLinks(folderID, this.ctx.getContextId(), wc);
            ServerUserSetting sus = ServerUserSetting.getInstance(wc);
            Integer collectFolder = sus.getContactCollectionFolder(this.ctx.getContextId(), this.user.getId());
            if (null != collectFolder && folderID == collectFolder) {
                sus.setContactCollectOnMailAccess(this.ctx.getContextId(), this.user.getId(), false);
                sus.setContactCollectOnMailTransport(this.ctx.getContextId(), this.user.getId(), false);
                sus.setContactCollectionFolder(this.ctx.getContextId(), this.user.getId(), null);
            }
            if (!hardDelete) {
                FolderObject fo = FolderObject.loadFolderObjectFromDB(folderID, this.ctx, wc, true, false, "del_oxfolder_tree", "del_oxfolder_permissions");
                try {
                    new EventClient(this.session).delete(fo);
                }
                catch (OXException e) {
                    LOG.warn((Object)"Delete event could not be enqueued", (Throwable)e);
                }
            }
        }
        finally {
            if (closeWriter) {
                DBPool.closeWriterSilent(this.ctx, wc);
            }
        }
    }

    private void deleteContainedItems(int folderID) throws OXException {
        int module = this.getOXFolderAccess().getFolderModule(folderID);
        switch (module) {
            case 2: {
                this.deleteContainedAppointments(folderID);
                break;
            }
            case 1: {
                this.deleteContainedTasks(folderID);
                break;
            }
            case 3: {
                this.deleteContainedContacts(folderID);
                break;
            }
            case 4: {
                break;
            }
            case 8: {
                this.deleteContainedDocuments(folderID);
                break;
            }
            case 6: {
                break;
            }
            default: {
                throw OXFolderExceptionCode.UNKNOWN_MODULE.create(module, this.ctx.getContextId());
            }
        }
    }

    private void deleteContainedAppointments(int folderID) throws OXException {
        try {
            if (null == this.writeCon) {
                this.cSql.deleteAppointmentsInFolder(folderID);
            } else {
                this.cSql.deleteAppointmentsInFolder(folderID, this.writeCon);
            }
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
    }

    private void deleteContainedTasks(int folderID) throws OXException {
        Tasks tasks2 = Tasks.getInstance();
        if (null == this.writeCon) {
            Connection wc = null;
            try {
                wc = DBPool.pickupWriteable(this.ctx);
                tasks2.deleteTasksInFolder(this.session, wc, folderID);
            }
            catch (OXException e) {
                throw new OXException(e);
            }
            finally {
                if (null != wc) {
                    DBPool.closeWriterSilent(this.ctx, wc);
                }
            }
        } else {
            tasks2.deleteTasksInFolder(this.session, this.writeCon, folderID);
        }
    }

    private void deleteContainedContacts(int folderID) throws OXException {
        ServerServiceRegistry.getInstance().getService(ContactService.class).deleteContacts(this.session, String.valueOf(folderID));
    }

    private void deleteContainedDocuments(int folderID) throws OXException {
        InfostoreFacadeImpl infostoreFacade;
        if (this.writeCon == null) {
            infostoreFacade = new InfostoreFacadeImpl(new DBPoolProvider());
        } else {
            infostoreFacade = new InfostoreFacadeImpl(new StaticDBPoolProvider(this.writeCon));
            infostoreFacade.setCommitsTransaction(false);
        }
        infostoreFacade.setTransactional(true);
        try {
            infostoreFacade.startTransaction();
            try {
                infostoreFacade.removeDocument(folderID, System.currentTimeMillis(), ServerSessionAdapter.valueOf(this.session, this.ctx));
                infostoreFacade.commit();
            }
            catch (OXException x) {
                infostoreFacade.rollback();
                if (InfostoreExceptionCodes.ALREADY_LOCKED.equals(x)) {
                    throw OXFolderExceptionCode.DELETE_FAILED_LOCKED_DOCUMENTS.create(x, OXFolderUtility.getFolderName(folderID, this.ctx), this.ctx.getContextId());
                }
                throw x;
            }
            catch (RuntimeException x) {
                infostoreFacade.rollback();
                throw OXFolderExceptionCode.RUNTIME_ERROR.create(x, this.ctx.getContextId());
            }
            finally {
                infostoreFacade.finish();
            }
        }
        catch (OXException e) {
            throw new OXException(e);
        }
    }

    private TIntObjectMap<TIntObjectMap<?>> gatherDeleteableFolders(int folderID, int userId, UserConfiguration userConfig, String permissionIDs) throws OXException, OXException, SQLException {
        TIntObjectHashMap deleteableIDs = new TIntObjectHashMap();
        Integer[] specials = new Integer[1];
        Integer i = null;
        ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
        if (null != service && service.getBoolProperty("com.openexchange.contactcollector.folder.deleteDenied", false)) {
            i = ServerUserSetting.getInstance(this.writeCon).getContactCollectionFolder(this.ctx.getContextId(), userId);
        }
        specials[0] = i;
        this.gatherDeleteableSubfoldersRecursively(folderID, userId, userConfig, permissionIDs, (TIntObjectMap<TIntObjectMap<?>>)deleteableIDs, folderID, specials);
        return deleteableIDs;
    }

    private void gatherDeleteableSubfoldersRecursively(int folderID, int userId, UserConfiguration userConfig, String permissionIDs, TIntObjectMap<TIntObjectMap<?>> deleteableIDs, int initParent, Integer[] specials) throws OXException, OXException, SQLException {
        FolderObject delFolder = this.getOXFolderAccess().getFolderObject(folderID);
        if (delFolder.isShared(userId)) {
            throw OXFolderExceptionCode.NO_SHARED_FOLDER_DELETION.create(OXFolderUtility.getUserName(userId, this.ctx), OXFolderUtility.getFolderName(folderID, this.ctx), this.ctx.getContextId());
        }
        if (delFolder.isDefaultFolder()) {
            throw OXFolderExceptionCode.NO_DEFAULT_FOLDER_DELETION.create(OXFolderUtility.getUserName(userId, this.ctx), OXFolderUtility.getFolderName(folderID, this.ctx), this.ctx.getContextId());
        }
        EffectivePermission effectivePerm = this.getOXFolderAccess().getFolderPermission(folderID, userId, userConfig);
        if (!effectivePerm.isFolderVisible()) {
            if (!effectivePerm.getUnderlyingPermission().isFolderVisible()) {
                if (initParent == folderID) {
                    throw OXFolderExceptionCode.NOT_VISIBLE.create(folderID, OXFolderUtility.getUserName(userId, this.ctx), this.ctx.getContextId());
                }
                throw OXFolderExceptionCode.HIDDEN_FOLDER_ON_DELETION.create(OXFolderUtility.getFolderName(initParent, this.ctx), this.ctx.getContextId(), OXFolderUtility.getUserName(userId, this.ctx));
            }
            if (initParent == folderID) {
                throw OXFolderExceptionCode.NOT_VISIBLE.create(CATEGORY_PERMISSION_DENIED, folderID, OXFolderUtility.getUserName(userId, this.ctx), this.ctx.getContextId());
            }
            throw OXFolderExceptionCode.HIDDEN_FOLDER_ON_DELETION.create(CATEGORY_PERMISSION_DENIED, OXFolderUtility.getFolderName(initParent, this.ctx), this.ctx.getContextId(), OXFolderUtility.getUserName(userId, this.ctx));
        }
        if (!effectivePerm.isFolderAdmin()) {
            if (!effectivePerm.getUnderlyingPermission().isFolderAdmin()) {
                throw OXFolderExceptionCode.NO_ADMIN_ACCESS.create(OXFolderUtility.getUserName(userId, this.ctx), OXFolderUtility.getFolderName(folderID, this.ctx), this.ctx.getContextId());
            }
            throw OXFolderExceptionCode.NO_ADMIN_ACCESS.create(CATEGORY_PERMISSION_DENIED, OXFolderUtility.getUserName(userId, this.ctx), OXFolderUtility.getFolderName(folderID, this.ctx), this.ctx.getContextId());
        }
        if (!this.getOXFolderAccess().canDeleteAllObjectsInFolder(delFolder, this.session, this.ctx)) {
            throw OXFolderExceptionCode.NOT_ALL_OBJECTS_DELETION.create(OXFolderUtility.getUserName(userId, this.ctx), OXFolderUtility.getFolderName(folderID, this.ctx), this.ctx.getContextId());
        }
        for (Integer special : specials) {
            if (null == special || special != folderID) continue;
            throw OXFolderExceptionCode.DELETE_DENIED.create(OXFolderUtility.getFolderName(folderID, this.ctx), this.ctx.getContextId());
        }
        TIntList subfolders = OXFolderSQL.getSubfolderIDs(delFolder.getObjectID(), this.readCon, this.ctx);
        if (subfolders.isEmpty()) {
            deleteableIDs.put(folderID, null);
            return;
        }
        TIntObjectHashMap subMap = new TIntObjectHashMap();
        int size = subfolders.size();
        for (int i = 0; i < size; ++i) {
            this.gatherDeleteableSubfoldersRecursively(subfolders.get(i), userId, userConfig, permissionIDs, (TIntObjectMap<TIntObjectMap<?>>)subMap, initParent, specials);
        }
        deleteableIDs.put(folderID, (Object)subMap);
    }

    @Override
    public void cleanUpTestFolders(int[] fuids, Context ctx) {
        for (int i = 0; i < fuids.length; ++i) {
            try {
                OXFolderSQL.hardDeleteOXFolder(fuids[i], ctx, null);
                ConditionTreeMapManagement.dropFor(ctx.getContextId());
                if (!FolderCacheManager.isEnabled() || !FolderCacheManager.isInitialized()) continue;
                try {
                    FolderCacheManager.getInstance().removeFolderObject(fuids[i], ctx);
                }
                catch (OXException e) {
                    LOG.warn((Object)e.getMessage(), (Throwable)e);
                }
                continue;
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private static Object getFolderValue(int folderField, FolderObject folder) {
        if (300 == folderField) {
            return folder.getFolderName();
        }
        if (1 == folderField) {
            return folder.getObjectID();
        }
        if (20 == folderField) {
            return folder.getParentFolderID();
        }
        if (301 == folderField) {
            return folder.getModule();
        }
        if (302 == folderField) {
            return folder.getType();
        }
        if (4 == folderField) {
            return folder.getCreationDate();
        }
        if (2 == folderField) {
            return folder.getCreatedBy();
        }
        if (5 == folderField) {
            return folder.getLastModified();
        }
        if (3 == folderField) {
            return folder.getModifiedBy();
        }
        throw new IllegalStateException("Unknown folder field ID: " + folder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OXException parseTruncated(DataTruncation exc, FolderObject folder, String tableName) {
        OXException fe;
        String[] fields = DBUtils.parseTruncatedFields(exc);
        OXException.Truncated[] truncateds = new OXException.Truncated[fields.length];
        StringBuilder sFields = new StringBuilder(fields.length << 3);
        for (int i = 0; i < fields.length; ++i) {
            sFields.append(fields[i]);
            sFields.append(", ");
            final int fieldId = fieldMapping.get(fields[i]);
            Object tmp = OXFolderManagerImpl.getFolderValue(fieldId, folder);
            final int valueLength = tmp instanceof String ? Charsets.getBytes((String)((String)tmp), (Charset)Charsets.UTF_8).length : 0;
            int tmp2 = -1;
            boolean closeReadCon = false;
            Connection readCon = this.readCon;
            if (readCon == null) {
                try {
                    readCon = DBPool.pickup(this.ctx);
                }
                catch (OXException e) {
                    LOG.error((Object)"A readable connection could not be fetched from pool", (Throwable)e);
                    return OXFolderExceptionCode.SQL_ERROR.create(exc, exc.getMessage());
                }
                closeReadCon = true;
            }
            try {
                tmp2 = DBUtils.getColumnSize(readCon, tableName, fields[i]);
            }
            catch (SQLException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                tmp2 = -1;
            }
            finally {
                if (closeReadCon) {
                    DBPool.closeReaderSilent(this.ctx, readCon);
                }
            }
            final int length = -1 == tmp2 ? 0 : tmp2;
            truncateds[i] = new OXException.Truncated(){

                public int getId() {
                    return fieldId;
                }

                public int getLength() {
                    return valueLength;
                }

                public int getMaxSize() {
                    return length;
                }
            };
        }
        sFields.setLength(sFields.length() - 2);
        if (truncateds.length > 0) {
            OXException.Truncated truncated = truncateds[0];
            fe = OXFolderExceptionCode.TRUNCATED.create(exc, sFields.toString(), truncated.getMaxSize(), truncated.getLength());
        } else {
            fe = OXFolderExceptionCode.TRUNCATED.create(exc, sFields.toString(), 0, 0);
        }
        for (OXException.Truncated truncated : truncateds) {
            fe.addProblematic((OXException.ProblematicAttribute)truncated);
        }
        return fe;
    }

    static {
        HashMap<String, Integer> fieldMapping = new HashMap<String, Integer>(9);
        fieldMapping.put("fuid", 1);
        fieldMapping.put("parent", 20);
        fieldMapping.put("fname", 300);
        fieldMapping.put("module", 301);
        fieldMapping.put("type", 302);
        fieldMapping.put("creating_date", 4);
        fieldMapping.put("created_from", 2);
        fieldMapping.put("changing_date", 5);
        fieldMapping.put("changed_from", 3);
        OXFolderManagerImpl.fieldMapping = Collections.unmodifiableMap(fieldMapping);
    }

    private final class DeleteValidatedFoldersProcedure
    implements TIntObjectProcedure<TIntObjectMap<?>> {
        public OXException error;
        private final long lastModified;
        private final int type;

        public DeleteValidatedFoldersProcedure(long lastModified, int type) {
            this.lastModified = lastModified;
            this.type = type;
        }

        public boolean execute(int folderId, TIntObjectMap<?> hashMap) {
            if (null == this.error) {
                try {
                    if (null != hashMap) {
                        TIntObjectMap<?> tmp = hashMap;
                        OXFolderManagerImpl.this.deleteValidatedFolders(tmp, this.lastModified, this.type);
                    }
                    OXFolderManagerImpl.this.deleteValidatedFolder(folderId, this.lastModified, this.type, false);
                    return true;
                }
                catch (OXException e) {
                    this.error = e;
                    return false;
                }
            }
            return false;
        }
    }
}

