/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class NonBlockingRWLock {
    private static final int DEFAULT = 10000;
    private final int maxConcurrentWrites;
    private final AtomicInteger writeCounter;
    private final Lock writeLock;

    public NonBlockingRWLock(boolean infiniteConcurrentWrites) {
        if (infiniteConcurrentWrites) {
            this.maxConcurrentWrites = -1;
            this.writeCounter = new AtomicInteger();
            this.writeLock = new ReentrantLock();
        } else {
            this.maxConcurrentWrites = 10000;
            this.writeCounter = new AtomicInteger();
            this.writeLock = new ReentrantLock();
        }
    }

    public NonBlockingRWLock(int maxConcurrentWrites) {
        this.maxConcurrentWrites = maxConcurrentWrites <= 0 ? -1 : maxConcurrentWrites;
        this.writeCounter = new AtomicInteger();
        this.writeLock = new ReentrantLock();
    }

    public int acquireRead() {
        int state = this.writeCounter.get();
        while ((state & 1) == 1) {
            state = this.writeCounter.get();
        }
        return state;
    }

    public void acquireWrite() {
        this.writeLock.lock();
        if (this.maxConcurrentWrites == -1) {
            this.writeCounter.getAndIncrement();
        } else {
            this.writeCounter.set(this.writeCounter.incrementAndGet() % this.maxConcurrentWrites);
        }
    }

    public boolean releaseRead(int prevState) {
        return prevState == this.writeCounter.get();
    }

    public void releaseWrite() {
        if (this.maxConcurrentWrites == -1) {
            this.writeCounter.getAndIncrement();
        } else {
            this.writeCounter.set(this.writeCounter.incrementAndGet() % this.maxConcurrentWrites);
        }
        this.writeLock.unlock();
    }
}

