/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.spamhandler.osgi;

import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.spamhandler.SpamHandler;
import com.openexchange.spamhandler.SpamHandlerRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public final class SpamHandlerServiceTracker
implements ServiceTrackerCustomizer<SpamHandler, SpamHandler> {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(SpamHandlerServiceTracker.class));
    private final BundleContext context;

    public SpamHandlerServiceTracker(BundleContext context) {
        this.context = context;
    }

    public SpamHandler addingService(ServiceReference<SpamHandler> reference) {
        Object registrationName;
        SpamHandler addedService = (SpamHandler)this.context.getService(reference);
        if (null == addedService) {
            LOG.warn((Object)"Added service is null!", new Throwable());
        }
        if (null == (registrationName = reference.getProperty("name"))) {
            LOG.error((Object)("Missing registration name in spam handler service: " + addedService.getClass().getName()));
            return addedService;
        }
        if (SpamHandlerRegistry.registerSpamHandler(registrationName.toString(), addedService)) {
            LOG.info((Object)new StringBuilder(64).append("Spam handler registered for name '").append(registrationName.toString()));
        } else {
            LOG.warn((Object)new StringBuilder(64).append("Spam handler could not be registered for name '").append(registrationName.toString()).append(". Another spam handler has already been registered for the same name."));
        }
        return addedService;
    }

    public void modifiedService(ServiceReference<SpamHandler> reference, SpamHandler service) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<SpamHandler> reference, SpamHandler service) {
        try {
            SpamHandlerRegistry.unregisterSpamHandler(service);
        }
        finally {
            this.context.ungetService(reference);
        }
    }
}

