/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.server.osgi;

import com.openexchange.groupware.update.tools.UpdateTaskMBeanInit;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.management.ManagementService;
import com.openexchange.monitoring.MonitorUtility;
import com.openexchange.osgi.BundleServiceTracker;
import com.openexchange.report.internal.ReportingInit;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.oxfolder.OXFolderProperties;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.osgi.framework.BundleContext;

public final class ManagementServiceTracker
extends BundleServiceTracker<ManagementService> {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(ManagementServiceTracker.class));
    private ObjectName gadObjectName;

    public ManagementServiceTracker(BundleContext context) {
        super(context, ManagementService.class);
    }

    protected void addingServiceInternal(ManagementService managementService) {
        ServerServiceRegistry.getInstance().addService(ManagementService.class, managementService);
        try {
            this.gadObjectName = OXFolderProperties.registerRestorerMBean(managementService);
            managementService.registerMBean(MonitorUtility.getObjectName((String)MailServletInterface.mailInterfaceMonitor.getClass().getName(), (boolean)true), (Object)MailServletInterface.mailInterfaceMonitor);
        }
        catch (MalformedObjectNameException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NullPointerException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        new ReportingInit(managementService).start();
        new UpdateTaskMBeanInit(managementService).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removedServiceInternal(ManagementService managementService) {
        new UpdateTaskMBeanInit(managementService).stop();
        new ReportingInit(managementService).stop();
        try {
            managementService.unregisterMBean(MonitorUtility.getObjectName((String)MailServletInterface.mailInterfaceMonitor.getClass().getName(), (boolean)true));
            OXFolderProperties.unregisterRestorerMBean(this.gadObjectName, managementService);
        }
        catch (MalformedObjectNameException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NullPointerException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.gadObjectName = null;
        }
    }
}

