/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.report.console;

import com.openexchange.management.console.JMXAuthenticatorImpl;
import com.openexchange.report.Constants;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public final class LastLoginTimeStampTool {
    private static final Options toolkitOptions;

    private static void printHelp() {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("lastlogintimestamp", toolkitOptions);
    }

    private LastLoginTimeStampTool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        PosixParser parser = new PosixParser();
        int userId = -1;
        int contextId = -1;
        String client = null;
        try {
            HashMap<String, JMXAuthenticatorImpl> environment;
            String val;
            CommandLine cmd = parser.parse(toolkitOptions, args);
            if (cmd.hasOption('h')) {
                LastLoginTimeStampTool.printHelp();
                System.exit(0);
            }
            int port = 9999;
            if (cmd.hasOption('p') && null != (val = cmd.getOptionValue('p'))) {
                try {
                    port = Integer.parseInt(val.trim());
                }
                catch (NumberFormatException e) {
                    System.err.println("Port parameter is not a number: " + val);
                    LastLoginTimeStampTool.printHelp();
                    System.exit(0);
                }
                if (port < 1 || port > 65535) {
                    System.err.println("Port parameter is out of range: " + val + ". Valid range is from 1 to 65535.");
                    LastLoginTimeStampTool.printHelp();
                    System.exit(0);
                }
            }
            if (!cmd.hasOption('t')) {
                System.err.println("Missing client identifier.");
                LastLoginTimeStampTool.printHelp();
                System.exit(0);
            }
            client = cmd.getOptionValue('t');
            String pattern = null;
            if (cmd.hasOption('d')) {
                pattern = cmd.getOptionValue('d');
            }
            if (!cmd.hasOption('c')) {
                System.err.println("Missing context identifier.");
                LastLoginTimeStampTool.printHelp();
                System.exit(0);
            }
            String optionValue = cmd.getOptionValue('c');
            try {
                contextId = Integer.parseInt(optionValue.trim());
            }
            catch (NumberFormatException e) {
                System.err.println("Context identifier parameter is not a number: " + optionValue);
                LastLoginTimeStampTool.printHelp();
                System.exit(0);
            }
            if (!cmd.hasOption('u')) {
                System.err.println("Missing user identifier.");
                LastLoginTimeStampTool.printHelp();
                System.exit(0);
            }
            optionValue = cmd.getOptionValue('u');
            try {
                userId = Integer.parseInt(optionValue.trim());
            }
            catch (NumberFormatException e) {
                System.err.println("User identifier parameter is not a number: " + optionValue);
                LastLoginTimeStampTool.printHelp();
                System.exit(0);
            }
            String jmxLogin = null;
            if (cmd.hasOption('l')) {
                jmxLogin = cmd.getOptionValue('l');
            }
            String jmxPassword = null;
            if (cmd.hasOption('s')) {
                jmxPassword = cmd.getOptionValue('s');
            }
            if (jmxLogin == null || jmxPassword == null) {
                environment = null;
            } else {
                environment = new HashMap<String, JMXAuthenticatorImpl>(1);
                environment.put("jmx.remote.authenticator", new JMXAuthenticatorImpl(jmxLogin, jmxPassword));
            }
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:" + port + "/server");
            JMXConnector jmxConnector = JMXConnectorFactory.connect(url, environment);
            try {
                MBeanServerConnection mbsc = jmxConnector.getMBeanServerConnection();
                Object[] params = new Object[]{userId, contextId, client};
                String[] signature = new String[]{Integer.TYPE.getName(), Integer.TYPE.getName(), String.class.getName()};
                Date ret = (Date)mbsc.invoke(Constants.OXTENDER_MONITOR_NAME, "getLastLoginTimeStamp", params, signature);
                SimpleDateFormat sdf = new SimpleDateFormat(null == pattern ? "EEE, d MMM yyyy HH:mm:ss z" : pattern, Locale.US);
                System.out.println(sdf.format(ret));
            }
            finally {
                jmxConnector.close();
            }
        }
        catch (ParseException e) {
            System.err.println("Unable to parse command line: " + e.getMessage());
            LastLoginTimeStampTool.printHelp();
        }
        catch (MalformedURLException e) {
            System.err.println("URL to connect to server is invalid: " + e.getMessage());
        }
        catch (IOException e) {
            System.err.println("Unable to communicate with the server: " + e.getMessage());
        }
        catch (InstanceNotFoundException e) {
            System.err.println("Instance is not available: " + e.getMessage());
        }
        catch (MBeanException e) {
            Throwable t = e.getCause();
            String message = null == t ? e.getMessage() : t.getMessage();
            System.err.println(null == message ? "Unexpected error." : "Unexpected error: " + message);
        }
        catch (ReflectionException e) {
            System.err.println("Problem with reflective type handling: " + e.getMessage());
        }
        catch (RuntimeException e) {
            System.err.println("Problem in runtime: " + e.getMessage());
            LastLoginTimeStampTool.printHelp();
        }
    }

    static {
        Options opts = new Options();
        opts.addOption("h", "help", false, "Prints a help text");
        opts.addOption("c", "context", true, "A valid context identifier");
        opts.addOption("u", "user", true, "A valid user identifier");
        opts.addOption("t", "client", true, "A client identifier; e.g \"com.openexchange.ox.gui.dhtml\"");
        opts.addOption("d", "datepattern", true, "The optional date pattern used for formatting retrieved time stamp; e.g \"EEE, d MMM yyyy HH:mm:ss Z\" would yield \"Wed, 4 Jul 2001 12:08:56 -0700\"");
        opts.addOption("p", "port", true, "The optional JMX port (default:9999)");
        opts.addOption("l", "login", true, "The optional JMX login (if JMX has authentication enabled)");
        opts.addOption("s", "password", true, "The optional JMX password (if JMX has authentication enabled)");
        toolkitOptions = opts;
    }
}

