/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.quota.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.quota.json.QuotaAJAXRequest;
import com.openexchange.quota.json.actions.AbstractQuotaAction;
import com.openexchange.server.ServiceLookup;
import org.json.JSONException;
import org.json.JSONObject;

@Action(method=RequestMethod.GET, name="mail", description="Get the mail usage data", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module.")}, responseDescription="A JSON Object containing the fields \"use\" and \"quota\". \"use\" represents the use mail quota and the field \"quota\" represents the maximum. -1 represents an unlimited quota.")
public final class MailAction
extends AbstractQuotaAction {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(MailAction.class));

    public MailAction(ServiceLookup services) {
        super(services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AJAXRequestResult perform(QuotaAJAXRequest req) throws OXException, JSONException {
        MailServletInterface mi = null;
        try {
            Object quotaInfo = null;
            try {
                mi = MailServletInterface.getInstance(req.getSession());
                quotaInfo = mi.getQuotas(new int[]{1, 2});
            }
            catch (OXException e) {
                if (MailExceptionCode.ACCOUNT_DOES_NOT_EXIST.equals(e)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)e.getMessage(), (Throwable)e);
                    }
                } else {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
                quotaInfo = new long[][]{{-1L, -1L}, {-1L, -1L}};
            }
            JSONObject data = new JSONObject();
            data.put("quota", quotaInfo[0][0] << 10);
            data.put("use", quotaInfo[0][1] << 10);
            data.put("countquota", quotaInfo[1][0]);
            data.put("countuse", quotaInfo[1][1]);
            AJAXRequestResult aJAXRequestResult = new AJAXRequestResult((Object)data, "json");
            return aJAXRequestResult;
        }
        finally {
            try {
                if (mi != null) {
                    mi.close(false);
                }
            }
            catch (OXException e) {
                LOG.error((Object)e);
            }
        }
    }
}

