/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount.json.actions;

import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailProviderRegistry;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.api.MailConfig;
import com.openexchange.mail.api.MailProvider;
import com.openexchange.mailaccount.Attribute;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountDescription;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.Tools;
import com.openexchange.secret.SecretService;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.net.URIDefaults;
import com.openexchange.tools.net.URIParser;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;

public abstract class AbstractMailAccountAction
implements AJAXActionService {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(AbstractMailAccountAction.class));
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private static final Pattern PAT = Pattern.compile(" *, *");

    protected AbstractMailAccountAction() {
    }

    protected static String getDefaultTreeIdentifier() {
        return FolderStorage.REAL_TREE_ID;
    }

    protected static List<ContentType> getDefaultAllowedModules() {
        return Collections.emptyList();
    }

    protected static int parseIntParameter(String parameterName, AJAXRequestData request) throws OXException {
        String tmp = request.getParameter(parameterName);
        if (null == tmp) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(parameterName);
        }
        return Tools.getUnsignedInteger(tmp);
    }

    protected static int[] parseIntArrayParameter(String parameterName, AJAXRequestData request) throws OXException {
        String tmp = request.getParameter(parameterName);
        if (null == tmp) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(parameterName);
        }
        String[] sa = PAT.split(tmp, 0);
        int[] columns = new int[sa.length];
        for (int i = 0; i < sa.length; ++i) {
            columns[i] = Tools.getUnsignedInteger(sa[i]);
        }
        return columns;
    }

    protected static int[] parseOptionalIntArrayParameter(String parameterName, AJAXRequestData request) {
        String tmp = request.getParameter(parameterName);
        if (null == tmp) {
            return new int[0];
        }
        String[] sa = PAT.split(tmp, 0);
        int[] columns = new int[sa.length];
        for (int i = 0; i < sa.length; ++i) {
            columns[i] = Tools.getUnsignedInteger(sa[i]);
        }
        return columns;
    }

    protected static boolean isUnifiedINBOXAccount(MailAccount mailAccount) {
        return AbstractMailAccountAction.isUnifiedINBOXAccount(mailAccount.getMailProtocol());
    }

    protected static boolean isUnifiedINBOXAccount(String mailProtocol) {
        return "unifiedinbox".equals(mailProtocol);
    }

    protected static void checkNeededFields(MailAccountDescription accountDescription) throws OXException {
        if (null == accountDescription.getMailServer()) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create("mail_url");
        }
        if (null == accountDescription.getLogin()) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create("login");
        }
        if (null == accountDescription.getPassword()) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create("password");
        }
    }

    protected static String getSecret(ServerSession session) throws OXException {
        try {
            return ServerServiceRegistry.getInstance().getService(SecretService.class, true).getSecret((Session)session);
        }
        catch (OXException e) {
            throw new OXException(e);
        }
    }

    protected static boolean isDefaultMailAccount(MailAccount mailAccount) {
        return mailAccount.isDefaultAccount() || 0 == mailAccount.getId();
    }

    protected static boolean isDefaultMailAccount(MailAccountDescription mailAccount) {
        return 0 == mailAccount.getId();
    }

    protected static List<Attribute> getColumns(String colString) {
        LinkedList<Attribute> attributes = null;
        if (colString != null && !"".equals(colString.trim())) {
            attributes = new LinkedList<Attribute>();
            for (String col : colString.split("\\s*,\\s*")) {
                if ("".equals(col)) continue;
                attributes.add(Attribute.getById(Integer.parseInt(col)));
            }
            return attributes;
        }
        return Arrays.asList(Attribute.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> getMailAccess(MailAccountDescription accountDescription, ServerSession session) throws OXException {
        MailAccess<?, ?> mailAccess;
        String mailServerURL = accountDescription.generateMailServerURL();
        MailProvider mailProvider = MailProviderRegistry.getMailProviderByURL(mailServerURL);
        if (null == mailProvider) {
            if (DEBUG) {
                LOG.debug((Object)("Validating mail account failed. No mail provider found for URL: " + mailServerURL));
            }
            return null;
        }
        session.setParameter("mail-account.request", "validate");
        try {
            URI uri;
            MailAccess<?, ?> mailAccess2 = mailProvider.createNewMailAccess(session);
            MailConfig mailConfig = mailAccess2.getMailConfig();
            mailConfig.setLogin(accountDescription.getLogin());
            mailConfig.setPassword(accountDescription.getPassword());
            try {
                uri = URIParser.parse(mailServerURL, URIDefaults.IMAP);
            }
            catch (URISyntaxException e) {
                throw MailExceptionCode.URI_PARSE_FAILED.create(e, mailServerURL);
            }
            mailConfig.setServer(uri.getHost());
            mailConfig.setPort(uri.getPort());
            mailConfig.setSecure(accountDescription.isMailSecure());
            mailAccess2.setCacheable(false);
            mailAccess = mailAccess2;
        }
        catch (Throwable throwable) {
            try {
                session.setParameter("mail-account.request", null);
                throw throwable;
            }
            catch (OXException e) {
                throw new OXException(e);
            }
        }
        session.setParameter("mail-account.request", null);
        return mailAccess;
    }

    protected static MailAccount checkFullNames(MailAccount account, MailAccountStorageService storageService, ServerSession session) throws OXException {
        return AbstractMailAccountAction.checkFullNames(account, storageService, session, null);
    }

    public static MailAccount checkFullNames(MailAccount account, MailAccountStorageService storageService, ServerSession session, Connection con) throws OXException {
        return Tools.checkFullNames(account, storageService, session, con);
    }
}

