/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.search;

import com.openexchange.exception.OXException;
import com.openexchange.mail.MailField;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.search.BooleanTerm;
import com.openexchange.mail.search.SearchTermVisitor;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.mail.Message;

public abstract class SearchTerm<T>
implements Serializable {
    private static final long serialVersionUID = -6443057148350714347L;
    private static final String UNCHECKED = "unchecked";
    private static final Pattern PAT_SPLIT = Pattern.compile("\\?|\\*");

    public abstract T getPattern();

    public abstract void accept(SearchTermVisitor var1);

    public abstract void addMailField(Collection<MailField> var1);

    public abstract boolean matches(Message var1) throws OXException;

    public abstract boolean matches(MailMessage var1) throws OXException;

    public abstract javax.mail.search.SearchTerm getJavaMailSearchTerm();

    public abstract javax.mail.search.SearchTerm getNonWildcardJavaMailSearchTerm();

    public SearchTerm<?> filter(Class<? extends SearchTerm>[] filter) {
        HashSet<Class<? extends SearchTerm>> filterSet = new HashSet<Class<? extends SearchTerm>>(Arrays.asList(filter));
        return this.filter(filterSet);
    }

    public SearchTerm<?> filter(Set<Class<? extends SearchTerm>> filterSet) {
        if (filterSet.contains(this.getClass())) {
            return BooleanTerm.FALSE;
        }
        return this;
    }

    public boolean isAscii() {
        return true;
    }

    public boolean containsWildcard() {
        return false;
    }

    protected static final boolean isAscii(String s) {
        char[] chars = s.toCharArray();
        boolean isAscii = true;
        for (int i = 0; i < chars.length && isAscii; ++i) {
            isAscii = chars[i] < '\u0080';
        }
        return isAscii;
    }

    protected static final String getNonWildcardPart(String pattern) {
        String[] parts = PAT_SPLIT.split(pattern);
        if (parts.length == 0) {
            return "";
        }
        if (parts.length == 1) {
            return parts[0];
        }
        int mlen = -1;
        int index = -1;
        for (int i = 0; i < parts.length; ++i) {
            int len = parts[i].length();
            if (len <= mlen) continue;
            mlen = len;
            index = i;
        }
        return parts[index];
    }

    protected static Pattern toRegex(String pattern) {
        return Pattern.compile(SearchTerm.wildcardToRegex(pattern), 2);
    }

    private static String wildcardToRegex(String wildcard) {
        StringBuilder s = new StringBuilder(wildcard.length());
        s.append('^');
        int len = wildcard.length();
        for (int i = 0; i < len; ++i) {
            char c = wildcard.charAt(i);
            if (c == '*') {
                s.append(".*");
                continue;
            }
            if (c == '?') {
                s.append('.');
                continue;
            }
            if (c == '(' || c == ')' || c == '[' || c == ']' || c == '$' || c == '^' || c == '.' || c == '{' || c == '}' || c == '|' || c == '\\') {
                s.append('\\');
                s.append(c);
                continue;
            }
            s.append(c);
        }
        s.append('$');
        return s.toString();
    }
}

