/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.osgi;

import com.openexchange.exception.OXException;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailProviderRegistry;
import com.openexchange.mail.api.MailProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public final class MailProviderServiceTracker
implements ServiceTrackerCustomizer<MailProvider, MailProvider> {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(MailProviderServiceTracker.class));
    private final BundleContext context;

    public MailProviderServiceTracker(BundleContext context) {
        this.context = context;
    }

    public MailProvider addingService(ServiceReference<MailProvider> reference) {
        MailProvider addedService = (MailProvider)this.context.getService(reference);
        Object protocol = reference.getProperty("protocol");
        if (null == protocol) {
            LOG.error((Object)("Missing protocol in mail provider service: " + addedService.getClass().getName()));
            this.context.ungetService(reference);
            return null;
        }
        try {
            if (!MailProviderRegistry.registerMailProvider(protocol.toString(), addedService)) {
                LOG.warn((Object)new StringBuilder(64).append("Mail provider for protocol '").append(protocol.toString()).append("' could not be added.").append(" Another provider which supports the protocol has already been registered."));
                this.context.ungetService(reference);
                return null;
            }
            LOG.info((Object)new StringBuilder(64).append("Mail provider for protocol '").append(protocol.toString()).append("' successfully registered"));
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            this.context.ungetService(reference);
            return null;
        }
        return addedService;
    }

    public void modifiedService(ServiceReference<MailProvider> reference, MailProvider service) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<MailProvider> reference, MailProvider service) {
        if (null != service) {
            try {
                try {
                    MailProvider provider = service;
                    MailProviderRegistry.unregisterMailProvider(provider);
                    LOG.info((Object)new StringBuilder(64).append("Mail provider for protocol '").append(provider.getProtocol().toString()).append("' successfully unregistered"));
                }
                catch (OXException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            finally {
                this.context.ungetService(reference);
            }
        }
    }
}

