/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime.utils;

import com.openexchange.ajax.requesthandler.DefaultDispatcherPrefixService;
import com.openexchange.exception.OXException;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.ContentDisposition;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.HeaderName;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.MimeMailExceptionCode;
import com.openexchange.mail.mime.PlainTextAddress;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.mime.dataobjects.MimeMailMessage;
import com.openexchange.mail.mime.dataobjects.MimeMailPart;
import com.openexchange.mail.mime.utils.ImageMatcher;
import com.openexchange.mail.utils.CharsetDetector;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import com.sun.mail.imap.protocol.BODYSTRUCTURE;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MailDateFormat;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.net.QuotedPrintableCodec;
import org.apache.james.mime4j.io.LineReaderInputStreamAdaptor;
import org.apache.james.mime4j.stream.DefaultFieldBuilder;
import org.apache.james.mime4j.stream.RawField;
import org.apache.james.mime4j.util.ByteArrayBuffer;

public final class MimeMessageUtility {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(MimeMessageUtility.class));
    private static final boolean TRACE = LOG.isTraceEnabled();
    private static final Set<HeaderName> ENCODINGS;
    private static final MailDateFormat MAIL_DATE_FORMAT;
    private static final ConcurrentMap<String, Future<MailDateFormat>> MDF_MAP;
    private static final Pattern PATTERN_EMBD_IMG;
    private static final Pattern PATTERN_EMBD_IMG_ALT;
    private static final String IMAGE_ALIAS_APPENDIX = "image";
    private static final String FILE_ALIAS_APPENDIX = "file";
    private static final String PARAM_NAME = "name";
    private static final String MULTI_SUBTYPE_ALTERNATIVE = "ALTERNATIVE";
    private static final int ENCODED_WORD_LEN = 75;
    private static final Pattern ENC_PATTERN;
    private static final Pattern SPLITS;
    private static final Pattern PATTERN_REPLACE;
    private static final String RFC822 = "()<>@,;:\\\".[]";
    private static final int USED_CT = 14;
    private static final int USED_CD = 21;
    private static final Pattern PAT_ENC_WORDS;
    private static final int BUFSIZE = 8192;
    private static final String X_ORIGINAL_HEADERS = "x-original-headers";

    private MimeMessageUtility() {
    }

    public static boolean shouldRetry(OXException e) {
        if (MailExceptionCode.MAIL_NOT_FOUND.equals(e) || MimeMailExceptionCode.FOLDER_CLOSED.equals(e)) {
            return true;
        }
        if (MailExceptionCode.IO_ERROR.equals(e)) {
            Throwable cause = e.getCause();
            return cause instanceof IOException && "no content".equals(cause.getMessage().toLowerCase(Locale.ENGLISH));
        }
        if (MimeMailExceptionCode.MESSAGING_ERROR.equals(e)) {
            Throwable cause = e.getCause();
            return cause instanceof MessagingException && "failed to fetch headers".equals(cause.getMessage().toLowerCase(Locale.ENGLISH));
        }
        return false;
    }

    public static MailDateFormat getDefaultMailDateFormat() {
        return MAIL_DATE_FORMAT;
    }

    public static MailDateFormat getMailDateFormat(Session session) throws OXException {
        User user = session instanceof ServerSession ? ((ServerSession)session).getUser() : UserStorage.getStorageUser(session.getUserId(), session.getContextId());
        return MimeMessageUtility.getMailDateFormat(user.getTimeZone());
    }

    public static MailDateFormat getMailDateFormat(final String timeZoneId) throws OXException {
        FutureTask<MailDateFormat> ft;
        FutureTask<MailDateFormat> future = (FutureTask<MailDateFormat>)MDF_MAP.get(timeZoneId);
        if (null == future && null == (future = (Future)MDF_MAP.putIfAbsent(timeZoneId, ft = new FutureTask<MailDateFormat>(new Callable<MailDateFormat>(){

            @Override
            public MailDateFormat call() throws Exception {
                MailDateFormat mdf = new MailDateFormat();
                mdf.setTimeZone(TimeZoneUtils.getTimeZone(timeZoneId));
                return mdf;
            }
        })))) {
            future = ft;
            ft.run();
        }
        try {
            return (MailDateFormat)future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            throw MailExceptionCode.UNEXPECTED_ERROR.create(cause, cause.getMessage());
        }
    }

    public static boolean isEmptyHeader(String[] headers) {
        if (null == headers || 0 == headers.length) {
            return true;
        }
        boolean isEmpty = true;
        for (int i = 0; isEmpty && i < headers.length; ++i) {
            isEmpty = MimeMessageUtility.isEmpty(headers[i]);
        }
        return isEmpty;
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Character.isWhitespace(string.charAt(i));
        }
        return isWhitespace;
    }

    public static boolean hasEmbeddedImages(CharSequence htmlContent) {
        return PATTERN_EMBD_IMG.matcher(htmlContent).find() || PATTERN_EMBD_IMG_ALT.matcher(htmlContent).find();
    }

    public static List<String> getContentIDs(CharSequence htmlContent) {
        LinkedList<String> retval = new LinkedList<String>();
        Matcher m = PATTERN_EMBD_IMG.matcher(htmlContent);
        while (m.find()) {
            retval.add(m.group(2));
        }
        m = PATTERN_EMBD_IMG_ALT.matcher(htmlContent);
        while (m.find()) {
            retval.add(m.group(2));
        }
        return retval;
    }

    public static boolean equalsCID(String contentId1, String contentId2) {
        if (null != contentId1 && null != contentId2) {
            int length1 = contentId1.length();
            int length2 = contentId2.length();
            String cid1 = length1 > 0 && contentId1.charAt(0) == '<' ? contentId1.substring(1, length1 - 1) : contentId1;
            return cid1.equalsIgnoreCase(length2 > 0 && contentId2.charAt(0) == '<' ? contentId2.substring(1, length2 - 1) : contentId2);
        }
        return false;
    }

    public static boolean isValidImageUri(String imageTag) {
        String prefix;
        if (MimeMessageUtility.isEmpty(imageTag)) {
            return false;
        }
        String tmp = imageTag.toLowerCase(Locale.US);
        String srcStart = "src=\"";
        int pos = tmp.indexOf("src=\"");
        int fromIndex = pos + "src=\"".length();
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if ((prefix = DefaultDispatcherPrefixService.getInstance().getPrefix()).charAt(0) == '/') {
            prefix = prefix.substring(1);
        }
        return tmp.indexOf(prefix + IMAGE_ALIAS_APPENDIX, fromIndex) >= 0 || tmp.indexOf(prefix + FILE_ALIAS_APPENDIX, fromIndex) >= 0;
    }

    public static boolean hasReferencedLocalImages(CharSequence htmlContent) {
        ImageMatcher m = ImageMatcher.matcher(htmlContent);
        if (m.find()) {
            ManagedFileManagement mfm = ServerServiceRegistry.getInstance().getService(ManagedFileManagement.class);
            do {
                String mid;
                if (null == (mid = m.getManagedFileId())) continue;
                mfm.contains(mid);
            } while (m.find());
            return true;
        }
        return false;
    }

    public static String getRealFilename(MailPart part) {
        if (part.getFileName() != null) {
            return part.getFileName();
        }
        String hdr = part.getFirstHeader("Content-Disposition");
        if (hdr == null) {
            return MimeMessageUtility.getContentTypeFilename(part);
        }
        try {
            String retval = new ContentDisposition(hdr).getFilenameParameter();
            if (retval == null) {
                return MimeMessageUtility.getContentTypeFilename(part);
            }
            return retval;
        }
        catch (OXException e) {
            return MimeMessageUtility.getContentTypeFilename(part);
        }
    }

    private static String getContentTypeFilename(MailPart part) {
        if (part.containsContentType()) {
            return part.getContentType().getParameter(PARAM_NAME);
        }
        String hdr = part.getFirstHeader("Content-Type");
        if (hdr == null || hdr.length() == 0) {
            return null;
        }
        try {
            return new ContentType(hdr).getParameter(PARAM_NAME);
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static boolean hasAttachments(Multipart mp, String subtype) throws MessagingException, OXException, IOException {
        if (MULTI_SUBTYPE_ALTERNATIVE.equalsIgnoreCase(subtype)) {
            if (mp.getCount() > 2) {
                return true;
            }
            return MimeMessageUtility.hasAttachments0(mp);
        }
        if (mp.getCount() > 1) {
            return true;
        }
        return MimeMessageUtility.hasAttachments0(mp);
    }

    private static boolean hasAttachments0(Multipart mp) throws MessagingException, OXException, IOException {
        boolean found = false;
        int count = mp.getCount();
        ContentType ct = new ContentType();
        for (int i = 0; i < count && !found; ++i) {
            BodyPart part = mp.getBodyPart(i);
            String[] tmp = part.getHeader("Content-Type");
            if (tmp != null && tmp.length > 0) {
                ct.setContentType(MimeMessageUtility.unfold(tmp[0]));
            } else {
                ct.setContentType("text/plain; charset=us-ascii");
            }
            if (!ct.isMimeType("multipart/*")) continue;
            found |= MimeMessageUtility.hasAttachments((Multipart)part.getContent(), ct.getSubType());
        }
        return found;
    }

    public static boolean hasAttachments(BODYSTRUCTURE bodystructure) {
        if (bodystructure.isMulti()) {
            if (MULTI_SUBTYPE_ALTERNATIVE.equalsIgnoreCase(bodystructure.subtype)) {
                if (bodystructure.bodies.length > 2) {
                    return true;
                }
                return MimeMessageUtility.hasAttachments0(bodystructure);
            }
            if (bodystructure.bodies.length > 1) {
                return true;
            }
            return MimeMessageUtility.hasAttachments0(bodystructure);
        }
        return false;
    }

    private static boolean hasAttachments0(BODYSTRUCTURE bodystructure) {
        boolean found = false;
        for (int i = 0; i < bodystructure.bodies.length && !found; found |= MimeMessageUtility.hasAttachments(bodystructure.bodies[i]), ++i) {
        }
        return found;
    }

    public static String decodeEnvelopeSubject(String subject) {
        if (null == subject) {
            return "";
        }
        char[] chars = MimeMessageUtility.checkNonAscii(subject).toCharArray();
        StringBuilder sb = new StringBuilder(chars.length);
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if ('\t' == c || ' ' == c) {
                while (i + 1 < chars.length && ' ' == chars[i + 1]) {
                    ++i;
                }
                sb.append(' ');
                continue;
            }
            if ('\r' == c || '\n' == c) continue;
            sb.append(c);
        }
        return MimeMessageUtility.decodeEnvelopeHeader0(sb.toString());
    }

    public static String decodeEnvelopeHeader(String value) {
        return MimeMessageUtility.decodeEnvelopeHeader0(MimeMessageUtility.checkNonAscii(value));
    }

    private static String decodeEnvelopeHeader0(String value) {
        int length = value.length();
        if (length > 75 && value.indexOf(13) < 0 && value.indexOf(10) < 0) {
            int i;
            StringBuilder sb = new StringBuilder(length).append(value);
            String pattern = "?= =?";
            while ((i = sb.indexOf("?= =?")) >= 0) {
                sb.deleteCharAt(i + 2);
            }
            return MimeMessageUtility.decodeMultiEncodedHeader0(sb.toString(), false);
        }
        return MimeMessageUtility.decodeMultiEncodedHeader0(value, true);
    }

    public static String decodeMultiEncodedHeader(String headerValue) {
        if (null == headerValue || headerValue.indexOf("=?") < 0) {
            return MimeMessageUtility.unfold(headerValue);
        }
        return MimeMessageUtility.decodeMultiEncodedHeader0(MimeMessageUtility.checkNonAscii(headerValue), true);
    }

    private static String decodeMultiEncodedHeader0(String headerValue, boolean unfold) {
        String hdrVal;
        if (headerValue == null) {
            return null;
        }
        String string = hdrVal = unfold ? MimeMessageUtility.unfold(headerValue) : headerValue;
        if (hdrVal.indexOf("=?") < 0) {
            return hdrVal;
        }
        Matcher m = ENC_PATTERN.matcher(hdrVal);
        if (m.find()) {
            StringBuilder sb = new StringBuilder(hdrVal.length());
            int lastMatch = 0;
            do {
                try {
                    String decodeWord;
                    String encodedWord;
                    sb.append(hdrVal.substring(lastMatch, m.start()));
                    String charset = m.group(1);
                    if (MessageUtility.isBig5(charset)) {
                        encodedWord = m.group();
                        decodeWord = MimeUtility.decodeWord((String)encodedWord);
                        if (decodeWord.indexOf(65533) >= 0) {
                            decodeWord = MimeUtility.decodeWord((String)encodedWord.replaceFirst(Pattern.quote(charset), "Big5-HKSCS"));
                        }
                        sb.append(decodeWord);
                    } else if (MessageUtility.isGB2312(charset)) {
                        encodedWord = m.group();
                        decodeWord = MimeUtility.decodeWord((String)encodedWord);
                        if (decodeWord.indexOf(65533) >= 0) {
                            decodeWord = MimeUtility.decodeWord((String)encodedWord.replaceFirst(Pattern.quote(charset), "GB18030"));
                        }
                        sb.append(decodeWord);
                    } else {
                        sb.append(MimeUtility.decodeWord((String)m.group()));
                    }
                    lastMatch = m.end();
                }
                catch (UnsupportedEncodingException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Unsupported character-encoding in encoded-word: " + m.group()), (Throwable)e);
                    }
                    sb.append(MimeMessageUtility.handleUnsupportedEncoding(m));
                    lastMatch = m.end();
                }
                catch (ParseException e) {
                    return MimeMessageUtility.decodeMultiEncodedHeaderSafe(headerValue);
                }
            } while (m.find());
            sb.append(hdrVal.substring(lastMatch));
            return sb.toString();
        }
        return hdrVal;
    }

    private static String handleUnsupportedEncoding(Matcher m) {
        byte[] rawBytes;
        String asciiText = m.group(3);
        String transferEncoding = m.group(2);
        if ("Q".equalsIgnoreCase(transferEncoding)) {
            try {
                rawBytes = QuotedPrintableCodec.decodeQuotedPrintable((byte[])asciiText.getBytes(Charsets.US_ASCII));
            }
            catch (DecoderException e) {
                LOG.warn((Object)("Cannot decode quoted-printable: " + e.getMessage()), (Throwable)e);
                return asciiText;
            }
        } else if ("B".equalsIgnoreCase(transferEncoding)) {
            rawBytes = Base64.decodeBase64((byte[])asciiText.getBytes(Charsets.US_ASCII));
        } else {
            LOG.warn((Object)("Unknown transfer-encoding: " + transferEncoding));
            return asciiText;
        }
        String detectedCharset = CharsetDetector.detectCharset((ByteArrayInputStream)new UnsynchronizedByteArrayInputStream(rawBytes));
        try {
            return new String(rawBytes, Charsets.forName((String)detectedCharset));
        }
        catch (UnsupportedCharsetException e) {
            LOG.warn((Object)("Unknown character-encoding: " + detectedCharset));
            return asciiText;
        }
    }

    public static String checkNonAscii(String rawHeader) {
        if (null == rawHeader || MimeMessageUtility.isAscii(rawHeader)) {
            return rawHeader;
        }
        return MimeMessageUtility.convertNonAscii(rawHeader);
    }

    private static String convertNonAscii(String rawHeader) {
        int length = rawHeader.length();
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)rawHeader.charAt(i);
        }
        try {
            String detectCharset = CharsetDetector.detectCharset((ByteArrayInputStream)new UnsynchronizedByteArrayInputStream(bytes));
            return MessageUtility.readStream((InputStream)new UnsynchronizedByteArrayInputStream(bytes), detectCharset);
        }
        catch (IOException e) {
            return rawHeader;
        }
    }

    private static boolean isAscii(String s) {
        int length = s.length();
        boolean isAscci = true;
        for (int i = 0; i < length && isAscci; isAscci &= s.charAt(i) < '\u0080', ++i) {
        }
        return isAscci;
    }

    private static String decodeMultiEncodedHeaderSafe(String headerValue) {
        if (headerValue == null) {
            return null;
        }
        String hdrVal = MimeMessageUtility.unfold(headerValue);
        Matcher m = ENC_PATTERN.matcher(hdrVal);
        if (m.find()) {
            StringBuilder sb = new StringBuilder(hdrVal.length());
            StringBuilder tmp = null;
            int lastMatch = 0;
            do {
                try {
                    sb.append(hdrVal.substring(lastMatch, m.start()));
                    if ("Q".equalsIgnoreCase(m.group(2))) {
                        String charset = m.group(1);
                        String preparedEWord = MimeMessageUtility.prepareQEncodedValue(m.group(3), charset);
                        if (null == tmp) {
                            tmp = new StringBuilder(preparedEWord.length() + 16);
                        } else {
                            tmp.setLength(0);
                        }
                        tmp.append("=?").append(charset).append('?').append('Q').append('?').append(preparedEWord).append("?=");
                        sb.append(MimeUtility.decodeWord((String)tmp.toString()));
                    } else if ("B".equalsIgnoreCase(m.group(2))) {
                        try {
                            sb.append(MimeUtility.decodeWord((String)m.group()));
                        }
                        catch (ParseException e) {
                            sb.append(new String(Base64.decodeBase64((byte[])m.group(3).getBytes(Charsets.US_ASCII)), Charsets.forName((String)m.group(1))));
                        }
                    } else {
                        sb.append(MimeUtility.decodeWord((String)m.group()));
                    }
                    lastMatch = m.end();
                }
                catch (UnsupportedEncodingException e) {
                    LOG.warn((Object)("Unsupported character-encoding in encoded-word: " + m.group()), (Throwable)e);
                    sb.append(m.group());
                    lastMatch = m.end();
                }
                catch (ParseException e) {
                    LOG.warn((Object)("String is not an encoded-word as per RFC 2047: " + m.group()), (Throwable)e);
                    sb.append(m.group());
                    lastMatch = m.end();
                }
            } while (m.find());
            sb.append(hdrVal.substring(lastMatch));
            return sb.toString();
        }
        return hdrVal;
    }

    private static String prepareQEncodedValue(String eword, String charset) {
        int len = eword.length();
        int pos = eword.indexOf(61);
        if (pos == -1) {
            return eword;
        }
        StringBuilder sb = new StringBuilder(len);
        int prev = 0;
        do {
            int pos1 = pos + 1;
            int pos2 = pos + 2;
            if (pos2 < len) {
                int nextPos;
                char c1 = eword.charAt(pos1);
                char c2 = eword.charAt(pos2);
                if (MimeMessageUtility.isHex(c1) && MimeMessageUtility.isHex(c2)) {
                    int pos3 = pos + 3;
                    nextPos = pos3 > len ? len : pos3;
                    sb.append(eword.substring(prev, nextPos));
                } else {
                    nextPos = pos1;
                    if (ENCODINGS.contains(HeaderName.valueOf(charset))) {
                        sb.append(eword.substring(prev, pos)).append("=3D");
                    } else {
                        sb.append(eword.substring(prev, pos)).append(MimeMessageUtility.qencode('=', charset));
                    }
                }
                prev = nextPos;
                pos = nextPos < len ? eword.indexOf(61, nextPos) : -1;
                continue;
            }
            if (prev < len) {
                sb.append(eword.substring(prev));
                prev = len;
            }
            pos = -1;
        } while (pos != -1);
        if (prev < len) {
            sb.append(eword.substring(prev));
        }
        return sb.toString();
    }

    private static boolean isHex(char c) {
        return '0' <= c && c <= '9' || 'A' <= c && c <= 'F' || 'a' <= c && c <= 'f';
    }

    private static String qencode(char toEncode, String charset) {
        if (!Charset.isSupported(charset)) {
            return String.valueOf(toEncode);
        }
        StringBuilder retval = new StringBuilder(4);
        try {
            byte[] bytes = String.valueOf(toEncode).getBytes(charset);
            for (int j = 0; j < bytes.length; ++j) {
                retval.append('=').append(Integer.toHexString(bytes[j] & 0xFF).toUpperCase(Locale.ENGLISH));
            }
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return retval.toString();
    }

    public static String getFileName(MailPart mailPart) {
        String fileName = mailPart.getContentDisposition().getFilenameParameter();
        if (MimeMessageUtility.isEmpty(fileName)) {
            fileName = mailPart.getContentType().getNameParameter();
        }
        return MimeMessageUtility.decodeMultiEncodedHeader(fileName);
    }

    public static InternetAddress[] parseAddressList(String addresslist, boolean strict) {
        try {
            return MimeMessageUtility.parseAddressList(addresslist, strict, false);
        }
        catch (AddressException e) {
            throw new IllegalStateException("Unexpected exception.", e);
        }
    }

    private static List<String> splitAddrs(String addrs) {
        String[] sa = SPLITS.split(addrs, 0);
        ArrayList<String> ret = new ArrayList<String>(sa.length);
        StringBuilder tmp = new StringBuilder(24);
        for (String string : sa) {
            String trim = string.trim();
            if (trim.charAt(0) == '\"') {
                tmp.setLength(0);
                tmp.append(trim).append(", ");
                continue;
            }
            if (trim.indexOf("\" <") >= 0) {
                tmp.append(trim);
                ret.add(tmp.toString());
                tmp.setLength(0);
                continue;
            }
            if (tmp.length() > 0) {
                tmp.append(string).append(", ");
                continue;
            }
            ret.add(string);
        }
        return ret;
    }

    public static InternetAddress[] parseAddressList(String addresslist, boolean strict, boolean failOnError) throws AddressException {
        if (null == addresslist) {
            return new InternetAddress[0];
        }
        String al = MimeMessageUtility.replaceWithComma(MimeMessageUtility.unfold(addresslist));
        InternetAddress[] addrs = null;
        try {
            addrs = QuotedInternetAddress.parse(al, strict);
        }
        catch (AddressException e) {
            List<String> sAddrs = MimeMessageUtility.splitAddrs(al);
            try {
                ArrayList<QuotedInternetAddress> addrList = new ArrayList<QuotedInternetAddress>(sAddrs.size());
                for (String sAddr : sAddrs) {
                    QuotedInternetAddress tmp = new QuotedInternetAddress(sAddr, strict);
                    if (TRACE) {
                        LOG.trace((Object)tmp);
                    }
                    addrList.add(tmp);
                }
                return addrList.toArray(new InternetAddress[0]);
            }
            catch (AddressException e1) {
                if (failOnError) {
                    for (String sAddr : sAddrs) {
                        QuotedInternetAddress tmp = new QuotedInternetAddress(sAddr, strict);
                        if (!TRACE) continue;
                        LOG.trace((Object)tmp);
                    }
                    throw e;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)new StringBuilder(128).append("Internet addresses could not be properly parsed, ").append("using plain addresses' string representation instead.").toString(), (Throwable)e);
                }
                addrs = PlainTextAddress.getAddresses(MimeMessageUtility.splitAddrs(al).toArray(new String[0]));
            }
        }
        try {
            for (int i = 0; i < addrs.length; ++i) {
                addrs[i].setPersonal(addrs[i].getPersonal(), MailProperties.getInstance().getDefaultMimeCharset());
            }
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return addrs;
    }

    private static String replaceWithComma(String addressList) {
        Matcher m = PATTERN_REPLACE.matcher(addressList);
        if (m.find()) {
            StringBuilder sb = new StringBuilder(addressList.length());
            int lastMatch = 0;
            do {
                sb.append(addressList.substring(lastMatch, m.start()));
                sb.append(m.group(1)).append(m.group(2)).append(',').append(m.group(4));
                lastMatch = m.end();
            } while (m.find());
            sb.append(addressList.substring(lastMatch));
            return sb.toString();
        }
        return addressList;
    }

    public static String quotePersonal(String personal) {
        return MimeMessageUtility.quotePhrase(personal, true);
    }

    public static String quotePhrase(String phrase, boolean encode) {
        if (null == phrase || phrase.length() == 0) {
            return phrase;
        }
        char[] chars = phrase.toCharArray();
        int len = chars.length;
        if ('\"' == chars[0] && '\"' == chars[len - 1]) {
            return phrase;
        }
        boolean needQuoting = false;
        for (int i = 0; !needQuoting && i < len; ++i) {
            char c = chars[i];
            needQuoting = c == '\"' || c == '\\' || c < ' ' && c != '\r' && c != '\n' && c != '\t' || c >= '\u007f' || RFC822.indexOf(c) >= 0;
        }
        try {
            if (!needQuoting) {
                return encode ? MimeUtility.encodeWord((String)phrase) : phrase;
            }
            String replaced = phrase.replaceAll("\\\\", "\\\\\\\\").replaceAll("\"", "\\\\\\\"");
            return new StringBuilder(len + 2).append('\"').append(encode ? MimeUtility.encodeWord((String)replaced) : replaced).append('\"').toString();
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)("Unsupported encoding in a message detected and monitored: \"" + e.getMessage() + '\"'), (Throwable)e);
            MailServletInterface.mailInterfaceMonitor.addUnsupportedEncodingExceptions(e.getMessage());
            return phrase;
        }
    }

    public static String foldContentType(String contentType) {
        return MimeMessageUtility.fold(14, contentType);
    }

    public static String foldContentDisposition(String contentDisposition) {
        return MimeMessageUtility.fold(21, contentDisposition);
    }

    public static String fold(int used, String foldMe) {
        char c;
        int end;
        for (end = foldMe.length() - 1; end >= 0 && ((c = foldMe.charAt(end)) == ' ' || c == '\t' || c == '\r' || c == '\n'); --end) {
        }
        String s = end != foldMe.length() - 1 ? foldMe.substring(0, end + 1) : foldMe;
        if (used + s.length() <= 76) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() + 4);
        char lastc = '\u0000';
        int usedChars = used;
        while (usedChars + s.length() > 76) {
            int lastspace = -1;
            for (int i = 0; i < s.length() && (lastspace == -1 || usedChars + i <= 76); ++i) {
                c = s.charAt(i);
                if ((c == ' ' || c == '\t') && lastc != ' ' && lastc != '\t') {
                    lastspace = i;
                }
                lastc = c;
            }
            if (lastspace == -1) {
                sb.append(s);
                s = "";
                usedChars = 0;
                break;
            }
            sb.append(s.substring(0, lastspace));
            sb.append("\r\n");
            lastc = s.charAt(lastspace);
            sb.append(lastc);
            s = s.substring(lastspace + 1);
            usedChars = 1;
        }
        sb.append(s);
        return sb.toString();
    }

    public static String unfold(String headerLine) {
        if (null == headerLine) {
            return null;
        }
        StringBuilder sb = null;
        int i = headerLine.indexOf(13);
        if (i >= 0 || (i = headerLine.indexOf(10)) >= 0) {
            String s;
            if (headerLine.indexOf("=?") < 0) {
                s = headerLine;
            } else {
                s = MimeMessageUtility.unfoldEncodedWords(headerLine);
                i = s.indexOf(13);
                if (i < 0 && (i = s.indexOf(10)) < 0) {
                    return s;
                }
            }
            do {
                int start = i++;
                int len = s.length();
                if (i < len && s.charAt(i - 1) == '\r' && s.charAt(i) == '\n') {
                    ++i;
                }
                if (start == 0 || s.charAt(start - 1) != '\\') {
                    char c;
                    if (i < len && ((c = s.charAt(i)) == ' ' || c == '\t')) {
                        ++i;
                        while (i < len && ((c = s.charAt(i)) == ' ' || c == '\t')) {
                            ++i;
                        }
                        if (sb == null) {
                            sb = new StringBuilder(s.length());
                        }
                        if (start != 0) {
                            sb.append(s.substring(0, start));
                            sb.append(' ');
                        }
                        s = s.substring(i);
                        continue;
                    }
                    if (sb == null) {
                        sb = new StringBuilder(s.length());
                    }
                    sb.append(s.substring(0, i));
                    s = s.substring(i);
                    continue;
                }
                if (sb == null) {
                    sb = new StringBuilder(s.length());
                }
                sb.append(s.substring(0, start - 1));
                sb.append(s.substring(start, i));
                s = s.substring(i);
            } while ((i = s.indexOf(13)) >= 0 || (i = s.indexOf(10)) >= 0);
            sb.append(s);
            return sb.toString();
        }
        return headerLine;
    }

    private static String unfoldEncodedWords(String encodedWords) {
        return PAT_ENC_WORDS.matcher(encodedWords).replaceAll("$1$2");
    }

    public static String extractHeader(String headerName, InputStream inputStream, boolean closeStream) throws IOException {
        boolean close = closeStream;
        try {
            UnsynchronizedByteArrayOutputStream buffer = new UnsynchronizedByteArrayOutputStream(8192);
            int start = 0;
            int i = -1;
            boolean firstColonFound = false;
            boolean found = false;
            while ((i = inputStream.read()) != -1) {
                int count = 0;
                while (i == 13 || i == 10) {
                    if (!found) {
                        buffer.write(i);
                    }
                    if (i == 10) {
                        if (found) {
                            i = inputStream.read();
                            if (i != 32 && i != 9) {
                                String string = new String(buffer.toByteArray(), Charsets.US_ASCII);
                                return string;
                            }
                            buffer.write(13);
                            buffer.write(10);
                            buffer.write(i);
                        }
                        if (++count >= 2) {
                            String string = null;
                            return string;
                        }
                        i = inputStream.read();
                        if (i != 32 && i != 9) {
                            start = buffer.size();
                            firstColonFound = false;
                        }
                        buffer.write(i);
                    }
                    i = inputStream.read();
                }
                buffer.write(i);
                if (firstColonFound || i != 58) continue;
                firstColonFound = true;
                if (!new String(buffer.toByteArray(start, buffer.size() - start - 1), Charsets.US_ASCII).equalsIgnoreCase(headerName)) continue;
                buffer.reset();
                found = true;
            }
            String string = null;
            return string;
        }
        catch (IOException e) {
            close = true;
            throw e;
        }
        finally {
            if (close) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static void writeHeaders(MailPart p, OutputStream os) throws OXException {
        if (p instanceof MimeMailMessage) {
            MimeMessageUtility.writeHeaders((MimePart)((MimeMailMessage)p).getMimeMessage(), os);
            return;
        }
        if (p instanceof MimeMailPart) {
            MimeMessageUtility.writeHeaders(((MimeMailPart)p).getPart(), os);
            return;
        }
        try {
            LineOutputStream los = os instanceof LineOutputStream ? (LineOutputStream)os : new LineOutputStream(os);
            StringBuilder sb = new StringBuilder(256);
            Iterator<Map.Entry<String, String>> it = p.getHeadersIterator();
            while (it.hasNext()) {
                Map.Entry<String, String> entry = it.next();
                sb.setLength(0);
                sb.append(entry.getKey()).append(": ");
                sb.append(MimeMessageUtility.fold(sb.length(), entry.getValue()));
                los.writeln(sb);
            }
            los.writeln();
            os.flush();
        }
        catch (IOException e) {
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    public static void writeHeaders(Part p, OutputStream os) throws OXException {
        if (p instanceof MimePart) {
            MimeMessageUtility.writeHeaders((MimePart)p, os);
            return;
        }
        try {
            LineOutputStream los = os instanceof LineOutputStream ? (LineOutputStream)os : new LineOutputStream(os);
            Enumeration headers = p.getAllHeaders();
            StringBuilder sb = new StringBuilder(256);
            while (headers.hasMoreElements()) {
                Header header = (Header)headers.nextElement();
                sb.setLength(0);
                sb.append(header.getName()).append(": ");
                sb.append(MimeMessageUtility.fold(sb.length(), header.getValue()));
                los.writeln(sb);
            }
            los.writeln();
            os.flush();
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        catch (IOException e) {
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    public static void writeHeaders(MimePart p, OutputStream os) throws OXException {
        try {
            LineOutputStream los = os instanceof LineOutputStream ? (LineOutputStream)os : new LineOutputStream(os);
            Enumeration hdrLines = p.getNonMatchingHeaderLines(null);
            while (hdrLines.hasMoreElements()) {
                los.writeln((CharSequence)hdrLines.nextElement());
            }
            los.writeln();
            os.flush();
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        catch (IOException e) {
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File dropInvalidHeaders(File file, File newTempFile) {
        File file2;
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            int read;
            in = new BufferedInputStream(new FileInputStream(file));
            out = new BufferedOutputStream(new FileOutputStream(newTempFile));
            LineReaderInputStreamAdaptor instream = new LineReaderInputStreamAdaptor((InputStream)in, -1);
            int lineCount = 0;
            ByteArrayBuffer linebuf = new ByteArrayBuffer(64);
            DefaultFieldBuilder fieldBuilder = new DefaultFieldBuilder(-1);
            boolean endOfHeader = false;
            while (!endOfHeader) {
                RawField rawfield;
                byte ch;
                fieldBuilder.reset();
                do {
                    int len;
                    if ((len = linebuf.length()) > 0) {
                        fieldBuilder.append(linebuf);
                    }
                    linebuf.clear();
                    if (instream.readLine(linebuf) == -1) {
                        endOfHeader = true;
                    } else {
                        len = linebuf.length();
                        if (len > 0 && linebuf.byteAt(len - 1) == 10) {
                            --len;
                        }
                        if (len > 0 && linebuf.byteAt(len - 1) == 13) {
                            --len;
                        }
                        if (len != 0) continue;
                        endOfHeader = true;
                    }
                    break;
                } while (++lineCount <= 1 || (ch = linebuf.byteAt(0)) == 32 || ch == 9);
                if ((rawfield = fieldBuilder.build()) == null || X_ORIGINAL_HEADERS.equalsIgnoreCase(rawfield.getName())) continue;
                ByteArrayBuffer buffer = fieldBuilder.getRaw();
                out.write(buffer.buffer(), 0, buffer.length());
            }
            int l = 2048;
            byte[] buf = new byte[2048];
            while ((read = ((InputStream)in).read(buf, 0, 2048)) > 0) {
                out.write(buf, 0, read);
            }
            out.flush();
            file2 = newTempFile;
        }
        catch (Exception e) {
            File file3;
            try {
                file3 = file;
            }
            catch (Throwable throwable) {
                Streams.close((Closeable[])new Closeable[]{in, out});
                throw throwable;
            }
            Streams.close((Closeable[])new Closeable[]{in, out});
            return file3;
        }
        Streams.close((Closeable[])new Closeable[]{in, out});
        return file2;
    }

    static {
        HashSet<HeaderName> tmp = new HashSet<HeaderName>(4);
        tmp.add(HeaderName.valueOf("iso-8859-1"));
        tmp.add(HeaderName.valueOf("windows-1258"));
        tmp.add(HeaderName.valueOf("UTF-8"));
        tmp.add(HeaderName.valueOf("us-ascii"));
        ENCODINGS = Collections.unmodifiableSet(tmp);
        MailDateFormat mdf = new MailDateFormat();
        mdf.setTimeZone(TimeZoneUtils.getTimeZone("UTC"));
        MAIL_DATE_FORMAT = mdf;
        MDF_MAP = new ConcurrentHashMap<String, Future<MailDateFormat>>();
        PATTERN_EMBD_IMG = Pattern.compile("(<img[^>]+src=\"cid:)([^\"]+)(\"[^>]*/?>)", 34);
        PATTERN_EMBD_IMG_ALT = Pattern.compile("(<img[^>]+src=\")([0-9a-z&&[^.\\s>\"]]+\\.[0-9a-z&&[^.\\s>\"]]+)(\"[^>]*/?>)", 34);
        ENC_PATTERN = Pattern.compile("=\\?(\\S+?)\\?(\\S+?)\\?(.+?)\\?=");
        SPLITS = Pattern.compile(" *, *");
        PATTERN_REPLACE = Pattern.compile("([^\"]\\S+?)(\\s*)([;])(\\s*)");
        String regex = "(\\?=)(?:\r?\n(?:\t| +))(=\\?)";
        PAT_ENC_WORDS = Pattern.compile("(\\?=)(?:\r?\n(?:\t| +))(=\\?)");
    }

    private static final class LineOutputStream
    extends FilterOutputStream {
        private static final byte[] newline = new byte[]{13, 10};

        protected LineOutputStream(OutputStream out) {
            super(out);
        }

        protected void writeln(CharSequence s) throws IOException {
            this.out.write(LineOutputStream.getBytes(s));
            this.out.write(newline);
        }

        protected void writeln() throws IOException {
            this.out.write(newline);
        }

        private static byte[] getBytes(CharSequence s) {
            if (null == s) {
                return new byte[0];
            }
            int len = s.length();
            byte[] bytes = new byte[len];
            for (int i = 0; i < len; ++i) {
                bytes[i] = (byte)s.charAt(i);
            }
            return bytes;
        }
    }
}

