/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime.datasource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;

public final class StreamDataSource
implements DataSource {
    private String contentType;
    private final InputStreamProvider provider;

    public StreamDataSource(InputStreamProvider provider) {
        this(provider, null);
    }

    public StreamDataSource(InputStreamProvider provider, String contentType) {
        this.provider = provider;
        this.contentType = contentType == null ? "application/octet-stream" : contentType;
    }

    public InputStream getInputStream() throws IOException {
        return this.provider.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException(this.getClass().getName() + ".getOutputStream() isn't implemented");
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getName() {
        return this.provider.getName();
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public static interface InputStreamProvider {
        public InputStream getInputStream() throws IOException;

        public String getName();
    }
}

