/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.converters;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.Converter;
import com.openexchange.ajax.requesthandler.ResultConverter;
import com.openexchange.exception.OXException;
import com.openexchange.json.OXJSONWriter;
import com.openexchange.json.cache.JsonCacheService;
import com.openexchange.json.cache.JsonCaches;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailListField;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.ThreadedStructure;
import com.openexchange.mail.json.MailActionConstants;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.MailRequestSha1Calculator;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.mail.json.writer.MessageWriter;
import com.openexchange.mail.mime.MimeFilter;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.utils.DisplayMode;
import com.openexchange.preferences.ServerUserSetting;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;

public final class MailConverter
implements ResultConverter,
MailActionConstants {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(MailConverter.class));
    private static final MailConverter INSTANCE = new MailConverter();
    private static final MessageWriter.MailFieldWriter[] WRITER_IDS = MessageWriter.getMailFieldWriter(new MailListField[]{MailListField.ID, MailListField.FOLDER_ID});
    private static final Pattern SPLIT = Pattern.compile(" *, *");

    public static MailConverter getInstance() {
        return INSTANCE;
    }

    private MailConverter() {
    }

    @Override
    public String getInputFormat() {
        return "mail";
    }

    @Override
    public String getOutputFormat() {
        return "apiResponse";
    }

    @Override
    public ResultConverter.Quality getQuality() {
        return ResultConverter.Quality.GOOD;
    }

    @Override
    public void convert(AJAXRequestData requestData, AJAXRequestResult result, ServerSession session, Converter converter) throws OXException {
        this.convert2JSON(requestData, result, session);
        Response response = new Response(session);
        response.setData(result.getResultObject());
        response.setTimestamp(result.getTimestamp());
        response.setProperties(result.getResponseProperties());
        Collection<OXException> warnings = result.getWarnings();
        if (null != warnings && !warnings.isEmpty()) {
            for (OXException warning : warnings) {
                response.addWarning(warning);
            }
        }
        result.setResultObject(response);
    }

    public void convert2JSON(AJAXRequestData requestData, AJAXRequestResult result, ServerSession session) throws OXException {
        try {
            Object resultObject = result.getResultObject();
            if (null == resultObject) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)"Result object is null.");
                }
                result.setResultObject(JSONObject.NULL, "json");
                return;
            }
            String action = requestData.getParameter("action");
            if (resultObject instanceof MailMessage) {
                MailMessage mail = (MailMessage)resultObject;
                if ("get".equals(action)) {
                    this.convertSingle4Get(mail, requestData, result, session);
                } else {
                    this.convertSingle(mail, requestData, result, session);
                }
            } else if (resultObject instanceof ThreadedStructure) {
                this.convertThreadStructure((ThreadedStructure)resultObject, requestData, result, session);
            } else {
                Collection mails = (Collection)resultObject;
                if ("all".equalsIgnoreCase(action)) {
                    this.convertMultiple4All(mails, requestData, result, session);
                } else if ("list".equalsIgnoreCase(action)) {
                    this.convertMultiple4List(mails, requestData, result, session);
                } else {
                    this.convertMultiple4List(mails, requestData, result, session);
                }
            }
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create(e, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertThreadStructure(ThreadedStructure structure, AJAXRequestData requestData, AJAXRequestResult result, ServerSession session) throws OXException, JSONException {
        int[] columns = requestData.checkIntArray("columns");
        String[] headers = requestData.getParameterValues("headers");
        MessageWriter.MailFieldWriter[] writers = MessageWriter.getMailFieldWriter(MailListField.getFields(columns));
        MessageWriter.MailFieldWriter[] headerWriters = null == headers ? null : MessageWriter.getHeaderFieldWriter(headers);
        OXJSONWriter jsonWriter = new OXJSONWriter();
        boolean writeThreadAsObjects = AJAXRequestDataTools.parseBoolParameter("konfetti", requestData);
        boolean containsMultipleFolders = MailConverter.containsMultipleFolders(structure, new HashSet<String>(2));
        jsonWriter.array();
        try {
            int userId = session.getUserId();
            int contextId = session.getContextId();
            for (List<MailMessage> mails : structure.getMails()) {
                if (mails == null || mails.isEmpty()) continue;
                JSONObject jo = new JSONObject();
                this.writeThreadSortedMail(mails, jo, writers, headerWriters, containsMultipleFolders, writeThreadAsObjects, userId, contextId);
                jsonWriter.value(jo);
            }
        }
        finally {
            jsonWriter.endArray();
        }
        JSONValue newJsonValue = jsonWriter.getObject();
        result.setResultObject(newJsonValue, "json");
        MailRequest req = new MailRequest(requestData, session);
        boolean cache = req.optBool("cache", false);
        if (cache) {
            JsonCacheService jsonCache = JsonCaches.getCache();
            MailRequestSha1Calculator sha1Calculator = (MailRequestSha1Calculator)req.getRequest().getProperty("mail.sha1calc");
            if (null != jsonCache && null != sha1Calculator) {
                String sha1Sum = sha1Calculator.getSha1For(req);
                String id = "com.openexchange.mail." + sha1Sum;
                JSONValue jsonValue = (JSONValue)requestData.getProperty(id);
                if (!JsonCaches.areEqual((JSONValue)jsonValue, (JSONValue)newJsonValue)) {
                    ServerSession ses = req.getSession();
                    if (null == jsonValue) {
                        jsonCache.setIfDifferent(id, newJsonValue, result.getDuration(), ses.getUserId(), ses.getContextId());
                    } else {
                        jsonCache.set(id, newJsonValue, result.getDuration(), ses.getUserId(), ses.getContextId());
                    }
                }
            }
        }
    }

    private static boolean containsMultipleFolders(ThreadedStructure structure, Set<String> fullNames) {
        for (List<MailMessage> mails : structure.getMails()) {
            for (MailMessage mailMessage : mails) {
                if (!fullNames.add(mailMessage.getFolder()) || fullNames.size() <= 1) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean writeThreadAsObjects() {
        return false;
    }

    private void writeThreadSortedMail(List<MailMessage> mails, JSONObject jMail, MessageWriter.MailFieldWriter[] writers, MessageWriter.MailFieldWriter[] headerWriters, boolean containsMultipleFolders, boolean writeThreadAsObjects, int userId, int contextId) throws OXException, JSONException {
        int j;
        MailMessage mail = mails.get(0);
        int accountID = mail.getAccountId();
        for (j = 0; j < writers.length; ++j) {
            writers[j].writeField((JSONValue)jMail, mail, 0, true, accountID, userId, contextId);
        }
        if (null != headerWriters) {
            for (j = 0; j < headerWriters.length; ++j) {
                headerWriters[j].writeField((JSONValue)jMail, mail, 0, true, accountID, userId, contextId);
            }
        }
        int unreadCount = 0;
        JSONArray jChildMessages = new JSONArray();
        if (writeThreadAsObjects) {
            for (MailMessage child : mails) {
                int j2;
                JSONObject jChild = new JSONObject();
                accountID = child.getAccountId();
                for (j2 = 0; j2 < writers.length; ++j2) {
                    writers[j2].writeField((JSONValue)jChild, child, 0, true, accountID, userId, contextId);
                }
                if (null != headerWriters) {
                    for (j2 = 0; j2 < headerWriters.length; ++j2) {
                        headerWriters[j2].writeField((JSONValue)jChild, child, 0, true, accountID, userId, contextId);
                    }
                }
                jChildMessages.put((Object)jChild);
                if (child.isSeen()) continue;
                ++unreadCount;
            }
        } else if (containsMultipleFolders) {
            StringBuilder sb = new StringBuilder(16);
            char defaultSeparator = MailProperties.getInstance().getDefaultSeparator();
            for (MailMessage child : mails) {
                sb.setLength(0);
                jChildMessages.put((Object)sb.append(child.getFolder()).append(defaultSeparator).append(child.getMailId()).toString());
                if (child.isSeen()) continue;
                ++unreadCount;
            }
        } else {
            for (MailMessage child : mails) {
                jChildMessages.put((Object)child.getMailId());
                if (child.isSeen()) continue;
                ++unreadCount;
            }
        }
        jMail.put("thread", (Object)jChildMessages);
        jMail.put("unreadCount", unreadCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertMultiple4List(Collection<MailMessage> mails, AJAXRequestData requestData, AJAXRequestResult result, ServerSession session) throws OXException, JSONException {
        int[] columns = requestData.checkIntArray("columns");
        String[] headers = requestData.getParameterValues("headers");
        MessageWriter.MailFieldWriter[] writers = MessageWriter.getMailFieldWriter(MailListField.getFields(columns));
        MessageWriter.MailFieldWriter[] headerWriters = null == headers ? null : MessageWriter.getHeaderFieldWriter(headers);
        OXJSONWriter jsonWriter = new OXJSONWriter();
        jsonWriter.array();
        try {
            int userId = session.getUserId();
            int contextId = session.getContextId();
            for (MailMessage mail : mails) {
                int j;
                if (mail == null) continue;
                JSONArray ja = new JSONArray();
                int accountID = mail.getAccountId();
                for (j = 0; j < writers.length; ++j) {
                    writers[j].writeField((JSONValue)ja, mail, 0, false, accountID, userId, contextId);
                }
                if (null != headerWriters) {
                    for (j = 0; j < headerWriters.length; ++j) {
                        headerWriters[j].writeField((JSONValue)ja, mail, 0, false, accountID, userId, contextId);
                    }
                }
                jsonWriter.value(ja);
            }
        }
        finally {
            jsonWriter.endArray();
        }
        result.setResultObject(jsonWriter.getObject(), "json");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertMultiple4All(Collection<MailMessage> mails, AJAXRequestData requestData, AJAXRequestResult result, ServerSession session) throws OXException, JSONException {
        int[] columns = requestData.checkIntArray("columns");
        String sort = requestData.getParameter("sort");
        MailServletInterface mailInterface = this.getMailInterface(requestData, session);
        MessageWriter.MailFieldWriter[] writers = MessageWriter.getMailFieldWriter(MailListField.getFields(columns));
        int userId = session.getUserId();
        int contextId = session.getContextId();
        OXJSONWriter jsonWriter = new OXJSONWriter();
        jsonWriter.array();
        try {
            int accountId;
            JSONArray ja;
            if ("thread".equalsIgnoreCase(sort)) {
                for (MailMessage mail : mails) {
                    ja = new JSONArray();
                    if (mail != null) {
                        accountId = mail.getAccountId();
                        for (MessageWriter.MailFieldWriter writer : writers) {
                            writer.writeField((JSONValue)ja, mail, mail.getThreadLevel(), false, accountId, userId, contextId);
                        }
                    }
                    jsonWriter.value(ja);
                }
            } else {
                for (MailMessage mail : mails) {
                    ja = new JSONArray();
                    if (mail != null) {
                        accountId = mail.getAccountId();
                        for (MessageWriter.MailFieldWriter writer : writers) {
                            writer.writeField((JSONValue)ja, mail, 0, false, accountId, userId, contextId);
                        }
                    }
                    jsonWriter.value(ja);
                }
            }
        }
        finally {
            jsonWriter.endArray();
        }
        JSONValue newJsonValue = jsonWriter.getObject();
        result.setResultObject(newJsonValue, "json");
        MailRequest req = new MailRequest(requestData, session);
        boolean cache = req.optBool("cache", false);
        if (cache) {
            JsonCacheService jsonCache = JsonCaches.getCache();
            MailRequestSha1Calculator sha1Calculator = (MailRequestSha1Calculator)req.getRequest().getProperty("mail.sha1calc");
            if (null != jsonCache && null != sha1Calculator) {
                String sha1Sum = sha1Calculator.getSha1For(req);
                String id = "com.openexchange.mail." + sha1Sum;
                JSONValue jsonValue = (JSONValue)requestData.getProperty(id);
                if (!JsonCaches.areEqual((JSONValue)jsonValue, (JSONValue)newJsonValue)) {
                    ServerSession ses = req.getSession();
                    if (null == jsonValue) {
                        jsonCache.setIfDifferent(id, newJsonValue, result.getDuration(), ses.getUserId(), ses.getContextId());
                    } else {
                        jsonCache.set(id, newJsonValue, result.getDuration(), ses.getUserId(), ses.getContextId());
                    }
                }
            }
        }
    }

    private void convertSingle4Get(MailMessage mail, AJAXRequestData requestData, AJAXRequestResult result, ServerSession session) throws OXException {
        JSONObject jMail;
        boolean doUnseen;
        MimeFilter mimeFilter;
        int ttlMillis;
        String tmp = requestData.getParameter("edit");
        boolean editDraft = "1".equals(tmp) || Boolean.parseBoolean(tmp);
        tmp = requestData.getParameter("view");
        String view = null == tmp ? null : tmp.toLowerCase(Locale.ENGLISH);
        tmp = requestData.getParameter("unseen");
        boolean unseen = tmp != null && ("1".equals(tmp) || Boolean.parseBoolean(tmp));
        tmp = requestData.getParameter("token");
        boolean token = tmp != null && ("1".equals(tmp) || Boolean.parseBoolean(tmp));
        tmp = requestData.getParameter("ttlMillis");
        try {
            ttlMillis = tmp == null ? -1 : Integer.parseInt(tmp.trim());
        }
        catch (NumberFormatException e) {
            ttlMillis = -1;
        }
        tmp = requestData.getParameter("embedded");
        boolean embedded = tmp != null && ("1".equals(tmp) || Boolean.parseBoolean(tmp));
        tmp = requestData.getParameter("ignorable");
        if (MailConverter.isEmpty(tmp)) {
            mimeFilter = null;
        } else {
            MimeFilter mf;
            String[] strings = SPLIT.split(tmp, 0);
            int length = strings.length;
            if (1 == length && (mf = MimeFilter.filterFor(strings[0])) != null) {
                mimeFilter = mf;
            } else {
                ArrayList<String> ignorableContentTypes = new ArrayList<String>(length);
                for (int i = 0; i < length; ++i) {
                    String cts = strings[i];
                    if ("ics".equalsIgnoreCase(cts)) {
                        ignorableContentTypes.add("text/calendar");
                        ignorableContentTypes.add("application/ics");
                        continue;
                    }
                    ignorableContentTypes.add(cts);
                }
                mimeFilter = MimeFilter.filterFor(ignorableContentTypes);
            }
        }
        tmp = null;
        UserSettingMail usmNoSave = (UserSettingMail)session.getUserSettingMail().clone();
        usmNoSave.setNoSave(true);
        DisplayMode displayMode = AbstractMailAction.detectDisplayMode(editDraft, view, usmNoSave);
        String folderPath = requestData.checkParameter("folder");
        boolean wasUnseen = mail.containsPrevSeen() && !mail.isPrevSeen();
        boolean bl = doUnseen = unseen && wasUnseen;
        if (doUnseen) {
            mail.setFlag(32, false);
            int unreadMsgs = mail.getUnreadMessages();
            mail.setUnreadMessages(unreadMsgs < 0 ? 0 : unreadMsgs + 1);
        }
        MailServletInterface mailInterface = this.getMailInterface(requestData, session);
        ArrayList<OXException> warnings = new ArrayList<OXException>(2);
        try {
            jMail = MessageWriter.writeMailMessage(mail.getAccountId(), mail, displayMode, embedded, session, usmNoSave, warnings, token, ttlMillis, mimeFilter);
        }
        catch (OXException e) {
            if (MailExceptionCode.MAIL_NOT_FOUND.equals(e)) {
                LOG.warn((Object)("Requested mail could not be found. " + "Most likely this is caused by concurrent access of multiple clients " + "while one performed a delete on affected mail."), (Throwable)e);
            }
            throw e;
        }
        if (mail.containsPrevSeen()) {
            try {
                jMail.put("unseen", wasUnseen);
            }
            catch (JSONException e) {
                LOG.warn((Object)"Couldn't set \"unseen\" field in JSON mail representation.", (Throwable)e);
            }
        }
        result.setResultObject(jMail, "json");
        if (doUnseen) {
            String uid;
            String tmp2 = requestData.getParameter("id");
            if (null == tmp2) {
                tmp2 = requestData.getParameter("message_id");
                if (null == tmp2) {
                    throw AjaxExceptionCodes.MISSING_PARAMETER.create("id");
                }
                uid = mailInterface.getMailIDByMessageID(folderPath, tmp2);
            } else {
                uid = tmp2;
            }
            mailInterface.updateMessageFlags(folderPath, new String[]{uid}, 32, false);
        } else if (wasUnseen) {
            try {
                ServerUserSetting setting = ServerUserSetting.getInstance();
                int contextId = session.getContextId();
                int userId = session.getUserId();
                if (setting.isContactCollectionEnabled(contextId, userId).booleanValue() && setting.isContactCollectOnMailAccess(contextId, userId).booleanValue()) {
                    AbstractMailAction.triggerContactCollector(session, mail);
                }
            }
            catch (OXException e) {
                LOG.warn((Object)"Contact collector could not be triggered.", (Throwable)e);
            }
        }
    }

    private void convertSingle(MailMessage mail, AJAXRequestData requestData, AJAXRequestResult result, ServerSession session) throws OXException {
        String view = requestData.getParameter("view");
        view = null == view ? null : view.toLowerCase(Locale.US);
        String tmp = requestData.getParameter("embedded");
        boolean embedded = tmp != null && ("1".equals(tmp) || Boolean.parseBoolean(tmp));
        tmp = null;
        UserSettingMail usmNoSave = (UserSettingMail)session.getUserSettingMail().clone();
        usmNoSave.setNoSave(true);
        DisplayMode displayMode = AbstractMailAction.detectDisplayMode(true, view, usmNoSave);
        ArrayList<OXException> warnings = new ArrayList<OXException>(2);
        JSONObject jsonObject = MessageWriter.writeMailMessage(mail.getAccountId(), mail, displayMode, embedded, session, usmNoSave, warnings, false, -1);
        result.addWarnings(warnings);
        result.setResultObject(jsonObject, "json");
    }

    private MailServletInterface getMailInterface(AJAXRequestData request, ServerSession session) throws OXException {
        MailServletInterface mailInterface = (MailServletInterface)request.getState().optProperty("com.openexchange.mail.json.mailInterface");
        if (mailInterface == null) {
            mailInterface = MailServletInterface.getInstance(session);
            request.getState().putProperty("com.openexchange.mail.json.mailInterface", mailInterface);
        }
        return mailInterface;
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Character.isWhitespace(string.charAt(i));
        }
        return isWhitespace;
    }
}

