/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.event;

import com.openexchange.session.Session;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public final class PooledEvent
implements Delayed {
    private volatile long stamp;
    private final int contextId;
    private final int userId;
    private final int accountId;
    private final String topic;
    private final String fullname;
    private final Session session;
    private final boolean contentRelated;
    private final boolean immediateDelivery;
    private final int hash;
    private boolean async = true;

    public PooledEvent(int contextId, int userId, int accountId, String fullname, boolean contentRelated, boolean immediateDelivery, Session session) {
        this("com/openexchange/push", contextId, userId, accountId, fullname, contentRelated, immediateDelivery, session);
    }

    public PooledEvent(String topic, int contextId, int userId, int accountId, String fullname, boolean contentRelated, boolean immediateDelivery, Session session) {
        this.topic = topic;
        this.stamp = System.currentTimeMillis();
        this.contextId = contextId;
        this.userId = userId;
        this.accountId = accountId;
        this.fullname = fullname;
        this.contentRelated = contentRelated;
        this.immediateDelivery = immediateDelivery;
        this.session = session;
        int prime = 31;
        int result = 1;
        result = 31 * result + (topic == null ? 0 : topic.hashCode());
        result = 31 * result + accountId;
        result = 31 * result + contextId;
        result = 31 * result + (fullname == null ? 0 : fullname.hashCode());
        result = 31 * result + userId;
        result = 31 * result + (contentRelated ? 1 : 0);
        this.hash = result = 31 * result + (immediateDelivery ? 1 : 0);
    }

    public PooledEvent setAsync(boolean async) {
        this.async = async;
        return this;
    }

    public boolean isAsync() {
        return !this.immediateDelivery || this.async;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return this.immediateDelivery ? 0L : unit.convert(10000L - (System.currentTimeMillis() - this.stamp), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        long thisStamp = this.stamp;
        long otherStamp = ((PooledEvent)o).stamp;
        return thisStamp < otherStamp ? -1 : (thisStamp == otherStamp ? 0 : 1);
    }

    public String getTopic() {
        return this.topic;
    }

    public void touch() {
        this.stamp = System.currentTimeMillis();
    }

    public long lastAccessed() {
        return this.stamp;
    }

    public boolean equalsByUser(int userId, int contextId) {
        return this.userId == userId && this.contextId == contextId;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PooledEvent)) {
            return false;
        }
        PooledEvent other = (PooledEvent)obj;
        if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
            return false;
        }
        if (this.accountId != other.accountId) {
            return false;
        }
        if (this.contextId != other.contextId) {
            return false;
        }
        if (this.fullname == null ? other.fullname != null : !this.fullname.equals(other.fullname)) {
            return false;
        }
        if (this.userId != other.userId) {
            return false;
        }
        return this.contentRelated == other.contentRelated;
    }

    public int getContextId() {
        return this.contextId;
    }

    public int getUserId() {
        return this.userId;
    }

    public int getAccountId() {
        return this.accountId;
    }

    public String getFullname() {
        return this.fullname;
    }

    public Session getSession() {
        return this.session;
    }

    public boolean isContentRelated() {
        return this.contentRelated;
    }
}

