/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.dataobjects;

import com.openexchange.exception.OXException;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.HeaderName;
import com.openexchange.mail.mime.PlainTextAddress;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.tools.TimeZoneUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MailDateFormat;
import org.apache.commons.logging.Log;

public abstract class MailMessage
extends MailPart {
    private static final long serialVersionUID = 8585899349289256569L;
    private static final transient Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(MailMessage.class));
    private static final String HDR_REFERENCES = "References";
    private static final String HDR_MESSAGE_ID = "Message-ID";
    public static final int FLAG_ANSWERED = 1;
    public static final int FLAG_DELETED = 2;
    public static final int FLAG_DRAFT = 4;
    public static final int FLAG_FLAGGED = 8;
    public static final int FLAG_RECENT = 16;
    public static final int FLAG_SEEN = 32;
    public static final int FLAG_USER = 64;
    public static final int FLAG_SPAM = 128;
    public static final int FLAG_FORWARDED = 256;
    public static final int FLAG_READ_ACK = 512;
    public static final String USER_FORWARDED = "$Forwarded";
    public static final String USER_READ_ACK = "$MDNSent";
    public static final int PRIORITY_HIGHEST = 1;
    public static final int PRIORITY_HIGH = 2;
    public static final int PRIORITY_NORMAL = 3;
    public static final int PRIORITY_LOW = 4;
    public static final int PRIORITY_LOWEST = 5;
    public static final String COLOR_LABEL_PREFIX = "$cl_";
    public static final String COLOR_LABEL_PREFIX_OLD = "cl_";
    public static final int COLOR_LABEL_NONE = 0;
    private static final InternetAddress[] EMPTY_ADDRS = new InternetAddress[0];
    private int flags;
    private boolean b_flags;
    private boolean prevSeen;
    private boolean b_prevSeen;
    private HashSet<InternetAddress> from;
    private boolean b_from;
    private HashSet<InternetAddress> to;
    private boolean b_to;
    private HashSet<InternetAddress> cc;
    private boolean b_cc;
    private HashSet<InternetAddress> bcc;
    private boolean b_bcc;
    private int threadLevel;
    private boolean b_threadLevel;
    private String subject;
    private boolean b_subject;
    private Date sentDate;
    private boolean b_sentDate;
    private Date receivedDate;
    private boolean b_receivedDate;
    private HashSet<HeaderName> userFlags;
    private boolean b_userFlags;
    private int colorLabel = 0;
    private boolean b_colorLabel;
    private int priority = 3;
    private boolean b_priority;
    private InternetAddress dispositionNotification;
    private boolean b_dispositionNotification;
    private String folder;
    private boolean b_folder;
    private int accountId = 0;
    private boolean b_accountId;
    private String accountName;
    private boolean b_accountName;
    private boolean hasAttachment;
    private boolean b_hasAttachment;
    private boolean appendVCard;
    private boolean b_appendVCard;
    private int recentCount;
    private boolean b_recentCount;
    private static final MailDateFormat MAIL_DATE_FORMAT = new MailDateFormat();
    private static final String[] EMPTY_UF;
    private static final Pattern SPLIT;

    public static int getColorLabelIntValue(String cl) throws OXException {
        if (!MailMessage.isColorLabel(cl)) {
            throw MailExceptionCode.UNKNOWN_COLOR_LABEL.create(cl);
        }
        try {
            return Integer.parseInt(cl.substring(cl.charAt(0) == '$' ? COLOR_LABEL_PREFIX.length() : COLOR_LABEL_PREFIX_OLD.length()));
        }
        catch (NumberFormatException e) {
            throw MailExceptionCode.UNKNOWN_COLOR_LABEL.create(e, cl);
        }
    }

    public static boolean isColorLabel(String cl) {
        return cl != null && (cl.startsWith(COLOR_LABEL_PREFIX) || cl.startsWith(COLOR_LABEL_PREFIX_OLD));
    }

    public static int parseColorLabel(String cl, int defaultValue) {
        try {
            return Integer.parseInt(cl.substring('$' == cl.charAt(0) ? COLOR_LABEL_PREFIX.length() : COLOR_LABEL_PREFIX_OLD.length()));
        }
        catch (NumberFormatException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Invalid color label: " + cl), (Throwable)e);
            }
            return defaultValue;
        }
    }

    public static String getColorLabelStringValue(int cl) {
        return COLOR_LABEL_PREFIX + cl;
    }

    protected MailMessage() {
    }

    public void addFrom(InternetAddress addr) {
        if (null == addr) {
            this.b_from = true;
            return;
        }
        if (null == this.from) {
            this.from = new LinkedHashSet<InternetAddress>();
            this.b_from = true;
        }
        this.from.add(addr);
    }

    public void addFrom(InternetAddress[] addrs) {
        if (null == addrs) {
            this.b_from = true;
            return;
        }
        if (null == this.from) {
            this.from = new LinkedHashSet<InternetAddress>();
            this.b_from = true;
        }
        this.from.addAll(Arrays.asList(addrs));
    }

    public boolean containsFrom() {
        return this.b_from || this.containsHeader("From");
    }

    public void removeFrom() {
        this.from = null;
        this.removeHeader("From");
        this.b_from = false;
    }

    public InternetAddress[] getFrom() {
        if (!this.b_from) {
            String fromStr = this.getFirstHeader("From");
            if (fromStr == null) {
                return EMPTY_ADDRS;
            }
            try {
                this.addFrom(QuotedInternetAddress.parse(fromStr, true));
            }
            catch (AddressException e) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
                this.addFrom(new PlainTextAddress(fromStr));
            }
        }
        return this.from == null ? EMPTY_ADDRS : this.from.toArray(new InternetAddress[this.from.size()]);
    }

    public void addTo(InternetAddress addr) {
        if (null == addr) {
            this.b_to = true;
            return;
        }
        if (null == this.to) {
            this.to = new LinkedHashSet<InternetAddress>();
            this.b_to = true;
        }
        this.to.add(addr);
    }

    public void addTo(InternetAddress[] addrs) {
        if (null == addrs) {
            this.b_to = true;
            return;
        }
        if (null == this.to) {
            this.to = new LinkedHashSet<InternetAddress>();
            this.b_to = true;
        }
        this.to.addAll(Arrays.asList(addrs));
    }

    public boolean containsTo() {
        return this.b_to || this.containsHeader("To");
    }

    public void removeTo() {
        this.to = null;
        this.removeHeader("To");
        this.b_to = false;
    }

    public InternetAddress[] getTo() {
        if (!this.b_to) {
            String toStr = this.getFirstHeader("To");
            if (toStr == null) {
                return EMPTY_ADDRS;
            }
            try {
                this.addTo(QuotedInternetAddress.parse(toStr, true));
            }
            catch (AddressException e) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
                this.addTo(new PlainTextAddress(toStr));
            }
        }
        return this.to == null ? EMPTY_ADDRS : this.to.toArray(new InternetAddress[this.to.size()]);
    }

    public void addCc(InternetAddress addr) {
        if (null == addr) {
            this.b_cc = true;
            return;
        }
        if (null == this.cc) {
            this.cc = new LinkedHashSet<InternetAddress>();
            this.b_cc = true;
        }
        this.cc.add(addr);
    }

    public void addCc(InternetAddress[] addrs) {
        if (null == addrs) {
            this.b_cc = true;
            return;
        }
        if (null == this.cc) {
            this.cc = new LinkedHashSet<InternetAddress>();
            this.b_cc = true;
        }
        this.cc.addAll(Arrays.asList(addrs));
    }

    public boolean containsCc() {
        return this.b_cc || this.containsHeader("Cc");
    }

    public void removeCc() {
        this.cc = null;
        this.removeHeader("Cc");
        this.b_cc = false;
    }

    public InternetAddress[] getCc() {
        if (!this.b_cc) {
            String ccStr = this.getFirstHeader("Cc");
            if (ccStr == null) {
                return EMPTY_ADDRS;
            }
            try {
                this.addCc(QuotedInternetAddress.parse(ccStr, true));
            }
            catch (AddressException e) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
                this.addCc(new PlainTextAddress(ccStr));
            }
        }
        return this.cc == null ? EMPTY_ADDRS : this.cc.toArray(new InternetAddress[this.cc.size()]);
    }

    public void addBcc(InternetAddress addr) {
        if (null == addr) {
            this.b_bcc = true;
            return;
        }
        if (null == this.bcc) {
            this.bcc = new LinkedHashSet<InternetAddress>();
            this.b_bcc = true;
        }
        this.bcc.add(addr);
    }

    public void addBcc(InternetAddress[] addrs) {
        if (null == addrs) {
            this.b_bcc = true;
            return;
        }
        if (null == this.bcc) {
            this.bcc = new LinkedHashSet<InternetAddress>();
            this.b_bcc = true;
        }
        this.bcc.addAll(Arrays.asList(addrs));
    }

    public boolean containsBcc() {
        return this.b_bcc || this.containsHeader("Bcc");
    }

    public void removeBcc() {
        this.bcc = null;
        this.removeHeader("Bcc");
        this.b_bcc = false;
    }

    public InternetAddress[] getBcc() {
        if (!this.b_bcc) {
            String bccStr = this.getFirstHeader("Bcc");
            if (bccStr == null) {
                return EMPTY_ADDRS;
            }
            try {
                this.addBcc(QuotedInternetAddress.parse(bccStr, true));
            }
            catch (AddressException e) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
                this.addBcc(new PlainTextAddress(bccStr));
            }
        }
        return this.bcc == null ? EMPTY_ADDRS : this.bcc.toArray(new InternetAddress[this.bcc.size()]);
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean isAnswered() {
        return (this.flags & 1) == 1;
    }

    public boolean isDeleted() {
        return (this.flags & 2) == 2;
    }

    public boolean isDraft() {
        return (this.flags & 4) == 4;
    }

    public boolean isFlagged() {
        return (this.flags & 8) == 8;
    }

    public boolean isRecent() {
        return (this.flags & 0x10) == 16;
    }

    public boolean isSeen() {
        return (this.flags & 0x20) == 32;
    }

    public boolean isSpam() {
        return (this.flags & 0x80) == 128;
    }

    public boolean isForwarded() {
        return (this.flags & 0x100) == 256;
    }

    public boolean isReadAcknowledgment() {
        return (this.flags & 0x200) == 512;
    }

    public boolean isUser() {
        return (this.flags & 0x40) == 64;
    }

    public boolean containsFlags() {
        return this.b_flags;
    }

    public void removeFlags() {
        this.flags = 0;
        this.b_flags = false;
    }

    public void setFlags(int flags) {
        this.flags = flags;
        this.b_flags = true;
    }

    public void setFlag(int flag, boolean enable) throws OXException {
        if (flag == 1 || flag % 2 != 0) {
            throw MailExceptionCode.ILLEGAL_FLAG_ARGUMENT.create(flag);
        }
        this.flags = enable ? this.flags | flag : this.flags & ~flag;
        this.b_flags = true;
    }

    public boolean isPrevSeen() {
        return this.prevSeen;
    }

    public boolean containsPrevSeen() {
        return this.b_prevSeen;
    }

    public void removePrevSeen() {
        this.prevSeen = false;
        this.b_prevSeen = false;
    }

    public void setPrevSeen(boolean prevSeen) {
        this.prevSeen = prevSeen;
        this.b_prevSeen = true;
    }

    public int getThreadLevel() {
        return this.threadLevel;
    }

    public boolean containsThreadLevel() {
        return this.b_threadLevel;
    }

    public void removeThreadLevel() {
        this.threadLevel = 0;
        this.b_threadLevel = false;
    }

    public void setThreadLevel(int threadLevel) {
        this.threadLevel = threadLevel;
        this.b_threadLevel = true;
    }

    public String getSubject() {
        String subjectStr;
        if (!this.b_subject && (subjectStr = MimeMessageUtility.checkNonAscii(this.getFirstHeader("Subject"))) != null) {
            this.setSubject(MimeMessageUtility.decodeMultiEncodedHeader(subjectStr));
        }
        return this.subject;
    }

    public boolean containsSubject() {
        return this.b_subject || this.containsHeader("Subject");
    }

    public void removeSubject() {
        this.subject = null;
        this.removeHeader("Subject");
        this.b_subject = false;
    }

    public void setSubject(String subject) {
        this.subject = subject;
        this.b_subject = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getSentDate() {
        String sentDateStr;
        if (!this.b_sentDate && (sentDateStr = this.getFirstHeader("Date")) != null) {
            MailDateFormat mailDateFormat = MAIL_DATE_FORMAT;
            synchronized (mailDateFormat) {
                try {
                    Date parsedDate = MAIL_DATE_FORMAT.parse(sentDateStr);
                    if (null != parsedDate) {
                        this.setSentDate(parsedDate);
                    }
                }
                catch (ParseException e) {
                    LOG.warn((Object)("Date string could not be parsed: " + sentDateStr), (Throwable)e);
                }
            }
        }
        return this.sentDate == null ? null : new Date(this.sentDate.getTime());
    }

    public boolean containsSentDate() {
        return this.b_sentDate || this.containsHeader("Date");
    }

    public void removeSentDate() {
        this.sentDate = null;
        this.removeHeader("Date");
        this.b_sentDate = false;
    }

    public void setSentDate(Date sentDate) {
        this.sentDate = sentDate == null ? null : new Date(sentDate.getTime());
        this.b_sentDate = true;
    }

    public Date getReceivedDate() {
        return this.receivedDate == null ? null : new Date(this.receivedDate.getTime());
    }

    public Date getReceivedDateDirect() {
        return this.receivedDate;
    }

    public boolean containsReceivedDate() {
        return this.b_receivedDate;
    }

    public void removeReceivedDate() {
        this.receivedDate = null;
        this.b_receivedDate = false;
    }

    public void setReceivedDate(Date receivedDate) {
        this.receivedDate = receivedDate == null ? null : new Date(receivedDate.getTime());
        this.b_receivedDate = true;
    }

    public void addUserFlag(String userFlag) {
        if (userFlag == null) {
            return;
        }
        if (this.userFlags == null) {
            this.userFlags = new HashSet();
            this.b_userFlags = true;
        }
        this.userFlags.add(HeaderName.valueOf(userFlag));
    }

    public void addUserFlags(String[] userFlags) {
        if (userFlags == null) {
            return;
        }
        if (this.userFlags == null) {
            this.userFlags = new HashSet();
            this.b_userFlags = true;
        }
        for (int i = 0; i < userFlags.length; ++i) {
            this.userFlags.add(HeaderName.valueOf(userFlags[i]));
        }
    }

    public boolean containsUserFlags() {
        return this.b_userFlags;
    }

    public void removeUserFlags() {
        this.userFlags = null;
        this.b_userFlags = false;
    }

    public String[] getUserFlags() {
        if (this.containsUserFlags() && null != this.userFlags) {
            if (this.userFlags.isEmpty()) {
                return EMPTY_UF;
            }
            int size = this.userFlags.size();
            ArrayList<String> retval = new ArrayList<String>(size);
            Iterator<HeaderName> iter = this.userFlags.iterator();
            for (int i = 0; i < size; ++i) {
                retval.add(iter.next().toString());
            }
            return retval.toArray(new String[size]);
        }
        return EMPTY_UF;
    }

    public int getColorLabel() {
        return this.colorLabel;
    }

    public boolean containsColorLabel() {
        return this.b_colorLabel;
    }

    public void removeColorLabel() {
        this.colorLabel = 0;
        this.b_colorLabel = false;
    }

    public void setColorLabel(int colorLabel) {
        this.colorLabel = colorLabel;
        this.b_colorLabel = true;
    }

    public int getPriority() {
        if (!this.b_priority) {
            String imp = this.getFirstHeader("Importance");
            if (imp != null) {
                this.setPriority(MimeMessageConverter.parseImportance(imp));
            } else {
                String prioStr = this.getFirstHeader("X-Priority");
                if (prioStr != null) {
                    this.setPriority(MimeMessageConverter.parsePriority(prioStr));
                }
            }
        }
        return this.priority;
    }

    public boolean containsPriority() {
        return this.b_priority || this.containsHeader("Importance") || this.containsHeader("X-Priority");
    }

    public void removePriority() {
        this.priority = 3;
        this.removeHeader("Importance");
        this.removeHeader("X-Priority");
        this.b_priority = false;
    }

    public void setPriority(int priority) {
        this.priority = priority;
        this.b_priority = true;
    }

    public InternetAddress getDispositionNotification() {
        String dispNotTo;
        if (!this.b_dispositionNotification && (dispNotTo = this.getFirstHeader("Disposition-Notification-To")) != null) {
            try {
                this.setDispositionNotification(new QuotedInternetAddress(dispNotTo, true));
            }
            catch (AddressException e) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
                this.setDispositionNotification(new PlainTextAddress(dispNotTo));
            }
        }
        return this.dispositionNotification;
    }

    public boolean containsDispositionNotification() {
        return this.b_dispositionNotification || this.containsHeader("Disposition-Notification-To");
    }

    public void removeDispositionNotification() {
        this.dispositionNotification = null;
        this.removeHeader("Disposition-Notification-To");
        this.b_dispositionNotification = false;
    }

    public void setDispositionNotification(InternetAddress dispositionNotification) {
        this.dispositionNotification = dispositionNotification;
        this.b_dispositionNotification = true;
    }

    public String getFolder() {
        return this.folder;
    }

    public boolean containsFolder() {
        return this.b_folder;
    }

    public void removeFolder() {
        this.folder = null;
        this.b_folder = false;
    }

    public void setFolder(String folder) {
        this.folder = folder;
        this.b_folder = true;
    }

    public int getAccountId() {
        return this.accountId;
    }

    public boolean containsAccountId() {
        return this.b_accountId;
    }

    public void removeAccountId() {
        this.accountId = 0;
        this.b_accountId = false;
    }

    public void setAccountId(int accountId) {
        this.accountId = accountId;
        this.b_accountId = true;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public boolean containsAccountName() {
        return this.b_accountName;
    }

    public void removeAccountName() {
        this.accountName = null;
        this.b_accountName = false;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
        this.b_accountName = true;
    }

    public boolean hasAttachment() {
        return this.hasAttachment;
    }

    public boolean containsHasAttachment() {
        return this.b_hasAttachment;
    }

    public void removeHasAttachment() {
        this.hasAttachment = false;
        this.b_hasAttachment = false;
    }

    public void setHasAttachment(boolean hasAttachment) {
        this.hasAttachment = hasAttachment;
        this.b_hasAttachment = true;
    }

    @Override
    public Object clone() {
        MailMessage clone = (MailMessage)super.clone();
        if (this.from != null) {
            clone.from = new LinkedHashSet<InternetAddress>(this.from);
        }
        if (this.to != null) {
            clone.to = new LinkedHashSet<InternetAddress>(this.to);
        }
        if (this.cc != null) {
            clone.cc = new LinkedHashSet<InternetAddress>(this.cc);
        }
        if (this.bcc != null) {
            clone.bcc = new LinkedHashSet<InternetAddress>(this.bcc);
        }
        if (this.receivedDate != null) {
            clone.receivedDate = new Date(this.receivedDate.getTime());
        }
        if (this.sentDate != null) {
            clone.sentDate = new Date(this.sentDate.getTime());
        }
        if (this.userFlags != null) {
            clone.userFlags = new HashSet<HeaderName>(this.userFlags);
        }
        return clone;
    }

    public boolean isAppendVCard() {
        return this.appendVCard;
    }

    public boolean containsAppendVCard() {
        return this.b_appendVCard;
    }

    public void removeAppendVCard() {
        this.appendVCard = false;
        this.b_appendVCard = false;
    }

    public void setAppendVCard(boolean appendVCard) {
        this.appendVCard = appendVCard;
        this.b_appendVCard = true;
    }

    public int getRecentCount() {
        return this.recentCount;
    }

    public boolean containsRecentCount() {
        return this.b_recentCount;
    }

    public void removeRecentCount() {
        this.recentCount = 0;
        this.b_recentCount = false;
    }

    public void setRecentCount(int recentCount) {
        this.recentCount = recentCount;
        this.b_recentCount = true;
    }

    public MailPath getMailPath() {
        return new MailPath(this.getAccountId(), this.getFolder(), this.getMailId());
    }

    public String getMessageId() {
        return this.getFirstHeader(HDR_MESSAGE_ID);
    }

    public String[] getReferences() {
        String references = this.getFirstHeader(HDR_REFERENCES);
        if (MailMessage.isEmpty(references)) {
            return null;
        }
        return SPLIT.split(MimeMessageUtility.decodeMultiEncodedHeader(references));
    }

    public abstract String getMailId();

    public abstract void setMailId(String var1);

    public abstract int getUnreadMessages();

    public abstract void setUnreadMessages(int var1);

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Character.isWhitespace(string.charAt(i));
        }
        return isWhitespace;
    }

    static {
        MAIL_DATE_FORMAT.setTimeZone(TimeZoneUtils.getTimeZone("GMT"));
        EMPTY_UF = new String[0];
        SPLIT = Pattern.compile(" +");
    }
}

