/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.conversion;

import com.openexchange.conversion.Data;
import com.openexchange.conversion.DataArguments;
import com.openexchange.conversion.DataExceptionCodes;
import com.openexchange.conversion.DataProperties;
import com.openexchange.conversion.SimpleData;
import com.openexchange.exception.OXException;
import com.openexchange.mail.FullnameArgument;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.conversion.MailPartDataSource;
import com.openexchange.mail.dataobjects.MailFolder;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.permission.MailPermission;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.session.Session;
import java.io.InputStream;

public final class ICalMailPartDataSource
extends MailPartDataSource {
    public static final String PROPERTY_OWNER = "com.openexchange.conversion.owner";

    public <D> Data<D> getData(Class<? extends D> type, DataArguments dataArguments, Session session) throws OXException {
        if (!InputStream.class.equals(type)) {
            throw DataExceptionCodes.TYPE_NOT_SUPPORTED.create(new Object[]{type.getName()});
        }
        FullnameArgument arg = MailFolderUtility.prepareMailFolderParam(dataArguments.get(ARGS[0]));
        String fullname = arg.getFullname();
        String mailId = dataArguments.get(ARGS[1]);
        String sequenceId = dataArguments.get(ARGS[2]);
        DataProperties properties = new DataProperties();
        MailPart mailPart = this.getMailPart(arg.getAccountId(), fullname, mailId, sequenceId, session, properties);
        ContentType contentType = mailPart.getContentType();
        if (contentType == null) {
            throw DataExceptionCodes.ERROR.create(new Object[]{"Missing header 'Content-Type' in requested mail part"});
        }
        if (!contentType.isMimeType("text/*calendar")) {
            throw DataExceptionCodes.ERROR.create(new Object[]{"Requested mail part is not an ICal: " + contentType.getBaseType()});
        }
        properties.put("com.openexchange.conversion.content-type", contentType.getBaseType());
        String charset = contentType.getCharsetParameter();
        if (charset == null) {
            properties.put("com.openexchange.conversion.charset", MailProperties.getInstance().getDefaultMimeCharset());
        } else {
            properties.put("com.openexchange.conversion.charset", charset);
        }
        properties.put("com.openexchange.conversion.size", Long.toString(mailPart.getSize()));
        properties.put("com.openexchange.conversion.name", mailPart.getFileName());
        try {
            return new SimpleData((Object)mailPart.getInputStream(), properties);
        }
        catch (OXException e) {
            throw new OXException(e);
        }
    }

    private MailPart getMailPart(int accountId, String fullname, String mailId, String sequenceId, Session session, DataProperties properties) throws OXException {
        MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess;
        try {
            mailAccess = MailAccess.getInstance(session, accountId);
            mailAccess.connect();
        }
        catch (OXException e) {
            throw new OXException(e);
        }
        try {
            MailFolder folder = mailAccess.getFolderStorage().getFolder(fullname);
            if (folder.isShared()) {
                MailPermission[] permissions = folder.getPermissions();
                boolean found = false;
                boolean foundMoreThanOne = false;
                int ownerId = 0;
                for (MailPermission perm : permissions) {
                    if (!perm.isFolderAdmin() || perm.isGroupPermission()) continue;
                    if (found) {
                        foundMoreThanOne = true;
                    }
                    ownerId = perm.getEntity();
                    found = true;
                }
                if (found && !foundMoreThanOne && ownerId > 0) {
                    properties.put(PROPERTY_OWNER, Integer.toString(ownerId));
                }
            }
            MailPart mailPart = mailAccess.getMessageStorage().getAttachment(fullname, mailId, sequenceId);
            mailPart.loadContent();
            MailPart mailPart2 = mailPart;
            return mailPart2;
        }
        catch (OXException e) {
            throw new OXException(e);
        }
        finally {
            mailAccess.close(true);
        }
    }
}

